/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data.npc;

import cc.thonly.reverie_dreams.data.skin.SkinType;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleFastEntity;
import cc.thonly.reverie_dreams.item.base.SpawnEggItem;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import cc.thonly.reverie_dreams.util.IdentifierGetter;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NPCRole
implements CodecStep<NPCRole>,
OwnerBinding<NPCRole>,
BuiltinObject,
Translatable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NPCRole.class);
    public static final Codec<NPCRole> CODEC = Codec.unit(NPCRole::new);
    public static final List<class_1792> NPC_SPAWN_EGG_ITEM_LIST = new LinkedList<class_1792>();
    private class_2960 id;
    private SkinType skinType;
    private class_1299<NPCRoleFastEntity> entityType;
    private class_1792 spawnEgg;
    private boolean hasBuilt = false;
    private RegistryHandler<NPCRole> owner;

    private NPCRole() {
    }

    public NPCRole(class_2960 id, SkinType skinType) {
        this.id = id;
        this.skinType = skinType;
    }

    public boolean isPresent() {
        return this.entityType != null;
    }

    public boolean isEmpty() {
        return this.entityType == null;
    }

    public class_1299<NPCRoleFastEntity> get() {
        return this.entityType;
    }

    public class_1792 getEgg() {
        return this.spawnEgg;
    }

    @Override
    public String translateKey() {
        return this.entityType.method_5882();
    }

    public NPCRole build() {
        if (this.hasBuilt) {
            return this;
        }
        try {
            class_1299 build = class_1299.class_1300.method_5903((type, world) -> new NPCRoleFastEntity((class_1299<? extends class_1308>)type, world, this.skinType), (class_1311)class_1311.field_17715).method_5905(NPCRole.of(this.id));
            class_1299 entityType = NPCRole.registerEntity(this.id, build);
            FabricDefaultAttributeRegistry.register(entityType, (class_5132)BaseNPCLikeEntity.createAttributes());
            class_2960 spawnEggId = class_2960.method_60655((String)this.id.method_12836(), (String)(this.id.method_12832() + "_spawn_egg"));
            class_1792 spawnEgg = NPCRole.registerNPCSpawnEggItem(new SpawnEggItem(spawnEggId, (class_1299<? extends class_1308>)build, new class_1792.class_1793()));
            this.entityType = build;
            this.spawnEgg = spawnEgg;
            this.hasBuilt = true;
        }
        catch (Exception e) {
            log.error("Can't register role entity type {}", (Object)this.id.toString());
        }
        return this;
    }

    @Override
    public Codec<NPCRole> getCodec() {
        return CODEC;
    }

    protected static <T extends class_1297> class_1299<T> registerEntity(class_2960 id, class_1299<T> entityType) {
        class_1299 entityTypeRef = (class_1299)class_2378.method_10230((class_2378)class_7923.field_41177, (class_2960)id, entityType);
        PolymerEntityUtils.registerType((class_1299[])new class_1299[]{entityTypeRef});
        return entityTypeRef;
    }

    protected static class_1792 registerNPCSpawnEggItem(IdentifierGetter item) {
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)item.getIdentifier(), (Object)((class_1792)item));
        NPC_SPAWN_EGG_ITEM_LIST.add((class_1792)item);
        return (class_1792)item;
    }

    private static class_5321<class_1299<?>> of(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)id);
    }

    @Generated
    public void setId(class_2960 id) {
        this.id = id;
    }

    @Generated
    public void setSkinType(SkinType skinType) {
        this.skinType = skinType;
    }

    @Generated
    public void setEntityType(class_1299<NPCRoleFastEntity> entityType) {
        this.entityType = entityType;
    }

    @Generated
    public void setSpawnEgg(class_1792 spawnEgg) {
        this.spawnEgg = spawnEgg;
    }

    @Generated
    public void setHasBuilt(boolean hasBuilt) {
        this.hasBuilt = hasBuilt;
    }

    @Override
    @Generated
    public void setOwner(RegistryHandler<NPCRole> owner) {
        this.owner = owner;
    }

    @Generated
    public class_2960 getId() {
        return this.id;
    }

    @Generated
    public SkinType getSkinType() {
        return this.skinType;
    }

    @Generated
    public class_1299<NPCRoleFastEntity> getEntityType() {
        return this.entityType;
    }

    @Generated
    public class_1792 getSpawnEgg() {
        return this.spawnEgg;
    }

    @Generated
    public boolean isHasBuilt() {
        return this.hasBuilt;
    }

    @Override
    @Generated
    public RegistryHandler<NPCRole> getOwner() {
        return this.owner;
    }
}

