/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data.skin;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.skin.SkinConfig;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.skin.MobSkinTypes;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import cc.thonly.reverie_dreams.util.skin.SkinFetcher;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinType
implements CodecStep<SkinType>,
OwnerBinding<SkinType>,
BuiltinObject,
Translatable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SkinType.class);
    private static final Map<class_2960, MannequinInfo> INFO = new Object2ObjectLinkedOpenHashMap();
    public static Codec<SkinType> UNIT_CODEC = Codec.unit(SkinType::new);
    public static Codec<SkinType> CODEC;
    private class_2960 id;
    private String value;
    private String signature;
    private Property property;
    private SkinConfig config;
    private RegistryHandler<SkinType> owner;

    private SkinType() {
    }

    public SkinType(class_2960 id) {
        this.id = id;
        this.value = "null";
        this.signature = "null";
    }

    public SkinType(class_2960 id, String value, String signature) {
        this.id = id;
        this.value = value;
        this.signature = signature;
        this.valid();
    }

    @Override
    public String translateKey() {
        Property property = this.get();
        return property.name() + "|" + String.valueOf(this.id);
    }

    public Property get() {
        if (this.config == null) {
            log.warn("Unable to get skin properties until data pack is loaded");
            return MobSkinTypes.DEFAULT.get();
        }
        if (this.property == null) {
            Optional<Property> skinFromNPCSkin = SkinFetcher.getSkinFromNPCSkin(this.config);
            if (skinFromNPCSkin.isPresent()) {
                log.debug("Fetching {} skin from networking", (Object)this.id);
                this.setProperty(skinFromNPCSkin.get());
            } else {
                this.setProperty(SkinType.texture(this.value, this.signature));
            }
        }
        return this.property;
    }

    private void valid() {
        try {
            class_2960 class_29602 = ReverieDreams.id("entity/player/%s".formatted(this.id.method_12832()));
        }
        catch (Exception err) {
            log.error("Can't parse role code", (Throwable)err);
        }
    }

    private static Property texture(String value, String signature) {
        return new Property("textures", value, signature);
    }

    @Override
    public Codec<SkinType> getCodec() {
        if (CODEC == null) {
            CODEC = RecordCodecBuilder.create(x -> x.group((App)class_2960.field_25139.fieldOf("SkinType").forGetter(SkinType::getId)).apply((Applicative)x, RegistryHandlers.SKIN_TYPE::method_63535));
        }
        return CODEC;
    }

    public static void onReload(class_3300 manager) {
        for (SkinType skinType : RegistryHandlers.SKIN_TYPE.values()) {
            skinType.setProperty(null);
        }
    }

    @Generated
    public void setId(class_2960 id) {
        this.id = id;
    }

    @Generated
    public class_2960 getId() {
        return this.id;
    }

    @Generated
    public void setProperty(Property property) {
        this.property = property;
    }

    @Generated
    public void setConfig(SkinConfig config) {
        this.config = config;
    }

    @Generated
    public SkinConfig getConfig() {
        return this.config;
    }

    @Override
    @Generated
    public RegistryHandler<SkinType> getOwner() {
        return this.owner;
    }

    @Override
    @Generated
    public void setOwner(RegistryHandler<SkinType> owner) {
        this.owner = owner;
    }

    static enum PlayerSkinType {
        SLIM("slim", "slim"),
        WIDE("wide", "default");

        private final String name;
        private final String modelMetadata;

        private PlayerSkinType(String name, String modelMetadata) {
            this.name = name;
            this.modelMetadata = modelMetadata;
        }
    }

    private record MannequinInfo(class_2960 texture, Optional<class_2960> capeTexture, Optional<class_2960> elytraTexture, PlayerSkinType model) {
    }
}

