/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.recipe.entry;

import cc.thonly.reverie_dreams.recipe.BaseRecipe;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.type.KitchenRecipeType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lombok.Generated;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KitchenRecipe
extends BaseRecipe {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KitchenRecipe.class);
    public static final Codec<KitchenRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("recipe_type").forGetter(KitchenRecipe::getRecipeType), (App)Codec.list(ItemStackWrapper.CODEC).fieldOf("ingredients").forGetter(KitchenRecipe::getIngredients), (App)ItemStackWrapper.CODEC.fieldOf("output").forGetter(KitchenRecipe::getOutput), (App)Codec.DOUBLE.optionalFieldOf("cost_time", (Object)5.0).forGetter(KitchenRecipe::getCostTime)).apply((Applicative)instance, KitchenRecipe::new));
    protected final class_2960 recipeType;
    protected final List<ItemStackWrapper> ingredients;
    protected final ItemStackWrapper output;
    private final Double costTime;

    public KitchenRecipe(KitchenRecipeType.KitchenType kitchenType, List<ItemStackWrapper> ingredients, ItemStackWrapper output, Number costTime) {
        this(kitchenType.toId(), ingredients, output, costTime);
    }

    public KitchenRecipe(class_2960 recipeType, List<ItemStackWrapper> ingredients, ItemStackWrapper output, Number costTime) {
        this.recipeType = recipeType;
        this.ingredients = ingredients;
        this.output = output;
        this.costTime = costTime.doubleValue();
        if (this.ingredients.size() > 5) {
            log.error("Kitchen Recipe {} ingredients size > 5 in {}", (Object)recipeType, (Object)(String.valueOf(recipeType) + ".json"));
        }
    }

    @Override
    public ItemStackWrapper getOutput() {
        return new ItemStackWrapper(this.output.getItemStack().method_7972());
    }

    public KitchenRecipeType.KitchenType getType() {
        return KitchenRecipeType.KitchenType.getFromId(this.recipeType);
    }

    @Generated
    public static KitchenRecipeBuilder builder() {
        return new KitchenRecipeBuilder();
    }

    @Generated
    public KitchenRecipeBuilder toBuilder() {
        return new KitchenRecipeBuilder().recipeType(this.recipeType).ingredients(this.ingredients).output(this.output).costTime(this.costTime);
    }

    @Generated
    public class_2960 getRecipeType() {
        return this.recipeType;
    }

    @Generated
    public List<ItemStackWrapper> getIngredients() {
        return this.ingredients;
    }

    @Generated
    public Double getCostTime() {
        return this.costTime;
    }

    @Generated
    public String toString() {
        return "KitchenRecipe(recipeType=" + String.valueOf(this.getRecipeType()) + ", ingredients=" + String.valueOf(this.getIngredients()) + ", output=" + String.valueOf(this.getOutput()) + ", costTime=" + this.getCostTime() + ")";
    }

    @Generated
    public KitchenRecipe(class_2960 recipeType, List<ItemStackWrapper> ingredients, ItemStackWrapper output, Double costTime) {
        this.recipeType = recipeType;
        this.ingredients = ingredients;
        this.output = output;
        this.costTime = costTime;
    }

    @Generated
    public static class KitchenRecipeBuilder {
        @Generated
        private class_2960 recipeType;
        @Generated
        private List<ItemStackWrapper> ingredients;
        @Generated
        private ItemStackWrapper output;
        @Generated
        private Double costTime;

        @Generated
        KitchenRecipeBuilder() {
        }

        @Generated
        public KitchenRecipeBuilder recipeType(class_2960 recipeType) {
            this.recipeType = recipeType;
            return this;
        }

        @Generated
        public KitchenRecipeBuilder ingredients(List<ItemStackWrapper> ingredients) {
            this.ingredients = ingredients;
            return this;
        }

        @Generated
        public KitchenRecipeBuilder output(ItemStackWrapper output) {
            this.output = output;
            return this;
        }

        @Generated
        public KitchenRecipeBuilder costTime(Double costTime) {
            this.costTime = costTime;
            return this;
        }

        @Generated
        public KitchenRecipe build() {
            return new KitchenRecipe(this.recipeType, this.ingredients, this.output, this.costTime);
        }

        @Generated
        public String toString() {
            return "KitchenRecipe.KitchenRecipeBuilder(recipeType=" + String.valueOf(this.recipeType) + ", ingredients=" + String.valueOf(this.ingredients) + ", output=" + String.valueOf(this.output) + ", costTime=" + this.costTime + ")";
        }
    }
}

