/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util;

import cc.thonly.reverie_dreams.block.MusicBlock;
import cc.thonly.reverie_dreams.item.prop.MusicalInstrumentItem;
import cc.thonly.reverie_dreams.server.DelayedTask;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import nota.model.RepeatMode;
import nota.model.Song;
import nota.player.EntitySongPlayer;
import nota.player.PositionSongPlayer;
import nota.player.SongPlayer;
import nota.utils.NBSDecoderPlus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TouhouNotaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TouhouNotaUtils.class);
    public static final String STR_PATH = "config/reverie_dreams/nota";
    public static final Path PATH = Paths.get("config/reverie_dreams/nota", new String[0]);
    public static final Map<String, SongPlayer> id2SongCache = new HashMap<String, SongPlayer>();
    public static final Map<class_1937, Map<Long, SongPlayer>> blockMusicPlayCache = new HashMap<class_1937, Map<Long, SongPlayer>>();
    public static int MAX_DISTANCE = 32;

    public static void playAt(class_1937 world, class_2338 pos, String select) {
        Song song;
        if (select == null) {
            return;
        }
        String filename = select.intern();
        MinecraftServer server = world.method_8503();
        assert (server != null);
        class_3324 playerManager = server.method_3760();
        try {
            song = NBSDecoderPlus.parse(TouhouNotaUtils.getFilePath(filename).toFile());
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u97f3\u4e50\u5931\u8d25: {}", (Object)filename, (Object)e);
            return;
        }
        DelayedTask.create(server, 2.0f, () -> {
            Map blockPos2SongPlayer = blockMusicPlayCache.computeIfAbsent(world, k -> new HashMap());
            SongPlayer songPlayer = (SongPlayer)blockPos2SongPlayer.get(pos.method_10063());
            if (songPlayer != null) {
                songPlayer.setPlaying(false);
                blockPos2SongPlayer.remove(pos.method_10063());
            }
            PositionSongPlayer psp = new PositionSongPlayer(song, world);
            psp.setBlockPos(new class_2338((class_2382)pos));
            psp.setDistance(MAX_DISTANCE);
            psp.setRepeatMode(RepeatMode.ALL);
            for (class_3222 sPlayer : playerManager.method_14571()) {
                psp.addPlayer((class_1657)sPlayer);
            }
            psp.setPlaying(true);
            blockPos2SongPlayer.put(pos.method_10063(), psp);
            AtomicInteger age = new AtomicInteger();
            DelayedTask.whenTick(server, () -> {
                if (world.method_22340(pos)) {
                    return false;
                }
                class_2680 blockState = world.method_8320(pos);
                return !(blockState.method_26204() instanceof MusicBlock);
            }, 4.0f, () -> {
                psp.setPlaying(false);
                blockPos2SongPlayer.remove(pos.method_10063());
            }, () -> {
                if (age.get() <= 4) {
                    age.getAndIncrement();
                } else {
                    age.set(0);
                }
                if (psp.isPlaying()) {
                    class_3218 serverWorld = (class_3218)world;
                    class_2400 particleEffect = class_2398.field_11224;
                    List players = serverWorld.method_18456();
                    for (class_3222 player : players) {
                        double squaredDistance;
                        if (psp.hasPlayer((class_1657)player) || (squaredDistance = pos.method_19770((class_2374)player.method_19538())) > (double)(MAX_DISTANCE * MAX_DISTANCE)) continue;
                        psp.addPlayer((class_1657)player);
                    }
                    double px = (double)pos.method_10263() + 0.5;
                    double py = pos.method_10264() + 1;
                    double pz = (double)pos.method_10260() + 0.5;
                    serverWorld.method_65096((class_2394)particleEffect, px, py, pz, 1, 0.0, 0.0, 0.0, 0.01);
                }
            });
        });
    }

    public static void play(class_1309 user, String playingMusic, class_2766 noteBlockInstrument) {
        Song song;
        if (user.method_37908().field_9236) {
            return;
        }
        String filename = playingMusic;
        playingMusic = playingMusic.replaceAll(" ", "_");
        playingMusic = playingMusic.toLowerCase();
        MinecraftServer server = user.method_5682();
        assert (server != null);
        class_3324 playerManager = server.method_3760();
        try {
            song = NBSDecoderPlus.parse(TouhouNotaUtils.getFilePath(filename).toFile(), noteBlockInstrument);
        }
        catch (Exception e) {
            log.error("\u8bfb\u53d6\u97f3\u4e50\u5931\u8d25: {}", (Object)playingMusic, (Object)e);
            if (user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7c\u65e0\u6cd5\u8bfb\u53d6\u97f3\u4e50\uff1a" + playingMusic)), false);
            }
            return;
        }
        String id = "music_" + user.method_5845();
        SongPlayer prev = id2SongCache.get(id);
        if (prev != null) {
            prev.setPlaying(false);
            id2SongCache.remove(id);
        }
        EntitySongPlayer esp = new EntitySongPlayer(song);
        esp.setId(class_2960.method_60654((String)UUID.randomUUID().toString()));
        esp.setEntity((class_1297)user);
        esp.setDistance(32);
        esp.setRepeatMode(RepeatMode.NONE);
        for (class_3222 sPlayer : playerManager.method_14571()) {
            esp.addPlayer((class_1657)sPlayer);
        }
        esp.setPlaying(true);
        id2SongCache.put(id, esp);
        DelayedTask.whenTick(server, () -> {
            class_1799 handStack = user.method_6047();
            class_1799 offStack = user.method_6079();
            return !(handStack.method_7909() instanceof MusicalInstrumentItem) && !(offStack.method_7909() instanceof MusicalInstrumentItem);
        }, 2.0f, () -> {
            esp.setPlaying(false);
            id2SongCache.remove(id);
        }, () -> {
            if (esp.isPlaying()) {
                class_3218 serverWorld = (class_3218)user.method_37908();
                class_2400 particleEffect = class_2398.field_11224;
                class_243 frontVec = user.method_5828(1.0f);
                double px = user.method_23317() + frontVec.field_1352 * 0.5;
                double py = user.method_23318() + (double)user.method_5751() - 0.1;
                double pz = user.method_23321() + frontVec.field_1350 * 0.5;
                serverWorld.method_65096((class_2394)particleEffect, px, py, pz, 2, 0.05, 0.05, 0.05, 0.01);
            }
        });
    }

    public static List<String> getFileNames() {
        try {
            return Files.list(PATH).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.getFileName().toString().toLowerCase().endsWith(".nbs")).map(path -> path.getFileName().toString()).toList();
        }
        catch (Exception e) {
            log.warn("\u626b\u63cf\u97f3\u4e50\u76ee\u5f55\u5931\u8d25", (Throwable)e);
            return new ArrayList<String>();
        }
    }

    public static Path getFilePath(String filename) {
        return PATH.resolve(filename);
    }

    static {
        try {
            if (!Files.exists(PATH, new LinkOption[0])) {
                Files.createDirectories(PATH, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            log.error("Failed to create directory: config/reverie_dreams/nota", (Throwable)e);
        }
    }
}

