/*
 * Decompiled with CFR 0.152.
 */
package nota.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import nota.Nota;
import nota.event.SongEndEvent;
import nota.event.SongStartEvent;
import nota.event.SongTickEvent;
import nota.model.Playlist;
import nota.model.RepeatMode;
import nota.model.Song;
import nota.model.playmode.ChannelMode;
import nota.model.playmode.MonoMode;

public abstract class SongPlayer {
    class_2960 id = class_2960.method_60654((String)"noteblock-api:unidentified");
    protected Song song;
    protected Playlist playlist;
    protected int currentSongIndex = 0;
    public boolean playing = false;
    protected boolean fading = false;
    protected short tick = (short)-1;
    protected Map<UUID, Boolean> playerList = new ConcurrentHashMap<UUID, Boolean>();
    protected boolean autoDestroy = false;
    protected boolean destroyed = false;
    protected byte volume = (byte)100;
    float songDelay = 50.0f;
    protected RepeatMode repeat = RepeatMode.ALL;
    protected Nota api;
    protected ChannelMode channelMode = new MonoMode();
    protected boolean enable10Octave = false;
    protected final MinecraftServer server;
    Timer timer = new Timer();

    public SongPlayer(Song song) {
        this(new Playlist(song));
    }

    public SongPlayer(Playlist playlist) {
        this.playlist = playlist;
        this.api = Nota.getAPI();
        this.song = playlist.get(this.currentSongIndex);
        this.songDelay = this.song.getDelay() * 50.0f;
        this.server = this.api.getServer();
        this.restartTask((long)this.songDelay);
    }

    public boolean isEnable10Octave() {
        return this.enable10Octave;
    }

    public void setEnable10Octave(boolean enable10Octave) {
        this.enable10Octave = enable10Octave;
    }

    private synchronized void play() {
        for (UUID uuid : this.playerList.keySet()) {
            class_3222 player = Nota.getAPI().getServer().method_3760().method_14602(uuid);
            if (player == null) continue;
            this.playTick((class_1657)player, this.tick);
        }
    }

    private synchronized void onTaskRun(TimerTask task) {
        if (this.server != this.api.getServer() && (this.destroyed || Nota.getAPI().isDisabling())) {
            task.cancel();
        }
        if (this.playing) {
            this.tick = (short)(this.tick + 1);
            if (this.tick == 0) {
                ((SongStartEvent)SongStartEvent.EVENT.invoker()).onSongStart(this);
            }
            if (this.tick > this.song.getLength()) {
                ((SongEndEvent)SongEndEvent.EVENT.invoker()).onSongEnd(this);
                this.tick = (short)-1;
                if (this.playlist.hasNext(this.currentSongIndex)) {
                    ++this.currentSongIndex;
                    this.song = this.playlist.get(this.currentSongIndex);
                    this.songDelay = this.song.getDelay() * 50.0f;
                    this.playSong(this.currentSongIndex);
                    this.restartTask((long)this.songDelay);
                    task.cancel();
                    return;
                }
                this.currentSongIndex = 0;
                this.song = this.playlist.get(this.currentSongIndex);
                this.songDelay = this.song.getDelay() * 50.0f;
                if (this.repeat.equals((Object)RepeatMode.ALL)) {
                    this.restartTask((long)this.songDelay);
                    task.cancel();
                    return;
                }
                this.restartTask((long)this.songDelay);
                task.cancel();
                this.playing = false;
                if (this.autoDestroy) {
                    task.cancel();
                }
                return;
            }
            ((SongTickEvent)SongTickEvent.EVENT.invoker()).onSongTick(this);
            for (UUID uuid : this.playerList.keySet()) {
                class_3222 player;
                MinecraftServer server = Nota.getAPI().getServer();
                if (server == null || (player = server.method_3760().method_14602(uuid)) == null) continue;
                this.playTick((class_1657)player, this.tick);
            }
        }
    }

    private synchronized void restartTask(long delay) {
        this.timer.schedule(new TimerTask(){

            @Override
            public synchronized void run() {
                SongPlayer.this.onTaskRun(this);
            }
        }, 0L, delay);
    }

    public class_2960 getId() {
        return this.id;
    }

    public void setId(class_2960 id) {
        this.id = id;
    }

    public boolean hasPlayer(class_1657 player) {
        return this.playerList.containsKey(player.method_5667());
    }

    public Set<UUID> getPlayerUUIDs() {
        HashSet<UUID> uuids = new HashSet<UUID>(this.playerList.keySet());
        return Collections.unmodifiableSet(uuids);
    }

    public void addPlayer(class_1657 player) {
        this.addPlayer(player.method_5667());
    }

    public void addPlayer(UUID playerUuid) {
        if (!this.playerList.containsKey(playerUuid)) {
            this.playerList.put(playerUuid, false);
            ArrayList<SongPlayer> songs = Nota.getSongPlayersByPlayer(playerUuid);
            if (songs == null) {
                songs = new ArrayList();
            }
            songs.add(this);
            Nota.setSongPlayersByPlayer(playerUuid, songs);
        }
    }

    public boolean getAutoDestroy() {
        return this.autoDestroy;
    }

    public void setAutoDestroy(boolean autoDestroy) {
        this.autoDestroy = autoDestroy;
    }

    public abstract void playTick(class_1657 var1, int var2);

    public void destroy() {
        this.destroyed = true;
        this.playing = false;
        this.setTick((short)-1);
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean playing) {
        this.playing = playing;
    }

    public short getTick() {
        return this.tick;
    }

    public void setTick(short tick) {
        this.tick = tick;
    }

    public void removePlayer(class_1657 player) {
        this.removePlayer(player.method_5667());
    }

    public void removePlayer(UUID playerUuid) {
        this.playerList.remove(playerUuid);
        if (Nota.getSongPlayersByPlayer(playerUuid) == null) {
            return;
        }
        ArrayList<SongPlayer> songs = new ArrayList<SongPlayer>(Nota.getSongPlayersByPlayer(playerUuid));
        songs.remove(this);
        Nota.setSongPlayersByPlayer(playerUuid, songs);
        if (this.playerList.isEmpty() && this.autoDestroy) {
            this.destroy();
        }
    }

    public byte getVolume() {
        return this.volume;
    }

    public void setVolume(byte volume) {
        if (volume > 100) {
            volume = (byte)100;
        } else if (volume < 0) {
            volume = 0;
        }
        this.volume = volume;
    }

    public Song getSong() {
        return this.song;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public void setPlaylist(Playlist playlist) {
        this.playlist = playlist;
    }

    public int getPlayedSongIndex() {
        return this.currentSongIndex;
    }

    public void playSong(int index) {
        if (this.playlist.exist(index)) {
            this.song = this.playlist.get(index);
            this.currentSongIndex = index;
            this.tick = (short)-1;
        }
    }

    public void playNextSong() {
        this.tick = this.song.getLength();
    }

    public void setRepeatMode(RepeatMode repeatMode) {
        this.repeat = repeatMode;
    }

    public RepeatMode getRepeatMode() {
        return this.repeat;
    }

    public ChannelMode getChannelMode() {
        return this.channelMode;
    }
}

