package cc.thonly.polymer.block;

import cc.thonly.polymer.block.model.TransparentFlatTripWire;
import cc.thonly.reverie_dreams.block.base.BaseFumoBlock;
import cc.thonly.reverie_dreams.registry.content.FumoTypes;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.model.generic.BSMMParticleBlock;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

public class FumoImpl implements PolymerTexturedBlock, FactoryBlock, BSMMParticleBlock {
    private final BaseFumoBlock fumoBlock;

    public FumoImpl(BaseFumoBlock fumoBlock) {
        this.fumoBlock = fumoBlock;
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return TransparentFlatTripWire.TRANSPARENT_FLAT_TRIPIWIRE;
    }

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(initialBlockState, this.fumoBlock.getOffsets());
    }

    public static final class Model extends ElementHolder {
        private final class_2248 block;
        private final ItemDisplayElement main;

        public Model(class_2680 state, class_243 offsets) {
            this.block = state.method_26204();
            this.main = ItemDisplayElementUtil.createSimple(state.method_26204().method_8389());
            this.main.setDisplaySize(this.getDisplaySizeWidth(), this.getDisplaySizeHeight());
            this.main.setOffset(this.modifyOffset(offsets));
            this.main.setScale(this.getScale());
            this.main.setItemDisplayContext(class_811.field_4315);
            var yaw = state.method_11654(BaseFumoBlock.FACING_16).getYaw();
            this.main.setYaw(yaw);
            this.addElement(this.main);
        }

        public class_243 modifyOffset(class_243 offsets) {
            if (this.block == FumoTypes.TAN_CIRNO.block()) {
                return offsets.method_1019(new class_243(0, 0.5, 0));
            }
            return offsets;
        }

        public Vector3f getScale() {
            if (this.block == FumoTypes.TAN_CIRNO.block()) {
                return new Vector3f(2f);
            }
            return new Vector3f(1f);
        }

        public float getDisplaySizeWidth() {
            return 1f;
        }

        public float getDisplaySizeHeight() {
            return 1f;
        }
    }
}
