package cc.thonly.polymer.block;

import cc.thonly.polymer.block.model.TransparentFlatTripWire;
import cc.thonly.reverie_dreams.block.entity.FoodDisplayBlockEntity;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.BlockBoundAttachment;
import eu.pb4.polymer.virtualentity.api.attachment.HolderAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

import java.util.HashMap;
import java.util.Map;

public class ItemStackDisplayImpl implements FactoryBlock, TransparentFlatTripWire {
    public static final Map<class_3218, Map<Long, Model>> MAPPING = new Object2ObjectOpenHashMap<>();
    public static final Map<Long, Model> POS_TO_MODEL = new HashMap<>();

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        var model = new Model(world, initialBlockState.method_26204(), initialBlockState, pos);
        Map<Long, Model> longModelMap = MAPPING.computeIfAbsent(world, w -> new HashMap<>());
        longModelMap.put(pos.method_10063(), model);
        return model;
    }

    @Getter
    public static class Model extends BlockModel {
        private final class_3218 serverWorld;
        private final class_2248 block;
        private final class_2338 blockPos;
        private final ItemDisplayElement main;
        private FoodDisplayBlockEntity blockEntity;
        private final ItemDisplayElement item;

        public Model(class_3218 serverWorld, class_2248 block, class_2680 initialBlockState, class_2338 blockPos) {
            this.serverWorld = serverWorld;
            this.block = block;
            this.blockPos = blockPos;

            this.main = ItemDisplayElementUtil.createSimple(initialBlockState.method_26204().method_8389());
            this.main.setScale(new Vector3f(1.8f));
            this.main.setOffset(new class_243(0, -0.05, 0));
            this.item = ItemDisplayElementUtil.createSimple(class_1802.field_8162);
            this.item.setScale(new Vector3f(0.5f));
            this.item.setOffset(new class_243(0, -0.22, 0));

            addElement(this.main);
            addElement(this.item);
        }

        public void updateItem(class_2680 blockState) {
            class_2586 blockEntity = this.serverWorld.method_8321(this.blockPos);
            if (this.blockEntity == null && blockEntity instanceof FoodDisplayBlockEntity itemStackDisplayBlockEntity) {
                this.blockEntity = itemStackDisplayBlockEntity;
            }

            ItemStackWrapper item;
            if (this.blockEntity != null && !class_1799.method_7973(this.blockEntity.getItem().getItemStack(), this.item.getItem())) {
                removeElement(this.item);
                item = this.blockEntity.getItem();
                this.item.setItem(item.getItemStack().copy());
                this.item.setOffset(new class_243(0, -0.22, 0));
                this.item.setRotation((float) 0, (float) this.blockEntity.getYaw() + 180);
                addElement(this.item);
            }
        }

        @Override
        public void notifyUpdate(HolderAttachment.UpdateType updateType) {
            if (updateType == BlockBoundAttachment.BLOCK_STATE_UPDATE) {
                updateItem(this.blockState());
            }
            this.tick();
            super.notifyUpdate(updateType);
        }
    }
}
