package cc.thonly.polymer.block;

import cc.thonly.reverie_dreams.block.base.ModelBlock;
import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.block.model.generic.BSMMParticleBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import lombok.Getter;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_811;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class ModelFactoryImpl implements PolymerTexturedBlock, FactoryBlock, BSMMParticleBlock {
    private final ModelBlock block;

    public ModelFactoryImpl(ModelBlock block) {
        this.block = block;
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10499.method_9564();
    }

    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new Model(world, pos, initialBlockState, this.block);
    }

    @Getter
    public static final class Model extends BlockModel {
        private final ModelBlock block;
        private final ItemDisplayElement main;

        public Model(class_3218 world, class_2338 pos, class_2680 initialBlockState, ModelBlock block) {
            this.block = block;
            this.main = ItemDisplayElementUtil.createSimple(block.method_8389());
            this.main.setItemDisplayContext(class_811.field_4315);
            var yaw = initialBlockState.method_11654(ModelBlock.FACING_16).getYaw();
            this.main.setYaw(yaw);
            this.addElement(this.main);
        }
    }
}
