package cc.thonly.polymer.entity;

import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.List;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5629;
import net.minecraft.class_811;
import net.minecraft.class_8113;

public record DanmakuImpl(DanmakuEntity danmakuEntity) implements PolymerEntity {
    public DanmakuImpl {

    }

    @Override
    public void modifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial) {
        PolymerEntity.super.modifyRawTrackedData(data, player, initial);
        setTileProjectileData(data, initial);
    }

    @Override
    public void onEntityTrackerTick(Set<class_5629> listeners) {
        PolymerEntity.super.onEntityTrackerTick(listeners);
    }

    public void setTileProjectileData(List<class_2945.class_7834<?>> data, boolean initial) {
        if (initial && !this.danmakuEntity.method_37908().field_9236) {
            var sendBase = true;
            class_2945.class_7834<?> rRoll = null;
            for (int i = 0; i < data.size(); i++) {
                var roll = data.get(i);
                if (roll.comp_1115() == DanmakuEntity.ROLL.comp_2327() && roll.comp_1116() == DanmakuEntity.ROLL.comp_2328()) {
                    data.set(i, class_2945.class_7834.method_46360(
                            DisplayTrackedData.LEFT_ROTATION,
                            new Quaternionf()
                                    .rotateY(class_3532.field_29845)
                                    .rotateZ((float) roll.comp_1117())));
                    sendBase = false;
                    rRoll = roll;
                    break;
                }
            }

            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TELEPORTATION_DURATION, 3));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.INTERPOLATION_DURATION, 0));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.SCALE, new Vector3f(this.danmakuEntity.getProperties().getScale() * 0.85f * 0.65f)));
            if (this.danmakuEntity.getProperties().isTile()) {
                data.add(class_2945.class_7834.method_46360(DisplayTrackedData.BILLBOARD, (byte) class_8113.class_8114.field_42409.ordinal()));
            } else {
                data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TRANSLATION, new Vector3f(0, -0.1f, 0)));
                data.add(class_2945.class_7834.method_46360(DisplayTrackedData.INTERPOLATION_DURATION, 2));
                data.add(class_2945.class_7834.method_46360(DisplayTrackedData.TELEPORTATION_DURATION, 4));
                if (sendBase) {
                    data.add(class_2945.class_7834.method_46360(DisplayTrackedData.LEFT_ROTATION, new Quaternionf().rotateX(class_3532.field_29845)));
                }
            }

            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.Item.ITEM, this.danmakuEntity.method_54759()));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.Item.ITEM_DISPLAY, class_811.field_4317.method_48961()));
        }
    }

    @Override
    public class_1299<?> getPolymerEntityType(PacketContext packetContext) {
        return class_1299.field_42456;
    }

}
