package cc.thonly.polymer.entity;

import cc.thonly.polymer.PolymerEntityHelper;
import cc.thonly.reverie_dreams.entity.holder.MagicBroomHolder;
import cc.thonly.reverie_dreams.entity.misc.MagicBroomEntity;
import cc.thonly.reverie_dreams.registry.content.item.RDEntityHolderItems;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_811;
import net.minecraft.class_9334;

public record MagicBroomImpl(MagicBroomEntity magicBroomEntity) implements PolymerEntity, PolymerHolderEntity {
    public static final WeakHashMap<class_1297, ItemDisplayElement> ELEMENTS = new WeakHashMap<>();

    public MagicBroomImpl {
        PolymerEntityHelper.addEntityHolderModel(this);
    }

    @Override
    public void onCreated() {
        this.magicBroomEntity.method_5875(true);
        var x = new ItemDisplayElement();
        var holder = new MagicBroomHolder(this.magicBroomEntity);
        var stack = new class_1799(RDEntityHolderItems.MAGIC_BROOM_DISPLAY);
        if (this.magicBroomEntity.itemWrapper.getItemStack().hasFoil()) {
            stack.method_57379(class_9334.field_49641, true);
        }
        x.setItem(stack);
        x.setItemDisplayContext(class_811.field_4316);
        x.setInvisible(true);
        x.setTeleportDuration(3);
        x.setScale(new Vector3f(1.2f));
        holder.setElement(x);
        holder.addElement(x);
        EntityAttachment.ofTicking(holder, this.magicBroomEntity);
        VirtualEntityUtils.addVirtualPassenger(this.magicBroomEntity, x.getEntityId());
        ELEMENTS.put(this.magicBroomEntity, x);
    }

    @Override
    public class_1299<?> getPolymerEntityType(PacketContext context) {
        return class_1299.field_6093;
    }

    public void onTrackingStopped(class_3222 player) {
        ItemDisplayElement element = ELEMENTS.get(this.magicBroomEntity);
        if (element != null) {
            ElementHolder holder = element.getHolder();
            if (holder != null) {
                holder.destroy();
            }
        }
        ELEMENTS.remove(this.magicBroomEntity);
    }
}
