package cc.thonly.polymer.entity;

import cc.thonly.polymer.PolymerEntityHelper;
import cc.thonly.reverie_dreams.entity.MaidYouseiEntity;
import cc.thonly.reverie_dreams.entity.holder.WingHolder;
import cc.thonly.reverie_dreams.registry.content.item.RDEntityHolderItems;
import com.mojang.authlib.properties.Property;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.attachment.EntityAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.joml.Vector3f;

public record MaidYouseiImpl(MaidYouseiEntity source) implements PlayerPolymerEntity {
    public MaidYouseiImpl {
        PolymerEntityHelper.addEntityHolderModel(this);
    }

    @Override
    public void onCreated() {
        var x = new ItemDisplayElement();
        var holder = new WingHolder(this.source);
        x.setItem(new class_1799(RDEntityHolderItems.YOUSEI_WINGS));
        x.setInvisible(true);
        x.setTeleportDuration(3);
        x.setScale(new Vector3f(1.2f));
        holder.setElement(x);
        holder.addElement(x);
        EntityAttachment.ofTicking(holder, this.source);
        VirtualEntityUtils.addVirtualPassenger(this.source, x.getEntityId());
        PolymerEntityHelper.POLYMER_PLAYER_ELEMENTS.put(this.source, x);
    }

    @Override
    public class_1309 getEntity() {
        return this.source;
    }

    @Override
    public Property getSkin() {
        return this.source.getSkin();
    }
}
