package cc.thonly.reverie_dreams;

import cc.thonly.polymer.*;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.item.base.SpawnEggItem;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.effect.RDPotions;
import cc.thonly.reverie_dreams.registry.content.effect.RDStatusEffects;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import eu.pb4.polymer.core.api.other.PolymerSoundEvent;
import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import eu.pb4.polymer.resourcepack.extras.api.ResourcePackExtras;
import eu.pb4.polymer.rsm.api.RegistrySyncUtils;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LateLoaderInit implements ModInitializer {
    public static final List<Runnable> LATE_INIT = new ArrayList<>();
    public static final String POLYMER_MOD_ID = "reverie_dreams_polymerify";

    @Override
    public void onInitialize() {
        this.polymerify();
    }

    public void polymerify() {
        for (class_1792 item : RDItems.SIMPLE_LIST) {
            PolymerItemHelper.registerOverlay(item);
        }
        for (class_1792 spawnEgg : SpawnEggItem.SPAWN_EGGS) {
            PolymerItemHelper.registerOverlay(spawnEgg);
        }
        for (class_1792 item : RDGuiItems.GUI_ITEM_LIST) {
            PolymerItemHelper.registerOverlay(item);
        }
        for (DanmakuType danmakuType : RegistryHandlers.DANMAKU_TYPE) {
            PolymerItemHelper.registerOverlay(danmakuType.getItem());
        }
        for (class_3414 soundEvent : SoundEventInit.SOUND_EVENTS) {
            PolymerSoundEvent.registerOverlay(soundEvent);
            RegistrySyncUtils.setServerEntry(class_7923.field_41172, soundEvent);
        }
        for (class_6880<class_1291> registryEntry : RDStatusEffects.EFFECTS) {
            PolymerStatusEffectHelper.registerOverlay(registryEntry);
        }
        for (class_1842 potion : RDPotions.POTIONS) {
            RegistrySyncUtils.setServerEntry(class_7923.field_41179, potion);
        }
        for (class_1299<?> entityType : RDEntityTypes.ENTITY_TYPES) {
            PolymerEntityUtils.registerType(entityType);
        }

        PolymerEntityHelper.bootstrap();
        PolymerVillagerProfessionHelper.bootstrap();

        Iterator<Runnable> rIterator = LATE_INIT.iterator();
        while (rIterator.hasNext()) {
            Runnable next = rIterator.next();
            next.run();
            rIterator.remove();
        }

        PolymerResourcePackUtils.addModAssets(ReverieDreams.MOD_ID);
        PolymerResourcePackUtils.addModAssets(POLYMER_MOD_ID);
        PolymerResourcePackUtils.markAsRequired();
        ResourcePackExtras.forDefault().addBridgedModelsFolder(
                ReverieDreams.id("block"),
                ReverieDreams.id("item"),
                ReverieDreams.id("entity"),
                ReverieDreams.id("font")
        );
        ResourcePackExtras.forDefault().addBridgedModelsFolder(
                id("block"),
                id("item"),
                id("entity"),
                id("font")
        );
        ResourcePackGenerator.registerEvent();
    }

    public static class_2960 id(String name) {
        return class_2960.method_60655(POLYMER_MOD_ID, name);
    }
}
