package cc.thonly.reverie_dreams;

import cc.thonly.reverie_dreams.datagen.*;
import cc.thonly.reverie_dreams.datagen.tag.*;
import cc.thonly.reverie_dreams.registry.content.RDDamageTypes;
import cc.thonly.reverie_dreams.registry.content.RDEnchantments;
import cc.thonly.reverie_dreams.world.dimension.DimensionInit;
import cc.thonly.reverie_dreams.world.dimension.DimensionTypeInit;
import cc.thonly.reverie_dreams.world.gen.*;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.event.registry.DynamicRegistries;
import net.minecraft.class_5363;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class ReverieDreamsDataGenerator implements DataGeneratorEntrypoint {

    @SuppressWarnings("DuplicatedCode")
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        DynamicRegistries.register(class_7924.field_41224, class_5363.field_25411);

        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        pack.addProvider(SimpChineseLangProvider::new);
        pack.addProvider(ItemTagProvider::new);
        pack.addProvider(BlockTagProvider::new);
        pack.addProvider(PointOfInterestTypeProvider::new);
        pack.addProvider(EntityTagProvider::new);
        pack.addProvider(DamageTypeTagProvider::new);
        pack.addProvider(EnchantmentTagProvider::new);
        pack.addProvider(ModelProvider::new);
        pack.addProvider(RecipeProvider::new);
        pack.addProvider(BlockLootTableProvider::new);
        pack.addProvider(ChestLootTableProvider::new);
        pack.addProvider(EntityLootTableProvider::new);
        pack.addProvider(EquipmentAssetProvider::new);
        pack.addProvider(JukeboxProvider::new);
        pack.addProvider(SoundProvider::new);
        pack.addProvider(RecipeTypeProvider::new);
        pack.addProvider(DynamicRegistryProvider::new);
        pack.addProvider(SkinConfigProvider::new);
        pack.addProvider(JsonElementWriterProvider::new);

        pack.addProvider(IngredientProvider::new);
        pack.addProvider(DrinkProvider::new);
        pack.addProvider(CraftingConflictProvider::new);
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        DataGeneratorEntrypoint.super.buildRegistry(registryBuilder);
        registryBuilder.method_46777(class_7924.field_42534, RDDamageTypes::bootstrap);
        registryBuilder.method_46777(class_7924.field_41265, RDEnchantments::bootstrap);
        registryBuilder.method_46777(class_7924.field_41239, ConfigurationFeatureInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41238, ConfigurationCarverInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41245, PlacedFeaturesInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41243, ChunkGeneratorSettingsInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41236, BiomeInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41246, ModStructures::bootstrap);
        registryBuilder.method_46777(class_7924.field_41248, ModStructureSets::bootstrap);
        registryBuilder.method_46777(class_7924.field_41249, ModTemplatePools::bootstrap);
        registryBuilder.method_46777(class_7924.field_41241, DimensionTypeInit::bootstrap);
        registryBuilder.method_46777(class_7924.field_41224, DimensionInit::bootstrap);
    }

}
