package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.block.entity.FoodDisplayBlockEntity;
import cc.thonly.reverie_dreams.block.entity.RDBlockEntityTypes;
import cc.thonly.reverie_dreams.inf.IItemStack;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.mojang.serialization.MapCodec;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_10124;
import net.minecraft.class_10131;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

@Setter
@Getter
public class FoodDisplayBlock extends class_2237 {
    public static final MapCodec<FoodDisplayBlock> CODEC = FoodDisplayBlock.method_54094(FoodDisplayBlock::new);

    public FoodDisplayBlock(class_2251 settings) {
        super(settings);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        class_1799 stack = player.method_6047();
        if (!world.field_9236 && world instanceof class_3218 serverWorld) {
            if (player.method_5715()) {
                if (!(serverWorld.method_8321(pos) instanceof FoodDisplayBlockEntity isdBlockEntity)) {
                    return class_1269.field_5811;
                }
                boolean isFood = ((IItemStack) (Object) isdBlockEntity.getItem().getItemStack()).isFood();
                if (isFood) {
                    class_1799 contentStack = isdBlockEntity.getItem().getItemStack();
                    class_10124 consumableComponent = contentStack.method_58694(class_9334.field_53964);
                    class_10131 useRemainderComponent = contentStack.method_58694(class_9334.field_53965);
                    contentStack.method_7910(serverWorld, player);
                    if (consumableComponent != null) {
                        class_6880<class_3414> sound = consumableComponent.comp_3087();
                        world.method_8396(null, player.method_24515(), sound.comp_349(), class_3419.field_15245, 1.0f, 1.0f);
                    }
                    contentStack.method_57008(1, player);
                    if (useRemainderComponent != null && !player.method_56992()) {
                        class_1799 itemStack = useRemainderComponent.method_62863(contentStack, contentStack.method_7947(), player.method_56992(), player::method_64399);
                        isdBlockEntity.setItem(ItemStackWrapper.of(itemStack));
                    }
                    isdBlockEntity.update();
                    serverWorld.method_8413(pos, state, state, class_2248.field_31036);
                    isdBlockEntity.method_5431();
                    return class_1269.field_52422;
                }
            } else {
                if (serverWorld.method_8321(pos) instanceof FoodDisplayBlockEntity isdBlockEntity) {
                    ItemStackWrapper item = isdBlockEntity.getItem();
                    if (!stack.method_7960() && item.isEmpty()) {
                        ItemStackWrapper itemStackWrapper = ItemStackWrapper.of(stack.method_7972());
                        itemStackWrapper.getItemStack().setCount(1);
                        stack.method_57008(1, player);
                        isdBlockEntity.setItem(itemStackWrapper);
                        isdBlockEntity.setYaw(player.method_36454());
                        isdBlockEntity.update();
                        isdBlockEntity.method_5431();
                    } else {
                        class_1542 itemEntity = new class_1542(serverWorld, pos.method_10263(), pos.method_10264(), pos.method_10260(), item.getItemStack(), 0, 0.2, 0);
                        isdBlockEntity.setItem(ItemStackWrapper.empty());
                        serverWorld.method_8649(itemEntity);
                        isdBlockEntity.update();
                    }
                    serverWorld.method_8413(pos, state, state, class_2248.field_31036);
                    isdBlockEntity.method_5431();
                    isdBlockEntity.update();
                }
            }
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld && world.method_8321(pos) instanceof FoodDisplayBlockEntity isdBlockEntity) {
            ItemStackWrapper item = isdBlockEntity.getItem();
            if (!item.isEmpty()) {
                class_1542 itemEntity = new class_1542(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), item.getItemStack(), 0, 0.2, 0);
                isdBlockEntity.setItem(ItemStackWrapper.empty());
                serverWorld.method_8649(itemEntity);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return field_46280;
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new FoodDisplayBlockEntity(pos, state);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, RDBlockEntityTypes.ITEM_DISPLAY_BLOCK_ENTITY, FoodDisplayBlockEntity::tick);
    }

}
