package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.block.base.ModelBlock;
import cc.thonly.reverie_dreams.entity.misc.WheelchairEntity;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.state.RDBlockStateTemplates;
import cc.thonly.reverie_dreams.state.SixteenDirection;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2383;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_3965;

public class WheelChairBlock extends ModelBlock {
    public static final MapCodec<WheelChairBlock> CODEC = method_54094(WheelChairBlock::new);
    public static final class_2754<SixteenDirection> FACING_16 = RDBlockStateTemplates.FACING_16;

    public WheelChairBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.field_10647.method_11664().method_11657(FACING_16, SixteenDirection.NORTH));
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.field_9236 && player.method_5715()) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
            world.method_8649(new WheelchairEntity(RDEntityTypes.WHEEL_CHAIR, world, pos.method_10263(), pos.method_10264(), pos.method_10260(), player.method_5845()));
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        double yaw = ctx.method_8044();
        SixteenDirection direction = SixteenDirection.fromYaw(yaw + 180f);
        return this.method_9564().method_11657(FACING_16, direction);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(FACING_16);
    }

    @Override
    public MapCodec<? extends class_2383> method_53969() {
        return field_46280;
    }
}
