package cc.thonly.reverie_dreams.block.base;

import cc.thonly.reverie_dreams.compat.BorukvaFoodCompatImpl;
import cc.thonly.reverie_dreams.inf.IMatureBlock;
import com.mojang.serialization.MapCodec;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.Nullable;

@Setter
@Getter
@ToString
public abstract class AbstractCropBlock extends class_2261 implements class_2256, IMatureBlock {
    protected class_1792 seed;

    protected AbstractCropBlock(class_2251 settings) {
        super(settings.method_22488().method_9634().method_9640().method_9618().method_9626(class_2498.field_17580));
        this.method_9590(this.field_10647.method_11664().method_11657(this.getAgeProperty(), 0));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(this.getAgeProperty());
    }

    public abstract Integer getMaxAge();

    public abstract class_2758 getAgeProperty();

    @Override
    protected abstract MapCodec<? extends class_2261> method_53969();

    protected class_1935 getSeedsItem() {
        return this.seed;
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return new class_1799(this.getSeedsItem());
    }

    @Override
    protected boolean method_9695(class_2680 floor, class_1922 world, class_2338 pos) {
        if (!BorukvaFoodCompatImpl.hasBorukvaFood()) {
            return floor.method_27852(class_2246.field_10362);
        } else {
            return floor.method_27852(class_2246.field_10362) || floor.method_27852(BorukvaFoodCompatImpl.BETTER_FARMLAND);
        }
    }

    @Override
    public boolean method_9651(class_4538 world, class_2338 pos, class_2680 state) {
        return !this.isMature(state);
    }

    @Override
    public boolean method_9650(class_1937 world, class_5819 random, class_2338 pos, class_2680 state) {
        return true;
    }

    public final boolean isMature(class_2680 state) {
        return this.getAge(state) >= this.getMaxAge();
    }

    @Override
    protected boolean method_9542(class_2680 state) {
        return !this.isMature(state);
    }

    @Override
    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        int age = this.getAge(state);
        if (age >= this.getMaxAge()) return;

        if (world.method_22335(pos, 0) >= 9) {
            float moisture = getAvailableMoisture(this, world, pos);

            int chance = (int) (15.0f / moisture) + 1;

            if (random.method_43048(chance) == 0) {
                world.method_8652(pos, this.withAge(age + 1), class_2248.field_31028);
            }
        }
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);
        if (!state.method_26184(world, pos)) {
            world.method_22352(pos, true);
        }
    }

    @Override
    public void method_9652(class_3218 world, class_5819 random, class_2338 pos, class_2680 state) {
        this.applyGrowth(world, pos, state);
    }

    public void applyGrowth(class_1937 world, class_2338 pos, class_2680 state) {
        int i = Math.min(this.getMaxAge(), this.getAge(state) + this.getGrowthAmount(world));
        world.method_8652(pos, this.withAge(i), class_2248.field_31028);
    }

    protected int getGrowthAmount(class_1937 world) {
        return class_3532.method_15395(world.field_9229, 1, 3);
    }

    public class_2680 withAge(int age) {
        return (class_2680) this.method_9564().method_11657(this.getAgeProperty(), age);
    }

    public int getAge(class_2680 state) {
        return state.method_11654(this.getAgeProperty());
    }

    protected static float getAvailableMoisture(class_2248 block, class_1922 world, class_2338 pos) {
        boolean bl2;
        float f = 1.0f;
        class_2338 blockPos = pos.method_10074();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float g = 0.0f;
                class_2680 blockState = world.method_8320(blockPos.method_10069(i, 0, j));
                if (blockState.method_27852(class_2246.field_10362)) {
                    g = 1.0f;
                    if (blockState.method_11654(class_2344.field_11009) > 0) {
                        g = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    g /= 4.0f;
                }
                f += g;
            }
        }
        class_2338 blockPos2 = pos.method_10095();
        class_2338 blockPos3 = pos.method_10072();
        class_2338 blockPos4 = pos.method_10067();
        class_2338 blockPos5 = pos.method_10078();
        boolean bl = world.method_8320(blockPos4).method_27852(block) || world.method_8320(blockPos5).method_27852(block);
        boolean bl3 = bl2 = world.method_8320(blockPos2).method_27852(block) || world.method_8320(blockPos3).method_27852(block);
        if (bl && bl2) {
            f /= 2.0f;
        } else {
            boolean bl32;
            boolean bl4 = bl32 = world.method_8320(blockPos4.method_10095()).method_27852(block) || world.method_8320(blockPos5.method_10095()).method_27852(block) || world.method_8320(blockPos5.method_10072()).method_27852(block) || world.method_8320(blockPos4.method_10072()).method_27852(block);
            if (bl32) {
                f /= 2.0f;
            }
        }
        return f;
    }

}
