package cc.thonly.reverie_dreams.block.creator;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import lombok.Getter;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

@SuppressWarnings("unchecked")
@Getter
public abstract class AbstractBlockCreator {
    public static final Map<Class<? extends Class<AbstractBlockCreator>>, List<AbstractBlockCreator>> INSTANCES = new Object2ObjectOpenHashMap<>();
    private final String name;
    private final class_2960 id;

    public AbstractBlockCreator(String name, class_2960 id) {
        this.name = name;
        this.id = id;
        List<AbstractBlockCreator> list = INSTANCES.computeIfAbsent((Class<? extends Class<AbstractBlockCreator>>) (Object) this.getClass(), x -> new ObjectArrayList<>());
        list.add(this);
    }

    protected class_2960 prefix(String name) {
        return class_2960.method_60655(this.id.method_12836(), name + "_" + this.id.method_12832());
    }

    protected class_2960 suffix(String name) {
        return class_2960.method_60655(this.id.method_12836(), this.id.method_12832() + "_" + name);
    }

    protected class_2960 prefix(class_2960 id, String name) {
        return class_2960.method_60655(id.method_12836(), name + "_" + id.method_12832());
    }

    protected class_2960 suffix(class_2960 id, String name) {
        return class_2960.method_60655(id.method_12836(), id.method_12832() + "_" + name);
    }

    protected abstract Stream<class_2248> stream();

    protected abstract AbstractBlockCreator build();
}
