package cc.thonly.reverie_dreams.block.entity;

import cc.thonly.reverie_dreams.block.KitchenBlockType;
import cc.thonly.reverie_dreams.block.kitchen.AbstractKitchenwareBlock;
import cc.thonly.reverie_dreams.gui.recipe.gui.KitchenBlockGui;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.type.KitchenRecipeType;
import cc.thonly.reverie_dreams.registry.content.item.RDFoodItems;
import cc.thonly.reverie_dreams.util.entity.PlayerUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1277;
import net.minecraft.class_1278;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;

@Setter
@Getter
@ToString
public class KitchenwareBlockEntity extends class_2586 implements class_1278 {
    public static final Supplier<ItemStackWrapper> DEFAULT_WRAPPER_FACTORY = ItemStackWrapper::empty;
    public static final Gson GSON = new Gson();
    public static final Map<UUID, Set<KitchenBlockGui<?>>> SESSIONS = new Object2ObjectOpenHashMap<>();
    public static final int OUTPUT_SLOT = 5;
    private class_1277 inventory = new class_1277(6);
    private KitchenRecipeType.KitchenType recipeType;
    private class_2960 recipeId;
    private ItemStackWrapper preOutput = DEFAULT_WRAPPER_FACTORY.get();
    private Double tickLeft = 0.0;
    private DoubleUnaryOperator bonusOperator;
    private UUID uuid = UUID.randomUUID();
    private final AbstractKitchenwareBlock block;
    private WorkingState workingState = WorkingState.NONE;

    public KitchenwareBlockEntity(class_2338 pos, class_2680 state) {
        super(RDBlockEntityTypes.KITCHENWARE_BLOCK_ENTITY, pos, state);
        class_2248 block = state.method_26204();
        this.block = (AbstractKitchenwareBlock) block;
        this.recipeType = KitchenBlockType.BLOCK_2_KITCHEN_TYPE.get(block);
        this.bonusOperator = this.block.getBonusOperator();
    }


    public static void tick(class_1937 world, class_2338 blockPos, class_2680 state, KitchenwareBlockEntity self) {
        KitchenwareBlockEntity blockEntity = self.get();
        if (blockEntity.recipeType == null) {
            return;
        }
        if (world.method_8608() || self.recipeType == null) return;
        class_3218 serverWorld = (class_3218) world;
        class_2338 pos = self.method_11016();
        if (self.preOutput != null && !self.preOutput.isEmpty()) {
            self.workingState = WorkingState.WORKING;
            self.tickLeft -= self.bonusOperator.applyAsDouble(1.0);
            serverWorld.method_65096(class_2398.field_28013, pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5, 1, 0, 0.5, 0, 0.1);
            if (self.tickLeft <= 0.0) {
                self.tickLeft = 0.0;
                self.workingState = WorkingState.NONE;
                self.handleOutput();
            }
            self.method_5431();
        } else {
            self.workingState = WorkingState.NONE;
        }
    }
//    public static void tick(World world, BlockPos blockPos, BlockState state, KitchenwareBlockEntity self) {
//        KitchenwareBlockEntity blockEntity = self.get();
//        if (blockEntity.recipeType == null) {
//            return;
//        }
//        if (world.isClient() || self.recipeType == null) return;
//
//        ServerWorld serverWorld = (ServerWorld) world;
//        BlockPos pos = self.getPos();
//
//        switch (self.workingState) {
//            case WorkingState.WORKING -> {
//                self.tickLeft -= self.tickSpeedBonus + 1.0;
//                serverWorld.spawnParticles(ParticleTypes.SNOWFLAKE, pos.getX() + 0.5, pos.getY(), pos.getZ() + 0.5, 1, 0, 0.5, 0, 0.1);
//                if (self.tickLeft <= 0.0) {
//                    self.tickLeft = 0.0;
//                    self.workingState = WorkingState.NONE;
//                    self.handleOutput();
//                }
//                self.markDirty();
//            }
//            case NONE_FUEL -> {
//                if (self.preOutput.isEmpty()) {
//                    break;
//                }
//
//                Optional<CooktopBlockEntity> cooktopBlockEntityResult = self.getCooktopBlockEntity();
//                if (cooktopBlockEntityResult.isEmpty()) {
//                    break;
//                }
//                CooktopBlockEntity cooktopBlockEntity = cooktopBlockEntityResult.get();
//
//                if (cooktopBlockEntity.ticks > 0 || cooktopBlockEntity.use()) {
//                    self.workingState = WorkingState.WORKING;
//                    self.markDirty();
//                } else {
//                    self.workingState = WorkingState.NONE_FUEL;
//                }
//            }
//            case NONE -> {
//                if (!self.preOutput.isEmpty()) {
//                    self.workingState = WorkingState.NONE_FUEL;
//                }
//            }
//        }
//        if ((!self.block.getRequiredEnergy()) && !self.preOutput.isEmpty()) {
//            self.workingState = WorkingState.WORKING;
//        }
//    }
//
//    public Optional<CooktopBlockEntity> getCooktopBlockEntity() {
//        if (this.world == null) {
//            return Optional.empty();
//        }
//        BlockPos blockPos = this.getPos();
//        BlockPos down = blockPos.down();
//        BlockState blockState = this.world.getBlockState(down);
//        Block block = blockState.getBlock();
//        if (block != MIBlocks.COOKTOP) {
//            return Optional.empty();
//        }
//        if (!(this.world.getBlockEntity(down) instanceof CooktopBlockEntity cooktop)) {
//            return Optional.empty();
//        } else {
//            return Optional.of(cooktop);
//        }
//    }

    public void setOutput(class_1799 itemStack, Double time) {
        this.setOutput(ItemStackWrapper.of(itemStack), time);
    }

    public void setOutput(ItemStackWrapper recipeWrapper, Double time) {
        this.setPreOutput(recipeWrapper);
        this.setTickLeft(time);
//        if (!this.hasFuel()) {
//            this.useFuel();
//        }
        this.method_5431();
    }

//    public void useFuel() {
//        Optional<CooktopBlockEntity> cooktop = this.getCooktopBlockEntity();
//        cooktop.ifPresent((cooktopBlockEntity) -> {
//            boolean use = cooktopBlockEntity.use();
//            if (use) {
//                this.workingState = WorkingState.WORKING;
//            }
//        });
//    }

//    public boolean hasFuel() {
//        Optional<CooktopBlockEntity> cooktop = this.getCooktopBlockEntity();
//        return cooktop.isPresent() && cooktop.get().isWorking();
//    }

    public void handleOutput() {
        KitchenwareBlockEntity blockEntity = this;
        if (this.field_11863 == null || this.field_11863.method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218) this.method_10997();
        class_2338 blockPos = this.method_11016();

        if (blockEntity.isWorking()) {
            blockEntity.tickLeft -= blockEntity.bonusOperator.applyAsDouble(1.0);
            if (serverWorld != null) {
                serverWorld.method_65096(
                        class_2398.field_28013,
                        blockPos.method_10263(),
                        blockPos.method_10264(),
                        blockPos.method_10260(),
                        1,
                        0,
                        0.5,
                        0,
                        0.1
                );
            }
            blockEntity.method_5431();
        } else if (!blockEntity.isWorking() && !blockEntity.preOutput.getItemStack().isEmpty()) {
            class_1799 prevStack = blockEntity.inventory.method_5438(OUTPUT_SLOT);
            if (!prevStack.method_7960()) {
                class_1792 item = prevStack.method_7909();
                if (item != blockEntity.preOutput.getItemStack().getItem()) {
                    blockEntity.throwItem(serverWorld, prevStack);
                }
                if (!class_1799.method_31577(blockEntity.preOutput.getItemStack(), prevStack)) {
                    blockEntity.throwItem(serverWorld, prevStack);
                }
            }
            if (class_1799.method_31577(blockEntity.preOutput.getItemStack(), prevStack)) {
                if (prevStack.method_7947() < prevStack.method_7914()) {
                    prevStack.method_7939(prevStack.method_7947() + 1);
                } else {
                    blockEntity.throwItem(serverWorld, prevStack);
                    prevStack.method_7939(prevStack.method_7947() + 1);
                }

            } else {
                blockEntity.inventory.method_5447(OUTPUT_SLOT, blockEntity.preOutput.getItemStack().copy());
                if (this.method_10997() != null && blockEntity.block.isWillBeFailure(this.method_10997())) {
                    blockEntity.inventory.method_5447(OUTPUT_SLOT, RDFoodItems.DARK_CUISINE.method_7854().method_7972());
                }
            }
            blockEntity.preOutput = DEFAULT_WRAPPER_FACTORY.get();

            List<class_3222> nearbyPlayers = PlayerUtil.getNearbyPlayers(serverWorld, blockEntity.field_11867, 16);
            for (class_3222 player : nearbyPlayers) {
                player.method_5783(class_3417.field_14622.comp_349(), 1.0f, 1.0f);
            }

            blockEntity.method_5431();
        }

    }

    public void throwItem(class_3218 world, class_1799 prevItem) {
        class_1542 itemEntity = new class_1542(world, this.field_11867.method_10263(), this.field_11867.method_10264(), this.field_11867.method_10260(), prevItem.method_7972());
        world.method_8649(itemEntity);
        this.inventory.method_5447(OUTPUT_SLOT, class_1799.field_8037);
    }

    public boolean isWorking() {
        return this.workingState == WorkingState.WORKING;
    }


    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        class_1262.method_5426(view, this.inventory.field_5828);
        view.method_71463("TickLeft", this.tickLeft);
        view.method_71465("WorkingState", this.workingState.getId());
        DataResult<JsonElement> dataResult = ItemStackWrapper.CODEC.encodeStart(JsonOps.INSTANCE, this.preOutput);
        Optional<JsonElement> result = dataResult.result();
        if (result.isPresent()) {
            JsonElement element = result.get();
            view.method_71469("PreOutput", GSON.toJson(element));
        }
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        class_1277 inventory = new class_1277(6);
        class_1262.method_5429(view, inventory.field_5828);
        this.inventory = inventory;
        this.tickLeft = view.method_71422("TickLeft", 0.0);
        this.workingState = WorkingState.getFromInt(view.method_71424("WorkingState", 0));
        Optional<String> pOutputOptional = view.method_71441("PreOutput");
        if (pOutputOptional.isPresent()) {
            String preOutputJson = pOutputOptional.get();
            JsonElement json = JsonParser.parseString(preOutputJson);
            Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, json);
            DataResult<ItemStackWrapper> parse = ItemStackWrapper.CODEC.parse(input);
            Optional<ItemStackWrapper> result = parse.result();
            result.ifPresent(wrapper -> this.preOutput = wrapper);
        }
    }

    public KitchenwareBlockEntity get() {
        return this;
    }

    @Override
    public int[] method_5494(class_2350 side) {
        return new int[] {OUTPUT_SLOT};
    }

    @Override
    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return true;
    }

    @Override
    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033;
    }

    @Override
    public int method_5439() {
        return this.inventory.method_5439();
    }

    @Override
    public boolean method_5442() {
        return this.inventory.method_5442();
    }

    @Override
    public class_1799 method_5438(int slot) {
        return this.inventory.method_5438(slot);
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        return this.inventory.method_5434(slot, amount);
    }

    @Override
    public class_1799 method_5441(int slot) {
        return this.inventory.method_5441(slot);
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {
        this.inventory.method_5447(slot, stack);
    }

    @Override
    public boolean method_5443(class_1657 player) {
        return this.inventory.method_5443(player);
    }

    @Override
    public void method_5448() {
        this.inventory.method_5448();
    }

    @Getter
    public enum WorkingState {
        NONE(0),
        NONE_FUEL(1),
        WORKING(2);
        private final int id;

        WorkingState(int id) {
            this.id = id;
        }

        public static WorkingState getFromInt(int id) {
            List<WorkingState> list = Arrays.stream(WorkingState.values()).filter(e -> e.id == id).toList();
            return list.isEmpty() ? NONE : list.getFirst();
        }
    }
}
