package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.api.DrinkPropertyLoaderCallback;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponents;
import cc.thonly.reverie_dreams.registry.content.effect.RDStatusEffects;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import java.util.*;

@Setter
@Getter
@ToString
public class DrinkProperty implements CodecStep<DrinkProperty>, OwnerBinding<DrinkProperty>, BuiltinObject, Translatable {
    public static final Codec<DrinkProperty> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            class_2960.field_25139.fieldOf("registry_key").forGetter(DrinkProperty::getId),
            ITEMS_CODEC.fieldOf("properties").forGetter(DrinkProperty::getItemList)
    ).apply(instance, DrinkProperty::new));

    private class_2960 id;
    private final class_1293 effectInstance;
    private Set<class_1792> items = new ObjectOpenHashSet<>();
    private RegistryHandler<DrinkProperty> owner;

    public DrinkProperty() {
        this(new class_1293(new class_1293(RDStatusEffects.EMPTY, 1)));
    }

    public DrinkProperty(class_1293 effectInstance) {
        this.effectInstance = effectInstance;
    }

    public DrinkProperty(class_2960 id, List<class_1792> items) {
        this();
        this.id = id;
        this.items.addAll(items);
    }

    public final void use(class_3218 world, class_1309 user) {
        class_1293 effectInstance = new class_1293(this.effectInstance);
        user.method_6092(effectInstance);
        DrinkPropertyLoaderCallback.EVENT.invoker().onUse(world, user, this);
        this.onUse(world, user);
    }

    public void onUse(class_3218 world, class_1309 user) {

    }

    public Boolean is(DrinkProperty property) {
        return this == property || this.getId().equals(property.getId()) || this.hashCode() == property.hashCode();
    }

    public class_2561 getTooltip() {
        return class_2561.method_43471(this.id.method_42093("drink_property"));
    }

    @Override
    public String translateKey() {
        return this.id.method_42093("drink_property");
    }

    public List<class_1792> getItemList() {
        return new ArrayList<>(this.items);
    }

    public static List<DrinkProperty> getAllProperties(class_1799 itemStack) {
        Set<DrinkProperty> set = new HashSet<>();
        set.addAll(getDrinkProperties(itemStack.method_7909()));
        set.addAll(getFromItemStackComponent(itemStack));
        set.addAll(getFromItemStack(itemStack));
        return new ArrayList<>(set);
    }

    public static List<DrinkProperty> getDrinkProperties(class_1792 item) {
        List<DrinkProperty> list = new ArrayList<>();
        Set<Map.Entry<class_2960, DrinkProperty>> entries = RegistryHandlers.DRINK_PROPERTY.idEntrySet();
        for (Map.Entry<class_2960, DrinkProperty> entry : entries) {
            DrinkProperty foodProperty = entry.getValue();
            Set<class_1792> tags = foodProperty.getItems();
            if (tags.contains(item)) {
                list.add(foodProperty);
            }
        }
        return list;
    }

    public static List<DrinkProperty> getFromStrings(List<String> ids) {
        List<DrinkProperty> list = new ArrayList<>();
        for (String id : ids) {
            class_2960 identifier = class_2960.method_60654(id);
            DrinkProperty foodProperty = RegistryHandlers.DRINK_PROPERTY.method_63535(identifier);
            if (foodProperty != null) {
                list.add(foodProperty);
            }
        }
        return list;
    }

    public static List<DrinkProperty> getFromItemStackComponent(class_1799 itemStack) {
        List<String> ids = itemStack.method_58695(RDDataComponents.DRINK_PROPERTIES, new ArrayList<>());
        return getFromStrings(ids);
    }

    public static List<DrinkProperty> getFromItemStack(class_1799 itemStack) {
        List<DrinkProperty> list = new ArrayList<>();
        class_1792 item = itemStack.method_7909();
        Set<Map.Entry<class_5321<DrinkProperty>, DrinkProperty>> entries = RegistryHandlers.DRINK_PROPERTY.method_29722();
        for (Map.Entry<class_5321<DrinkProperty>, DrinkProperty> entry : entries) {
            DrinkProperty drinkProperty = entry.getValue();
            Set<class_1792> tags = drinkProperty.getItems();
            if (tags.contains(item)) {
                list.add(drinkProperty);
            }
        }
        return list;
    }

    @Override
    public Codec<DrinkProperty> getCodec() {
        return CODEC;
    }

}
