package cc.thonly.reverie_dreams.data.npc;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.skin.SkinType;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleFastEntity;
import cc.thonly.reverie_dreams.item.base.SpawnEggItem;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import cc.thonly.reverie_dreams.util.IdentifierGetter;
import com.mojang.serialization.Codec;
import eu.pb4.polymer.core.api.entity.PolymerEntityUtils;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.LinkedList;
import java.util.List;

@Slf4j
@Setter
@Getter
public class NPCRole implements CodecStep<NPCRole>, OwnerBinding<NPCRole>, BuiltinObject, Translatable {
    public static final Codec<NPCRole> CODEC = Codec.unit(NPCRole::new);
    public static final List<class_1792> NPC_SPAWN_EGG_ITEM_LIST = new LinkedList<>();

    private class_2960 id;
    private SkinType skinType;
    // 构建后属性
    private class_1299<NPCRoleFastEntity> entityType;
    private class_1792 spawnEgg;
//    private Class<? extends BaseNPCLikeEntity> clazz;
    private boolean hasBuilt = false;

    private RegistryHandler<NPCRole> owner;;

    private NPCRole() {
    }

    public NPCRole(class_2960 id, SkinType skinType) {
        this.id = id;
        this.skinType = skinType;
    }

    public boolean isPresent() {
        return this.entityType != null;
    }

    public boolean isEmpty() {
        return this.entityType == null;
    }

    public class_1299<NPCRoleFastEntity> get() {
        return this.entityType;
    }

    public class_1792 getEgg() {
        return this.spawnEgg;
    }

    @Override
    public String translateKey() {
        return this.entityType.method_5882();
    }

    public NPCRole build() {
        if (hasBuilt) {
            return this;
        }
        try {
            class_1299<NPCRoleFastEntity> build = class_1299.class_1300.<NPCRoleFastEntity>method_5903(
                            (type, world) -> new NPCRoleFastEntity(type, world, this.skinType),
                            class_1311.field_17715)
//                    .disableSummon()
                    .method_5905(of(this.id));
            class_1299<NPCRoleFastEntity> entityType = registerEntity(this.id, build);;
            FabricDefaultAttributeRegistry.register(entityType, BaseNPCLikeEntity.createAttributes());
            class_2960 spawnEggId = class_2960.method_60655(this.id.method_12836(), this.id.method_12832() + "_spawn_egg");
            class_1792 spawnEgg = registerNPCSpawnEggItem(new SpawnEggItem(spawnEggId, build, new class_1792.class_1793()));
            this.entityType = build;
            this.spawnEgg = spawnEgg;
            this.hasBuilt = true;
        } catch (Exception e) {
            log.error("Can't register role entity type {}", this.id.toString());
        }
        return this;
    }

    @Override
    public Codec<NPCRole> getCodec() {
        return CODEC;
    }

    protected static <T extends class_1297> class_1299<T> registerEntity(class_2960 id, class_1299<T> entityType) {
        class_1299<T> entityTypeRef = class_2378.method_10230(class_7923.field_41177, id, entityType);
        PolymerEntityUtils.registerType(entityTypeRef);
        return entityTypeRef;
    }

    protected static class_1792 registerNPCSpawnEggItem(IdentifierGetter item) {
        class_2378.method_10230(class_7923.field_41178, item.getIdentifier(), (class_1792) item);
        NPC_SPAWN_EGG_ITEM_LIST.add((class_1792) item);
        return (class_1792) item;
    }

    private static class_5321<class_1299<?>> of(class_2960 id) {
        return class_5321.method_29179(class_7924.field_41266, id);
    }
}
