package cc.thonly.reverie_dreams.data.npc;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import com.mojang.serialization.Codec;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import java.util.Collections;
import java.util.Map;

@Getter
@Setter
public class NPCWorkMode implements CodecStep<NPCWorkMode>, OwnerBinding<NPCWorkMode>, BuiltinObject, Translatable {
    public static final Codec<NPCWorkMode> CODEC = Codec.unit(NPCWorkMode::new);
    public static final class_2960 DEFAULT_ID = ReverieDreams.id("combat");
    private final String type;
    private final class_1792 itemDisplay;
    private RegistryHandler<NPCWorkMode> owner;

    private NPCWorkMode() {
        this.type = null;
        this.itemDisplay = class_1802.field_8446;
    }

    public NPCWorkMode(String id, class_1792 itemDisplay) {
        this.type = id;
        this.itemDisplay = itemDisplay;
    }

    public String translateKey() {
        return "gui.npc.work.mode." + this.type;
    }

    public class_5250 translationKey() {
        return class_2561.method_43471(this.translateKey());
    }

    public NPCWorkMode getNext() {
        int rawId = RegistryHandlers.NPC_WORK_MODE.method_10206(this);
        NPCWorkMode npcWorkMode = NPCWorkModes.fromInt(rawId + 1);
        return npcWorkMode == null ? NPCWorkModes.fromInt(0) : npcWorkMode;
    }

    public NPCWorkMode getPrevious() {
        int rawId = RegistryHandlers.NPC_WORK_MODE.method_10206(this);
        NPCWorkMode npcWorkMode = NPCWorkModes.fromInt(rawId - 1);
        Map<Integer, class_6880.class_6883<NPCState>> baseRawToEntry = RegistryHandlers.NPC_STATE.getIdToEntryMap();
        int maxKey = Collections.max(baseRawToEntry.keySet());
        return npcWorkMode == null ? NPCWorkModes.fromInt(maxKey) : npcWorkMode;
    }

    @Override
    public Codec<NPCWorkMode> getCodec() {
        return CODEC;
    }
}
