package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.block.creator.CropBlockCreator;
import cc.thonly.reverie_dreams.block.creator.DecorativeBlockCreator;
import cc.thonly.reverie_dreams.block.creator.WoodCreator;
import cc.thonly.reverie_dreams.block.kitchen.AbstractKitchenwareBlock;
import cc.thonly.reverie_dreams.data.FumoType;
import cc.thonly.reverie_dreams.registry.content.FumoTypes;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_141;
import net.minecraft.class_1792;
import net.minecraft.class_212;
import net.minecraft.class_219;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2397;
import net.minecraft.class_2482;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_4559;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_85;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class BlockLootTableProvider extends FabricBlockLootTableProvider {
    private final Function<WoodCreator, Void> woodCreatorLootFunction = (creator) -> {
        creator.stream().forEach((block -> {
            if (block instanceof class_2323) {
                class_52.class_53 builder = this.method_46022(block);
                this.method_45988(block, builder);
                return;
            }
            if (block instanceof class_2397) {
                class_52.class_53 builder = this.method_45986(block, creator.sapling(), 0.2f);
                this.method_45988(block, builder);
                return;
            }
            if (block instanceof class_2482) {
                class_52.class_53 builder = this.method_45980(block);
                this.method_45988(block, builder);
                return;
            }
            this.method_46025(block);
        }));
        return null;
    };
    private final Function<DecorativeBlockCreator, Void> decorativeBlockCreatorLootFunction = (creator) -> {
        creator.stream().forEach((block -> {
            if (block instanceof class_2482) {
                class_52.class_53 builder = this.method_45980(block);
                this.method_45988(block, builder);
                return;
            }
            this.method_46025(block);
        }));
        return null;
    };

    public BlockLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup);
    }

    @Override
    public void method_10379() {
        method_46025(RDBlocks.DANMAKU_CRAFTING_TABLE);
        method_46025(RDBlocks.STRENGTH_TABLE);
        method_46025(RDBlocks.GENSOKYO_ALTAR);
        method_46025(RDBlocks.MUSIC_BLOCK);

        method_46025(RDBlocks.MAGIC_ICE_BLOCK);
        method_46025(RDBlocks.MARISA_HAT_BLOCK);
        method_46025(RDBlocks.ANTI_COLLISION_BARREL);
        method_46025(RDBlocks.CASH_BOX_BLOCK);
        method_46025(RDBlocks.WHEEL_CHAIR);

        method_46025(RDBlocks.POINT_BLOCK);
        method_46025(RDBlocks.POWER_BLOCK);
        method_45994(RDBlocks.SILVER_ORE, (class_2248 block) -> this.method_45981(block, RDItems.RAW_SILVER));
        method_45994(RDBlocks.DEEPSLATE_SILVER_ORE, (class_2248 block) -> this.method_45981(block, RDItems.RAW_SILVER));
        Function<class_2248, class_52.class_53> orbDropFunction = (class_2248 block) -> {
            class_52.class_53 builder = new class_52.class_53();

            List<class_1792> itemList = List.of(
                    RDItems.RED_ORB,
                    RDItems.BLUE_ORB,
                    RDItems.YELLOW_ORB,
                    RDItems.GREEN_ORB,
                    RDItems.PURPLE_ORB
            );

            for (class_1792 item : itemList) {
                class_55.class_56 pool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.25f))
                        .method_351(class_77.method_411(item));
                builder.method_336(pool);
            }

            class_55.class_56 fallbackPool = class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(RDItems.RED_ORB).method_437(1))
                    .method_351(class_77.method_411(RDItems.BLUE_ORB).method_437(1))
                    .method_351(class_77.method_411(RDItems.YELLOW_ORB).method_437(1))
                    .method_351(class_77.method_411(RDItems.GREEN_ORB).method_437(1))
                    .method_351(class_77.method_411(RDItems.PURPLE_ORB).method_437(1));
            builder.method_336(fallbackPool);

            return builder;
        };
        method_45994(RDBlocks.ORB_ORE, orbDropFunction);
        method_45994(RDBlocks.DEEPSLATE_ORB_ORE, orbDropFunction);
        method_46025(RDBlocks.SILVER_BLOCK);
        method_46025(RDBlocks.SILVER_CHEST_BLOCK.chestBlock());
        Function<class_2248, class_52.class_53> dreamCrystlDropFunction = (class_2248 block) -> {
            class_52.class_53 builder = new class_52.class_53();

            List<class_1792> itemList = List.of(
                    RDItems.DREAM_CRYSTAL_FRAGMENT,
                    RDItems.DREAM_CRYSTAL_FRAGMENT
            );

            for (class_1792 item : itemList) {
                class_55.class_56 pool = class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.25f))
                        .method_351(class_77.method_411(item));
                builder.method_336(pool);
            }

            class_55.class_56 fallbackPool = class_55.method_347()
                    .method_352(class_44.method_32448(1))
                    .method_351(class_77.method_411(RDItems.DREAM_CRYSTAL_FRAGMENT).method_437(1))
                    ;
            builder.method_336(fallbackPool);

            return builder;
        };
        method_45994(RDBlocks.DREAM_CRYSTAL_ORE, dreamCrystlDropFunction);

        this.decorativeBlockCreatorLootFunction.apply(RDBlocks.ICE_SCALES);
        this.decorativeBlockCreatorLootFunction.apply(RDBlocks.DREAM_STONE);
        this.decorativeBlockCreatorLootFunction.apply(RDBlocks.DREAM_STONE_BRICK);
        this.decorativeBlockCreatorLootFunction.apply(RDBlocks.MOON_STONE);
        this.decorativeBlockCreatorLootFunction.apply(RDBlocks.MOON_STONE_BRICK);

        for (FumoType fumo : FumoTypes.getView()) {
            method_46025(fumo.block());
        }

        this.generateMI();
    }

    void generateCropLoot(CropBlockCreator.Instance instance) {
        if (instance.getCropBlock() != null && instance.getProduct() != null) {
            class_212.class_213 condition = class_212
                    .method_900(instance.getCropBlock())
                    .setProperties(
                            class_4559.class_4560
                                    .method_22523()
                                    .method_22526(instance.getCropBlock().getAgeProperty(), instance.getCropBlock().getMaxAge())
                    );
//                LootTable.Builder lootTableBuilder = provider.cropDrops(this.cropBlock, this.product, this.seed, condition);
            class_52.class_53 lootTableBuilder = class_52.method_324();
            class_85.class_86<?> productEntry = class_77.method_411(instance.getProduct())
                    .apply(class_141.method_621(
                            class_5662.method_32462(1.0f, 3.0f)
                    ));
            class_85.class_86<?> seedEntry = class_77.method_411(instance.getSeed())
                    .apply(class_141.method_621(
                            class_5662.method_32462(1.0f, 2.0f)
                    ));
            class_85.class_86<?> baseSeedEntry = class_77.method_411(instance.getSeed())
                    .apply(class_141.method_621(
                            class_44.method_32448(1)
                    ));
            lootTableBuilder.method_336(
                    class_55.method_347()
                            .conditionally(condition.build())
                            .method_352(class_44.method_32448(1))
                            .method_351(baseSeedEntry)
            );
            lootTableBuilder.method_336(
                    class_55.method_347()
                            .conditionally(condition.build())
                            .method_352(class_44.method_32448(1))
                            .method_351(productEntry)
            );
            lootTableBuilder.method_336(
                    class_55.method_347()
                            .conditionally(condition.build())
                            .method_352(class_44.method_32448(1))
                            .method_351(seedEntry)
            );
            this.method_45988(instance.getCropBlock(), lootTableBuilder);
        }
    }


    public void generateMI() {
        for (class_2248 block : AbstractKitchenwareBlock.KITCHENWARE_BLOCKS) {
            method_46025(block);
        }
        method_46025(RDBlocks.ITEM_DISPLAY);

        for (Map.Entry<class_2960, CropBlockCreator.Instance> view : CropBlockCreator.getViews()) {
            CropBlockCreator.Instance instance = view.getValue();
            generateCropLoot(instance);
        }

        this.woodCreatorLootFunction.apply(RDWoodBlocks.SPIRITUAL);
        method_46025(RDWoodBlocks.BLESSED_SPIRITUAL_LOG);

        this.woodCreatorLootFunction.apply(RDWoodBlocks.LEMON);
        method_46006(RDWoodBlocks.LEMON_FRUIT_LEAVES, RDWoodBlocks.LEMON.sapling());

        this.woodCreatorLootFunction.apply(RDWoodBlocks.GINKGO);
        method_46006(RDWoodBlocks.GINKGO_FRUIT_LEAVES, RDWoodBlocks.GINKGO.sapling());

        this.woodCreatorLootFunction.apply(RDWoodBlocks.PEACH);
        method_46006(RDWoodBlocks.PEACH_FRUIT_LEAVES, RDWoodBlocks.PEACH.sapling());

//        addDrop(MIBlocks.COOKTOP);
        method_46025(RDBlocks.BLACK_SALT_BLOCK);
        method_46025(RDWoodBlocks.UDUMBARA_FLOWER);
        method_46025(RDWoodBlocks.TREMELLA);
    }
}
