package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDDrinkItems;
import cc.thonly.reverie_dreams.registry.content.item.RDFoodItems;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_141;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class ChestLootTableProvider extends SimpleFabricLootTableProvider {

    public ChestLootTableProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, registryLookup, class_173.field_1179);
    }

    public static final class_5321<class_52> DREAM_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("dream_chest"));
    public static final class_5321<class_52> OUTER_SHRINE_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("outer_shrine_chest"));
    public static final class_5321<class_52> ABANDONED_ALTAR_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("abandoned_altar_chest"));
    public static final class_5321<class_52> MINI_BAR_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("mini_bar_chest"));
    public static final class_5321<class_52> BAMBOO_FOREST_BBQ_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("bamboo_forest_bbq_chest"));
    public static final class_5321<class_52> SAKURAZUKA_CHEST = class_5321.method_29179(class_7924.field_50079, ReverieDreams.id("sakurazuka_chest"));

    @Override
    public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> lootTableBiConsumer) {
        lootTableBiConsumer.accept(DREAM_CHEST, class_52
                .method_324()
                .method_336(
                        class_55.method_347().method_352(class_44.method_32448(3))
                                .method_351(class_77.method_411(class_1802.field_8477).method_437(1))
                                .method_351(class_77.method_411(class_1802.field_8620).method_437(5))
                                .method_351(class_77.method_411(RDItems.DREAM_CRYSTAL_FRAGMENT).method_437(5))
                )
                .method_336(
                        class_55.method_347().method_352(class_44.method_32448(2))
                                .method_351(class_77.method_411(class_1802.field_8279).method_437(1))
                                .method_351(class_77.method_411(class_1802.field_8229).method_437(1))
                                .method_351(class_77.method_411(RDItems.POINT).method_437(1))
                                .method_351(class_77.method_411(RDItems.POWER).method_437(1))
                )
                .method_336(
                        class_55.method_347().method_352(class_44.method_32448(2))
                                .method_351(class_77.method_411(RDWoodBlocks.LEMON.sapling().method_8389()).method_437(1))
                                .method_351(class_77.method_411(RDItems.UPGRADED_HEALTH).method_437(1))
                                .method_351(class_77.method_411(RDItems.UPGRADED_HEALTH_FRAGMENT).method_437(1))
                                .method_351(class_77.method_411(RDItems.BOMB).method_437(1))
                                .method_351(class_77.method_411(RDItems.BOMB_FRAGMENT).method_437(1))
                )
        );

        lootTableBiConsumer.accept(OUTER_SHRINE_CHEST,
                class_52.method_324()
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 4))
                                        .method_351(class_77.method_411(class_1802.field_8279))
                                        .method_351(class_77.method_411(RDItems.UPGRADED_HEALTH_FRAGMENT).method_438(class_141.method_621(class_5662.method_32462(1.0f, 2.0f))))
                                        .method_351(class_77.method_411(RDItems.BOMB_FRAGMENT))
                                        .method_351(class_77.method_411(RDItems.COOKIE).method_438(class_141.method_621(class_5662.method_32462(1.0f, 2.0f))))
                        )
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 3))
                                        .method_351(class_77.method_411(class_1802.field_8695))
                                        .method_351(class_77.method_411(class_1802.field_8620))
                                        .method_351(class_77.method_411(RDItems.POWER).method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f))))
                                        .method_351(class_77.method_411(RDItems.POINT).method_438(class_141.method_621(class_5662.method_32462(1.0f, 3.0f))))
                        )
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 3))
                                        .method_351(class_77.method_411(class_1802.field_8511))
                                        .method_351(class_77.method_411(class_1802.field_8606))
                                        .method_351(class_77.method_411(class_1802.field_8687))
                        )
        );
        lootTableBiConsumer.accept(ABANDONED_ALTAR_CHEST,
                class_52.method_324()
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 3))
                                        .method_351(class_77.method_411(class_1802.field_8606))
                                        .method_351(class_77.method_411(class_1802.field_8511))
                                        .method_351(class_77.method_411(class_1802.field_8276))
                                        .method_351(class_77.method_411(RDItems.EXORCISM_PAPER))
                        )
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 3))
                                        .method_351(class_77.method_411(class_1802.field_8477))
                                        .method_351(class_77.method_411(class_1802.field_8695))
                        )
                        .method_336(
                                class_55.method_347().method_352(class_5662.method_32462(1, 4))
                                        .method_351(class_77.method_411(RDItems.COPPER_COIN))
                                        .method_351(class_77.method_411(RDItems.SILVER_COIN))
                                        .method_351(class_77.method_411(RDItems.SILVER_COIN))
                        )
        );
        var miniBarPool = class_55.method_347().method_352(class_5662.method_32462(4, 7));
        for (class_1792 drinkItem : RDDrinkItems.DRINK_ITEMS) {
            miniBarPool.method_351(class_77.method_411(drinkItem));
        }
        lootTableBiConsumer.accept(MINI_BAR_CHEST,
                class_52.method_324()
                        .method_336(
                                miniBarPool
                        )
        );
        var bambooForestBbqPool0 = class_55.method_347().method_352(class_5662.method_32462(1, 4));
        for (class_1792 drinkItem : RDFoodItems.FOOD_ITEMS) {
            bambooForestBbqPool0.method_351(class_77.method_411(drinkItem));
        }
        var bambooForestBbqPool1 = class_55.method_347().method_352(class_5662.method_32462(1, 3));
        for (class_1792 drinkItem : RDIngredientItems.INGREDIENTS) {
            bambooForestBbqPool1.method_351(class_77.method_411(drinkItem));
        }
        lootTableBiConsumer.accept(BAMBOO_FOREST_BBQ_CHEST,
                class_52.method_324()
                        .method_336(
                                bambooForestBbqPool0
                        )
                        .method_336(
                                bambooForestBbqPool1
                        )
        );
        lootTableBiConsumer.accept(SAKURAZUKA_CHEST,
                class_52.method_324()
                        .method_336(class_55.method_347()
                                .method_352(class_5662.method_32462(8, 9))
                                .method_351(class_77.method_411(class_1802.field_8695).method_437(10))
                                .method_351(class_77.method_411(class_1802.field_8397).method_437(8))
                                .method_351(class_77.method_411(class_1802.field_8477).method_437(2))
                                .method_351(class_77.method_411(class_1802.field_8606).method_437(7))
                                .method_351(class_77.method_411(class_1802.field_8511).method_437(6))
                                .method_351(class_77.method_411(class_1802.field_42696).method_437(4))
                                .method_351(class_77.method_411(class_1802.field_42688).method_437(3))
                                .method_351(class_77.method_411(class_1802.field_8620).method_437(9))
                                .method_351(class_77.method_411(class_1802.field_8577).method_437(5))
                                .method_351(class_77.method_411(RDItems.POINT).method_437(1))
                                .method_351(class_77.method_411(RDItems.POWER).method_437(1))
                                .method_351(class_77.method_411(RDBlocks.POINT_BLOCK).method_437(1))
                                .method_351(class_77.method_411(RDBlocks.POWER_BLOCK).method_437(1))
                                .method_351(class_77.method_411(class_1802.field_8371).method_437(6))
                                .method_351(class_77.method_411(RDItems.COPPER_COIN).method_437(4))
                                .method_351(class_77.method_411(RDItems.GOLD_COIN).method_437(2))
                        )
        );

    }
}
