package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.block.creator.WoodCreator;
import cc.thonly.reverie_dreams.registry.content.block.KitchenBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDCropBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2450;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7800;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8790;

public class ImplRecipeGenerator extends class_2446 {
    public static ImmutableList<class_1935> SILVER = ImmutableList.of(RDBlocks.SILVER_ORE.method_8389(), RDBlocks.DEEPSLATE_SILVER_ORE.method_8389(), RDItems.RAW_SILVER);
    public static ImmutableList<class_1935> DREAM = ImmutableList.of(RDBlocks.DREAM_CRYSTAL_ORE.method_8389());

    protected ImplRecipeGenerator(class_7225.class_7874 registries, class_8790 exporter) {
        super(registries, exporter);
    }

    @Override
    public void method_10419() {
        // 入门书
        method_62746(class_7800.field_40642, RDItems.TOUHOU_HELPER)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', RDItems.POWER)
                .method_10434('#', class_1802.field_8529)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(RDItems.TOUHOU_HELPER));

        // Point / 块
        offerIngotToBlockRecipe(field_53721, RDItems.POINT, RDBlocks.POINT_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.POINT_BLOCK.method_8389(), RDItems.POINT);

        // Power / 块
        offerIngotToBlockRecipe(field_53721, RDItems.POWER, RDBlocks.POWER_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.POWER_BLOCK.method_8389(), RDItems.POWER);

        // 速度羽毛
        method_62746(class_7800.field_40635, RDItems.SPEED_FEATHER)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8153)
                .method_10434('#', class_1802.field_8477)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(RDItems.SPEED_FEATHER));

        // 梦境枕头
        method_62746(class_7800.field_40635, RDItems.DREAM_PILLOW)
                .method_10439("XXX")
                .method_10439("Y#Y")
                .method_10434('X', class_1802.field_19050)
                .method_10434('Y', class_1802.field_8695)
                .method_10434('#', class_1802.field_8687)
                .method_10429("has_emerald", method_10426(class_1802.field_8687))
                .method_36443(field_53721, method_36450(RDItems.DREAM_PILLOW));

        // 残机
        offer1To4Recipe(field_53721, RDItems.UPGRADED_HEALTH, RDItems.UPGRADED_HEALTH_FRAGMENT);
        method_62747(class_7800.field_40642, RDItems.UPGRADED_HEALTH, 2)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', RDBlocks.POWER_BLOCK)
                .method_10434('#', RDItems.UPGRADED_HEALTH_FRAGMENT)
                .method_10429("has_health_fragment", method_10426(RDItems.UPGRADED_HEALTH_FRAGMENT))
                .method_36443(field_53721, method_36450(RDItems.UPGRADED_HEALTH_FRAGMENT) + "_copy");

        // Bomb
        offer1To4Recipe(field_53721, RDItems.BOMB, RDItems.BOMB_FRAGMENT);
        method_62747(class_7800.field_40642, RDItems.BOMB_FRAGMENT, 2)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', RDBlocks.POINT_BLOCK)
                .method_10434('#', RDItems.BOMB_FRAGMENT)
                .method_10429("has_bomb_fragment", method_10426(RDItems.BOMB_FRAGMENT))
                .method_36443(field_53721, method_36450(RDItems.BOMB_FRAGMENT) + "_copy");

        // 弹幕创作模板
        method_62746(class_7800.field_40642, RDItems.DANMAKU_SHAPE_CREATOR)
                .method_10439("RRR")
                .method_10439("R#R")
                .method_10439("RRR")
                .method_10434('R', RDItems.POWER)
                .method_10434('#', class_1802.field_8674)
                .method_10429("has_power", method_10426(RDItems.POWER))
                .method_36443(field_53721, method_36450(RDItems.DANMAKU_SHAPE_CREATOR));

        // 空白角色卡
        method_62746(class_7800.field_40642, RDItems.ROLE_CARD)
                .method_10439(" R ")
                .method_10439("R#R")
                .method_10439(" R ")
                .method_10434('R', class_1802.field_8725)
                .method_10434('#', class_1802.field_8407)
                .method_10429("has_paper", method_10426(class_1802.field_8407))
                .method_36443(field_53721, method_36450(RDItems.ROLE_CARD));

        // 魔理沙的帽子
        method_62746(class_7800.field_40635, RDBlocks.MARISA_HAT_BLOCK)
                .method_10439(" X ")
                .method_10439("X#X")
                .method_10439("XYX")
                .method_10434('X', class_1802.field_19044)
                .method_10434('Y', class_1802.field_8745)
                .method_10434('#', class_1802.field_19059)
                .method_10429("has_diamond", method_10426(class_1802.field_8477))
                .method_36443(field_53721, method_36450(RDBlocks.MARISA_HAT_BLOCK));

        // 塞钱箱
        method_62746(class_7800.field_40642, RDBlocks.CASH_BOX_BLOCK)
                .method_10439("YYY")
                .method_10439("X#X")
                .method_10439("YYY")
                .method_10434('X', RDWoodBlocks.SPIRITUAL.planks())
                .method_10434('Y', RDWoodBlocks.SPIRITUAL.slab())
                .method_10434('#', class_1802.field_8106)
                .method_10429("has_wool", method_10426(class_1802.field_8106))
                .method_36443(field_53721, method_36450(RDBlocks.CASH_BOX_BLOCK));

        // 防撞桶
        method_62746(class_7800.field_40642, RDBlocks.ANTI_COLLISION_BARREL)
                .method_10439("YXY")
                .method_10439("Z#Z")
                .method_10439("YXY")
                .method_10434('X', class_1802.field_19048)
                .method_10434('Y', class_1802.field_19058)
                .method_10434('Z', class_1802.field_19044)
                .method_10434('#', class_1802.field_8773)
                .method_10429("has_iron_block", method_10426(class_1802.field_8773))
                .method_36443(field_53721, method_36450(RDBlocks.ANTI_COLLISION_BARREL));
        // 轮椅
        method_62746(class_7800.field_40642, RDBlocks.WHEEL_CHAIR)
                .method_10439("Z  ")
                .method_10439("X# ")
                .method_10439("YYY")
                .method_10434('#', class_1802.field_8620)
                .method_10434('X', class_1802.field_8773)
                .method_10434('Y', class_1802.field_55044)
                .method_10434('Z', class_1802.field_19059)
                .method_10429("has_iron", method_10426(class_1802.field_8620))
                .method_36443(field_53721, method_36450(RDBlocks.WHEEL_CHAIR));

        // 木板箱
        method_62746(class_7800.field_40642, RDBlocks.WOODEN_BOX.chestBlock())
                .method_10439("YZY")
                .method_10439("X#X")
                .method_10439("YZY")
                .method_10434('#', class_1802.field_8106)
                .method_10434('X', class_1802.field_8320)
                .method_10434('Y', class_1802.field_8118)
                .method_10434('Z', class_1802.field_8600)
                .method_10429("has_stick", method_10426(class_1802.field_8600))
                .method_36443(field_53721, method_36450(RDBlocks.WOODEN_BOX.chestBlock()));

        // Fumo销售许可
        method_62746(class_7800.field_40642, RDItems.FUMO_LICENSE)
                .method_10439("YXY")
                .method_10439("X#X")
                .method_10439("YXY")
                .method_10434('X', class_1802.field_19044)
                .method_10434('Y', class_1802.field_8477)
                .method_10434('#', class_1802.field_8407)
                .method_10429("has_wool", method_10426(class_1802.field_19044))
                .method_36443(field_53721, method_36450(RDItems.FUMO_LICENSE));

        // 烟火之星
        method_62746(class_7800.field_40642, class_1802.field_8450)
                .method_10439("###")
                .method_10439("#X#")
                .method_10439("###")
                .method_10434('#', class_1802.field_8054)
                .method_10434('X', class_1802.field_8858)
                .method_10429("has_sand", method_10426(class_1802.field_8054))
                .method_36443(field_53721, "rd_provided_" + method_36450(class_1802.field_8450));

        // 弹幕核心
        method_62746(class_7800.field_40642, RDItems.DANMAKU_CORE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('#', class_1802.field_8450)
                .method_10434('X', class_1802.field_8675)
                .method_10429("has_sand", method_10426(class_1802.field_8450))
                .method_36443(field_53721, method_36450(RDItems.DANMAKU_CORE));

        // 空照片
        method_62747(class_7800.field_40642, RDItems.EMPTY_PHOTO, 2)
                .method_10439("YYY")
                .method_10439("###")
                .method_10439("XXX")
                .method_10434('#', class_1802.field_8407)
                .method_10434('Y', class_1802.field_8141)
                .method_10434('X', class_1802.field_8675)
                .method_10429("has_paper", method_10426(class_1802.field_8407))
                .method_36443(field_53721, method_36450(RDItems.EMPTY_PHOTO));

        this.generateWoodCreator(RDWoodBlocks.SPIRITUAL);
        method_62749(class_7800.field_40634, RDWoodBlocks.SPIRITUAL.strippedLog())
                .method_10454(RDWoodBlocks.BLESSED_SPIRITUAL_LOG)
                .method_10442("has_blessed_spiritual_log", method_10426(RDWoodBlocks.BLESSED_SPIRITUAL_LOG))
                .method_36443(field_53721, "cutting_" + method_36450(RDWoodBlocks.BLESSED_SPIRITUAL_LOG));
        method_62747(class_7800.field_40634, RDWoodBlocks.BLESSED_SPIRITUAL_LOG, 1)
                .method_10439("Y")
                .method_10439("X")
                .method_10434('Y', class_1802.field_8407)
                .method_10434('X', RDWoodBlocks.SPIRITUAL.strippedLog())
                .method_10429("has_paper", method_10426(class_1802.field_8407))
                .method_36443(field_53721, method_36450(RDWoodBlocks.BLESSED_SPIRITUAL_LOG));

        this.generateWoodCreator(RDWoodBlocks.LEMON);
        this.generateWoodCreator(RDWoodBlocks.GINKGO);
        this.generateDecorativeBlock();

        this.generateWorkBlock();
        this.generateOrb();
        this.generateSilver();
        this.generateMaid();
        this.generateMagicIce();
        this.generateDream();
        this.generateMusicBlock();
        this.generateIngredient();
        this.generateMIPlant2Ingredient();
        this.generateMICookRecipe();
    }

    private void generateWoodCreator(WoodCreator creator) {
        class_7871<class_1792> itemImpl = this.field_48981.method_46762(class_7924.field_41197);
        class_2248 log = creator.log();
        class_2248 wood = creator.wood();
        class_2248 strippedLog = creator.strippedLog();
        class_2248 strippedWood = creator.strippedWood();
        class_2248 planks = creator.planks();
        class_2248 stair = creator.stairs();
        class_2248 slab = creator.slab();
        class_2248 door = creator.door();
        class_2248 trapdoor = creator.trapdoor();
        class_2248 fence = creator.fence();
        class_2248 fenceGate = creator.fenceGate();
        class_2248 button = creator.button();

        method_33535(creator.getBlockFamily(), class_7699.method_45397());

        // 原木 -> 木板（shapeless）
        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(log)
                .method_10452("planks")
                .method_10442("has_log", method_10426(log))
                .method_36443(field_53721, method_33714(planks, log));

        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(wood)
                .method_10452("planks")
                .method_10442("has_wood", method_10426(wood))
                .method_36443(field_53721, method_33714(planks, wood));
        // 去皮木 -> 木板（shapeless）
        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(strippedLog)
                .method_10452("planks")
                .method_10442("has_log", method_10426(log))
                .method_36443(field_53721, method_33714(planks, strippedLog));

        class_2450.method_10448(itemImpl, class_7800.field_40635, planks, 4)
                .method_10454(strippedWood)
                .method_10452("planks")
                .method_10442("has_wood", method_10426(wood))
                .method_36443(field_53721, method_33714(planks, strippedWood));

        // 木板 -> 楼梯
        method_32808(stair, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 台阶
        method_32804(class_7800.field_40635, slab, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 + 棍子 -> 栅栏
        method_33546(fence, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 + 棍子 -> 栅栏门
        method_33548(fenceGate, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 活板门
        method_33553(trapdoor, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 门
        method_33544(door, class_1856.method_8101(planks))
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);

        // 木板 -> 按钮
        method_33542(button, class_1856.method_8101(planks)).
                method_33529("wooden_button")
                .method_33530("has_planks", method_10426(planks))
                .method_10431(field_53721);
    }

    private void generateIngredient() {
        method_62746(class_7800.field_40640, RDIngredientItems.CHEESE)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', class_1802.field_8103)
                .method_10429("has_milk", method_10426(class_1802.field_8103))
                .method_36443(field_53721, method_36450(RDIngredientItems.CHEESE));
        method_62746(class_7800.field_40640, RDIngredientItems.BUTTER)
                .method_10439("#")
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', class_1802.field_8103)
                .method_10434('X', class_1802.field_8428)
                .method_10429("has_milk", method_10426(RDIngredientItems.FLOUR))
                .method_36443(field_53721, method_36450(RDIngredientItems.BUTTER));
        method_62746(class_7800.field_40640, RDIngredientItems.FLOUR)
                .method_10439("##")
                .method_10439("##")
                .method_10434('#', class_1802.field_8861)
                .method_10429("has_wheat", method_10426(class_1802.field_8861))
                .method_36443(field_53721, method_36450(RDIngredientItems.FLOUR));
        method_62746(class_7800.field_40640, RDIngredientItems.TOFU)
                .method_10439("##")
                .method_10439("##")
                .method_10433('#', RDCropBlocks.SOY_BEANS.getSeed())
                .unlockedBy("has_soy_beans", method_10426(RDCropBlocks.SOY_BEANS.getSeed()))
                .save(field_53721, method_36450(RDIngredientItems.TOFU));
        method_62746(class_7800.field_40640, RDIngredientItems.CAPSAICIN)
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', RDIngredientItems.CHILI)
                .method_10434('X', class_1802.field_8469)
                .method_10429("has_chili", method_10426(RDIngredientItems.CHILI))
                .method_36443(field_53721, method_36450(RDIngredientItems.CAPSAICIN));
        method_62746(class_7800.field_40640, RDIngredientItems.CREAM)
                .method_10439("#")
                .method_10439("#")
                .method_10439("X")
                .method_10434('#', class_1802.field_8103)
                .method_10434('X', class_1802.field_8469)
                .method_10429("has_chili", method_10426(RDIngredientItems.CHILI))
                .method_36443(field_53721, method_36450(RDIngredientItems.CREAM));

        method_36233(List.of(RDIngredientItems.BLACK_PORK, RDIngredientItems.WILD_BOAR_MEAT), class_7800.field_40642, class_1802.field_8261, 0.7F, 160, "food");

//        createShaped(RecipeCategory.FOOD, MIItems.FLOWERS)
//                .pattern("##")
//                .pattern("##")
//                .input('#', ItemTags.FLOWERS)
//                .criterion("has_wheat", conditionsFromItem(Items.WHEAT))
//                .offerTo(exporter, getRecipeName(MIItems.FLOUR));
    }

    private void generateDecorativeBlock() {
        RDBlocks.ICE_SCALES.offerRecipe(this, RDItems.ICE_SCALES);
        RDBlocks.DREAM_STONE.offerRecipe(this, RDBlocks.DREAM_STONE.block().method_8389());
        RDBlocks.DREAM_STONE_BRICK.offerRecipe(this, RDBlocks.DREAM_STONE_BRICK.block().method_8389());
        RDBlocks.MOON_STONE.offerRecipe(this, RDBlocks.MOON_STONE.block().method_8389());
        RDBlocks.MOON_STONE_BRICK.offerRecipe(this, RDBlocks.MOON_STONE_BRICK.block().method_8389());
    }

    private void generateMusicBlock() {
        // 音乐盒
        method_62746(class_7800.field_40636, RDBlocks.MUSIC_BLOCK)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8687)
                .method_10434('#', class_1802.field_8643)
                .method_10429("has_emerald", method_10426(class_1802.field_8687))
                .method_36443(field_53721, method_36450(RDBlocks.MUSIC_BLOCK));
        // 小提琴
        method_62746(class_7800.field_40638, RDItems.VIOLIN)
                .method_10439(" X ")
                .method_10439("XYX")
                .method_10439("X#X")
                .method_10434('X', class_1802.field_8113)
                .method_10434('Y', class_1802.field_8276)
                .method_10434('#', RDBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(RDBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(RDItems.VIOLIN));
        // 键盘
        method_62746(class_7800.field_40638, RDItems.KEYBOARD)
                .method_10439("XYX")
                .method_10439("YXY")
                .method_10439("Z#W")
                .method_10434('X', class_1802.field_19059)
                .method_10434('Y', class_1802.field_8592)
                .method_10434('Z', class_1802.field_8781)
                .method_10434('W', class_1802.field_8725)
                .method_10434('#', RDBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(RDBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(RDItems.KEYBOARD));
        // 小号
        method_62746(class_7800.field_40638, RDItems.TRUMPET)
                .method_10439("XXX")
                .method_10439("XY#")
                .method_10439("ZYX")
                .method_10434('X', class_1802.field_8695)
                .method_10434('Y', class_1802.field_8781)
                .method_10434('Z', class_1802.field_8725)
                .method_10434('#', RDBlocks.MUSIC_BLOCK)
                .method_10429("has_music_block", method_10426(RDBlocks.MUSIC_BLOCK))
                .method_36443(field_53721, method_36450(RDItems.TRUMPET));
    }

    private void generateWorkBlock() {
        // 弹幕工作台
        method_62746(class_7800.field_40635, RDBlocks.DANMAKU_CRAFTING_TABLE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8725)
                .method_10434('#', class_1802.field_8465)
                .method_10429("has_redstone", method_10426(class_1802.field_8725))
                .method_36443(field_53721, method_36450(RDBlocks.DANMAKU_CRAFTING_TABLE));

        // 幻想乡祭坛
        method_62746(class_7800.field_40635, RDBlocks.GENSOKYO_ALTAR)
                .method_10439("X")
                .method_10439("#")
                .method_10434('X', class_1802.field_8733)
                .method_10434('#', class_1802.field_8657)
                .method_10429("has_emerald", method_10426(class_1802.field_8733))
                .method_36443(field_53721, method_36450(RDBlocks.GENSOKYO_ALTAR));

        // 强化台
        method_62746(class_7800.field_40635, RDBlocks.STRENGTH_TABLE)
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', RDItems.SILVER_INGOT)
                .method_10434('#', class_1802.field_8657)
                .method_10429("has_silver", method_10426(RDItems.SILVER_INGOT))
                .method_36443(field_53721, method_36450(RDBlocks.STRENGTH_TABLE));
    }

    private void generateOrb() {
        // 宝玉 / 宝玉块
        offerIngotToBlockRecipe(field_53721, RDItems.RED_ORB, RDBlocks.RED_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.RED_ORB_BLOCK.method_8389(), RDItems.RED_ORB);

        offerIngotToBlockRecipe(field_53721, RDItems.YELLOW_ORB, RDBlocks.YELLOW_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.YELLOW_ORB_BLOCK.method_8389(), RDItems.YELLOW_ORB);

        offerIngotToBlockRecipe(field_53721, RDItems.BLUE_ORB, RDBlocks.BLUE_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.BLUE_ORB_BLOCK.method_8389(), RDItems.BLUE_ORB);

        offerIngotToBlockRecipe(field_53721, RDItems.GREEN_ORB, RDBlocks.GREEN_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.GREEN_ORB_BLOCK.method_8389(), RDItems.GREEN_ORB);

        offerIngotToBlockRecipe(field_53721, RDItems.PURPLE_ORB, RDBlocks.PURPLE_ORB_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.PURPLE_ORB_BLOCK.method_8389(), RDItems.PURPLE_ORB);

    }

    private void generateSilver() {
        // 银武器/工具
        offerSwordRecipe(field_53721, RDItems.SILVER_SWORD, RDItems.SILVER_INGOT);
        offerPickaxeRecipe(field_53721, RDItems.SILVER_PICKAXE, RDItems.SILVER_INGOT);
        offerAxeRecipe(field_53721, RDItems.SILVER_AXE, RDItems.SILVER_INGOT);
        offerShovelRecipe(field_53721, RDItems.SILVER_SHOVEL, RDItems.SILVER_INGOT);
        offerHoeRecipe(field_53721, RDItems.SILVER_HOE, RDItems.SILVER_INGOT);

        // 银盔甲
        offerHelmetRecipe(field_53721, RDItems.SILVER_HELMET, RDItems.SILVER_INGOT);
        offerChestplateRecipe(field_53721, RDItems.SILVER_CHESTPLATE, RDItems.SILVER_INGOT);
        offerLeggingsRecipe(field_53721, RDItems.SILVER_LEGGINGS, RDItems.SILVER_INGOT);
        offerBootsRecipe(field_53721, RDItems.SILVER_BOOTS, RDItems.SILVER_INGOT);

        // 银粒 / 锭 / 块
        offerIngotToBlockRecipe(field_53721, RDItems.SILVER_NUGGET, RDItems.SILVER_INGOT);
        offerBlockToIngotRecipe(field_53721, RDItems.SILVER_INGOT, RDItems.SILVER_NUGGET);
        offerIngotToBlockRecipe(field_53721, RDItems.SILVER_INGOT, RDBlocks.SILVER_BLOCK.method_8389());
        offerBlockToIngotRecipe(field_53721, RDBlocks.SILVER_BLOCK.method_8389(), RDItems.SILVER_INGOT);

        method_62746(class_7800.field_40635, RDBlocks.SILVER_CHEST_BLOCK.chestBlock())
                .method_10439("XXX")
                .method_10439("X#X")
                .method_10439("XXX")
                .method_10434('X', RDItems.SILVER_INGOT)
                .method_10434('#', class_1802.field_8106)
                .method_10429("has_silver", method_10426(RDItems.SILVER_INGOT))
                .method_36443(field_53721, method_36450(RDBlocks.SILVER_CHEST_BLOCK.chestBlock()));

        // 烧银矿
        method_36233(SILVER, class_7800.field_40642, RDItems.SILVER_INGOT, 0.7F, 250, "silver_ingot");
        method_36234(SILVER, class_7800.field_40642, RDItems.SILVER_INGOT, 0.7F, 250, "silver_ingot");

    }

    private void generateMaid() {
        Map<class_1792, class_1792> itemItemMap = new HashMap<>(
                Map.of(
                        RDItems.SILVER_HELMET, RDItems.MAID_HAIRBAND,
                        RDItems.SILVER_CHESTPLATE, RDItems.MAID_UPPER_SKIRT,
                        RDItems.SILVER_LEGGINGS, RDItems.MAID_LOWER_SKIRT,
                        RDItems.SILVER_BOOTS, RDItems.MAID_SHOE
                )
        );
        for (Map.Entry<class_1792, class_1792> itemItemEntry : itemItemMap.entrySet()) {
            class_1792 left = itemItemEntry.getKey();
            class_1792 right = itemItemEntry.getValue();
            method_62746(class_7800.field_40636, right)
                    .method_10439("XXX")
                    .method_10439("X#X")
                    .method_10439("XXX")
                    .method_10433('X', class_3489.field_15544)
                    .method_10434('#', left)
                    .method_10429("has_wool", method_10420(class_3489.field_15544))
                    .method_36443(field_53721, method_36450(right));
        }
    }

    private void generateMagicIce() {
        method_36233(List.of(RDBlocks.MAGIC_ICE_BLOCK.method_8389()), class_7800.field_40642, RDItems.ICE_SCALES, 0.7F, 140, "silver_ingot");
        method_36234(List.of(RDBlocks.MAGIC_ICE_BLOCK.method_8389()), class_7800.field_40642, RDItems.ICE_SCALES, 0.7F, 70, "silver_ingot");
        // 魔法冰
        method_62746(class_7800.field_40635, RDBlocks.MAGIC_ICE_BLOCK)
                .method_10439("XX")
                .method_10439("XX")
                .method_10434('X', class_1802.field_8426)
                .method_10429("has_ice", method_10426(class_1802.field_8426))
                .method_36443(field_53721, method_36450(RDBlocks.MAGIC_ICE_BLOCK));

        // 冰武器/工具
        offerSwordRecipe(field_53721, RDItems.MAGIC_ICE_SWORD, RDItems.ICE_SCALES);
        offerPickaxeRecipe(field_53721, RDItems.MAGIC_ICE_PICKAXE, RDItems.ICE_SCALES);
        offerAxeRecipe(field_53721, RDItems.MAGIC_ICE_AXE, RDItems.ICE_SCALES);
        offerShovelRecipe(field_53721, RDItems.MAGIC_ICE_SHOVEL, RDItems.ICE_SCALES);
        offerHoeRecipe(field_53721, RDItems.MAGIC_ICE_HOE, RDItems.ICE_SCALES);

        // 冰盔甲
        offerHelmetRecipe(field_53721, RDItems.MAGIC_ICE_HELMET, RDBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerChestplateRecipe(field_53721, RDItems.MAGIC_ICE_CHESTPLATE, RDBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerLeggingsRecipe(field_53721, RDItems.MAGIC_ICE_LEGGINGS, RDBlocks.MAGIC_ICE_BLOCK.method_8389());
        offerBootsRecipe(field_53721, RDItems.MAGIC_ICE_BOOTS, RDBlocks.MAGIC_ICE_BLOCK.method_8389());

    }

    private void generateDream() {
        // 梦境水晶武器/工具
        offerSwordRecipe(field_53721, RDItems.DREAM_SWORD, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerPickaxeRecipe(field_53721, RDItems.DREAM_PICKAXE, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerAxeRecipe(field_53721, RDItems.DREAM_AXE, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerShovelRecipe(field_53721, RDItems.DREAM_SHOVEL, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerHoeRecipe(field_53721, RDItems.DREAM_HOE, RDItems.DREAM_CRYSTAL_FRAGMENT);

        // 梦境水晶盔甲
        offerHelmetRecipe(field_53721, RDItems.DREAM_HELMET, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerChestplateRecipe(field_53721, RDItems.DREAM_CHESTPLATE, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerLeggingsRecipe(field_53721, RDItems.DREAM_LEGGINGS, RDItems.DREAM_CRYSTAL_FRAGMENT);
        offerBootsRecipe(field_53721, RDItems.DREAM_BOOTS, RDItems.DREAM_CRYSTAL_FRAGMENT);

        // 防水衣
        method_62746(class_7800.field_40642, RDItems.WATERPROOF_LEATHER)
                .method_10434('X', class_1802.field_8745)
                .method_10434('Y', class_1802.field_8161)
                .method_10434('R', class_1802.field_8725)
                .method_10434('E', class_1802.field_20414)
                .method_10429("has_leather", method_10426(class_1802.field_8745))
                .method_10439("RYR")
                .method_10439("RXR")
                .method_10439("RER")
                .method_10431(field_53721);
        offerHelmetRecipe(field_53721, RDItems.WATER_PROOF_HAT, RDItems.WATERPROOF_LEATHER);
        offerChestplateRecipe(field_53721, RDItems.WATER_PROOF_CLOTHING, RDItems.WATERPROOF_LEATHER);
        offerLeggingsRecipe(field_53721, RDItems.WATER_PROOF_LEGGINGS, RDItems.WATERPROOF_LEATHER);
        offerBootsRecipe(field_53721, RDItems.WATER_PROOF_BOOTS, RDItems.WATERPROOF_LEATHER);

        // 烧梦境水晶矿
        method_36233(DREAM, class_7800.field_40642, RDItems.DREAM_CRYSTAL_FRAGMENT, 0.7F, 250, "dream_ingot");
        method_36234(DREAM, class_7800.field_40642, RDItems.DREAM_CRYSTAL_FRAGMENT, 0.7F, 250, "dream_ingot");

    }

    private void generateMIPlant2Ingredient() {
        method_62746(class_7800.field_40640, RDIngredientItems.UDUMBARA)
                .method_10439("#")
                .method_10434('#', RDWoodBlocks.UDUMBARA_FLOWER)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(RDIngredientItems.UDUMBARA));
        method_62746(class_7800.field_40640, RDIngredientItems.TREMELLA)
                .method_10439("#")
                .method_10434('#', RDWoodBlocks.TREMELLA)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(RDIngredientItems.TREMELLA));
    }

    private void generateMICookRecipe() {
        // 厨具
        method_62746(class_7800.field_40635, KitchenBlocks.COOKING_POT)
                .method_10439(" Y ")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(KitchenBlocks.COOKING_POT));

        method_62746(class_7800.field_40635, KitchenBlocks.CUTTING_BOARD)
                .method_10439(" Y ")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8320)
                .method_10434('Y', class_1802.field_8371)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(KitchenBlocks.CUTTING_BOARD));

        method_62746(class_7800.field_40635, KitchenBlocks.FRYING_PAN)
                .method_10439(" XX")
                .method_10439(" XX")
                .method_10439("Y  ")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(KitchenBlocks.FRYING_PAN));

        method_62746(class_7800.field_40635, KitchenBlocks.GRILL)
                .method_10439("YYY")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8675)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(KitchenBlocks.GRILL));

        method_62746(class_7800.field_40635, KitchenBlocks.STEAMER)
                .method_10439("YYY")
                .method_10439("X X")
                .method_10439("XXX")
                .method_10434('X', class_1802.field_8620)
                .method_10434('Y', class_1802.field_8320)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(KitchenBlocks.STEAMER));
        method_62746(class_7800.field_40635, RDBlocks.ITEM_DISPLAY)
                .method_10439("YXY")
                .method_10439(" Y ")
                .method_10434('X', class_1802.field_8143)
                .method_10434('Y', class_1802.field_8155)
                .method_10429("always", method_10426(class_1802.field_8162))
                .method_36443(field_53721, method_36450(RDBlocks.ITEM_DISPLAY));

        this.offerMIUpgradeRecipes();
//        // 能量罩
//        createShaped(RecipeCategory.DECORATIONS, MIBlocks.COOKTOP)
//                .pattern("YYY")
//                .pattern("YXY")
//                .pattern("YYY")
//                .input('X', Items.FURNACE)
//                .input('Y', Items.BRICKS)
//                .criterion("always", conditionsFromItem(Items.AIR))
//                .offerTo(exporter, getRecipeName(MIBlocks.COOKTOP));
    }

    private void offerMIUpgradeRecipes() {
        Map<class_2248, class_2248> mystiaUpgrade = new Object2ObjectOpenHashMap<>();
        mystiaUpgrade.put(KitchenBlocks.COOKING_POT, KitchenBlocks.MYSTIA_COOKING_POT);
        mystiaUpgrade.put(KitchenBlocks.CUTTING_BOARD, KitchenBlocks.MYSTIA_CUTTING_BOARD);
        mystiaUpgrade.put(KitchenBlocks.FRYING_PAN, KitchenBlocks.MYSTIA_FRYING_PAN);
        mystiaUpgrade.put(KitchenBlocks.GRILL, KitchenBlocks.MYSTIA_GRILL);
        mystiaUpgrade.put(KitchenBlocks.STEAMER, KitchenBlocks.MYSTIA_STEAMER);
        this.offerUpgradeRecipes(mystiaUpgrade, class_1802.field_8153);

        Map<class_2248, class_2248> superUpgrade = new Object2ObjectOpenHashMap<>();
        superUpgrade.put(KitchenBlocks.COOKING_POT, KitchenBlocks.SUPER_COOKING_POT);
        superUpgrade.put(KitchenBlocks.CUTTING_BOARD, KitchenBlocks.SUPER_CUTTING_BOARD);
        superUpgrade.put(KitchenBlocks.FRYING_PAN, KitchenBlocks.SUPER_FRYING_PAN);
        superUpgrade.put(KitchenBlocks.GRILL, KitchenBlocks.SUPER_GRILL);
        superUpgrade.put(KitchenBlocks.STEAMER, KitchenBlocks.SUPER_STEAMER);
        this.offerUpgradeRecipes(superUpgrade, class_1802.field_8695);

        Map<class_2248, class_2248> extremeUpgrade = new Object2ObjectOpenHashMap<>();
        extremeUpgrade.put(KitchenBlocks.COOKING_POT, KitchenBlocks.EXTREME_COOKING_POT);
        extremeUpgrade.put(KitchenBlocks.CUTTING_BOARD, KitchenBlocks.EXTREME_CUTTING_BOARD);
        extremeUpgrade.put(KitchenBlocks.FRYING_PAN, KitchenBlocks.EXTREME_FRYING_PAN);
        extremeUpgrade.put(KitchenBlocks.GRILL, KitchenBlocks.EXTREME_GRILL);
        extremeUpgrade.put(KitchenBlocks.STEAMER, KitchenBlocks.EXTREME_STEAMER);
        this.offerUpgradeRecipes(extremeUpgrade, class_1802.field_8477);

        Map<class_2248, class_2248> nukeUpgrade = new Object2ObjectOpenHashMap<>();
        nukeUpgrade.put(KitchenBlocks.COOKING_POT, KitchenBlocks.NUKE_COOKING_POT);
        nukeUpgrade.put(KitchenBlocks.CUTTING_BOARD, KitchenBlocks.NUKE_CUTTING_BOARD);
        nukeUpgrade.put(KitchenBlocks.FRYING_PAN, KitchenBlocks.NUKE_FRYING_PAN);
        nukeUpgrade.put(KitchenBlocks.GRILL, KitchenBlocks.NUKE_GRILL);
        nukeUpgrade.put(KitchenBlocks.STEAMER, KitchenBlocks.NUKE_STEAMER);
        this.offerUpgradeRecipes(nukeUpgrade, class_1802.field_20398);


    }

    private void offerUpgradeRecipes(Map<class_2248, class_2248> blockBlockMap, class_1792 upgradeMaterial) {
        Set<Map.Entry<class_2248, class_2248>> entries = blockBlockMap.entrySet();
        for (Map.Entry<class_2248, class_2248> entry : entries) {
            class_2248 key = entry.getKey();
            class_2248 value = entry.getValue();
            method_62746(class_7800.field_40635, value)
                    .method_10439("YYY")
                    .method_10439("YXY")
                    .method_10439("YYY")
                    .method_10434('X', key)
                    .method_10434('Y', upgradeMaterial)
                    .method_10429("always", method_10426(class_1802.field_8162))
                    .method_36443(field_53721, method_36450(value));
        }
    }

    private void offerSwordRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X")
                .method_10439("X")
                .method_10439("#")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerPickaxeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XXX")
                .method_10439(" # ")
                .method_10439(" # ")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerAxeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XX")
                .method_10439("X#")
                .method_10439(" #")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerShovelRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("X")
                .method_10439("#")
                .method_10439("#")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerHoeRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40638, result)
                .method_10439("XX")
                .method_10439(" #")
                .method_10439(" #")
                .method_10434('X', ingot)
                .method_10434('#', class_1802.field_8600)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerHelmetRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("XXX")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerChestplateRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X X")
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerLeggingsRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("XXX")
                .method_10439("X X")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offerBootsRecipe(class_8790 exporter, class_1792 result, class_1792 ingot) {
        method_62746(class_7800.field_40639, result)
                .method_10439("X X")
                .method_10439("X X")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(result));
    }

    private void offer4To1Recipe(class_8790 exporter, class_1792 input, class_1792 export) {
        class_2960 id = class_7923.field_41178.method_10221(input);
        method_62746(class_7800.field_40634, export)
                .method_10439("XX")
                .method_10439("XX")
                .method_10434('X', input)
                .method_10429("has_" + id.method_12832(), method_10426(input))
                .method_36443(exporter, method_36450(export));
    }

    private void offer1To4Recipe(class_8790 exporter, class_1792 input, class_1792 export) {
        class_2960 id = class_7923.field_41178.method_10221(input);
        method_62747(class_7800.field_40634, export, 4)
                .method_10439("X")
                .method_10434('X', input)
                .method_10429("has_" + id.method_12832(), method_10426(input))
                .method_36443(exporter, method_36450(export));
    }

    private void offerIngotToBlockRecipe(class_8790 exporter, class_1792 ingot, class_1792 block) {
        method_62746(class_7800.field_40634, block)
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10439("XXX")
                .method_10434('X', ingot)
                .method_10429("has_ingot", method_10426(ingot))
                .method_36443(exporter, method_36450(block));
    }

    private void offerBlockToIngotRecipe(class_8790 exporter, class_1792 block, class_1792 ingot) {
        method_62750(class_7800.field_40642, ingot, 9)
                .method_10454(block)
                .method_10442("has_block", method_10426(block))
                .method_36443(exporter, method_36450(ingot) + "_from_block");
    }


}
