package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.datagen.generator.AbstractRecipeTypeProvider;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.recipe.entry.GensokyoAltarRecipe;
import cc.thonly.reverie_dreams.recipe.entry.KitchenRecipe;
import cc.thonly.reverie_dreams.recipe.type.KitchenRecipeType;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.RoleCards;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.registry.content.effect.RDPotions;
import cc.thonly.reverie_dreams.registry.content.item.RDFoodItems;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public class RecipeTypeProvider extends AbstractRecipeTypeProvider {
    public final Factory<GensokyoAltarRecipe> gensokyoAltarRecipeFactory = this.getOrCreateFactory(RecipeManager.GENSOKYO_ALTAR, GensokyoAltarRecipe.class);
    public final Factory<DanmakuRecipe> danmakuRecipeFactory = this.getOrCreateFactory(RecipeManager.DANMAKU_TYPE, DanmakuRecipe.class);
    public final Factory<DanmakuShapeDrawRecipe> danmakuShapeDrawRecipeFactory = this.getOrCreateFactory(RecipeManager.DANMAKU_SHAPE_DRAW_TYPE, DanmakuShapeDrawRecipe.class);
    public final Factory<KitchenRecipe> kitchenRecipeFactory = this.getOrCreateFactory(RecipeManager.KITCHEN_TYPE, KitchenRecipe.class);

    public RecipeTypeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        super(output, future);
    }

    @Override
    public void configured() {
        this.generateGensokyoAltarRecipe();
        this.generateRoleCardRecipe();
        this.generateDanmakuRecipe();
        this.generateShapeDraw();
        this.generateKitchenRecipe();
    }

    @SuppressWarnings("SpellCheckingInspection")
    public void generateShapeDraw() {
        DanmakuTypes.AMULET.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FFTTFF",
                "FFTTFF",
                "FFTTFF",
                "FFTTFF",
                "FFFFFF"
        });
        DanmakuTypes.ARROWHEAD.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FFTTFF",
                "FTTTTF",
                "FTTTTF",
                "FTFFTF",
                "FFFFFF"
        });
        DanmakuTypes.BALL.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FFFFFF",
                "FFTTFF",
                "FFTTFF",
                "FFFFFF",
                "FFFFFF"
        });
        DanmakuTypes.BUBBLE.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FTTTTF",
                "FTTTTF",
                "FTTTTF",
                "FTTTTF",
                "FFFFFF"
        });
        DanmakuTypes.BULLET.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FFTTFF",
                "FTTTTF",
                "FTTTTF",
                "FTTTTF",
                "FFFFFF"
        });
        DanmakuTypes.FIREBALL.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFTTFF",
                "FTFFTF",
                "TFTTFT",
                "TFTTFT",
                "FTFFTF",
                "FFTTFF"
        });
        DanmakuTypes.FIREBALL_GLOWY.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFTTFF",
                "FTTTTF",
                "TTTTTT",
                "TTTTTT",
                "FTTTTF",
                "FFTTFF"
        });
        DanmakuTypes.KUNAI.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFTTFF",
                "FTTTTF",
                "FFTTFF",
                "FFTTFF",
                "FTFFTF",
                "FFFFFF"
        });
        DanmakuTypes.RICE.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFTTFF",
                "FTTTTF",
                "FTTTTF",
                "FTTTTF",
                "FTTTTF",
                "FFTTFF"
        });
        DanmakuTypes.STAR.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFFF",
                "FFTTFF",
                "TTTTTT",
                "FFTTFF",
                "FTFFTF",
                "FFFFFF"
        });
        DanmakuTypes.NOTE.buildShapeRecipe(this.danmakuShapeDrawRecipeFactory, new String[]{
                "FFFFTF",
                "FFFFTF",
                "FFFFTF",
                "FTTFTF",
                "FTTFFF",
                "FTTFFF"
        });

    }

    public void generateRoleCardRecipe() {
        RoleCards.PROTAGONIST_GROUP
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8793, 2), ItemStackWrapper.of(class_1802.field_8281, 5))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KOUMAKYOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8067, 12), ItemStackWrapper.of(class_1802.field_8328, 12))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.YOUYOUMU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_42694, 26), ItemStackWrapper.of(class_1802.field_8371, 1))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.EIYASHOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8648, 50), ItemStackWrapper.of(class_1802.field_20399, 24))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KAEIZUKA
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8491, 30), ItemStackWrapper.of(class_1802.field_17500, 30))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.FUUJINROKU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_55711, 40), ItemStackWrapper.of(class_1802.field_20391, 40))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.CHIREIDEN
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_17527, 40), ItemStackWrapper.of(class_1802.field_8328, 45))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.SEIRENSEN
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8695, 28), ItemStackWrapper.of(class_1802.field_8442, 1))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.SHINREIBYOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8067, 38), ItemStackWrapper.of(class_1802.field_8511, 18))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KISHINJOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8894, 26), ItemStackWrapper.of(class_1802.field_20398, 30))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KANJUDEN
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_20399, 32), ItemStackWrapper.of(class_1802.field_8328, 32))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.TENKUUSHOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8270, 29), ItemStackWrapper.of(class_1802.field_55711, 43))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KIKEIJUU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8831, 44), ItemStackWrapper.of(class_1802.field_8183, 30))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KOURYUUDOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8695, 31), ItemStackWrapper.of(class_1802.field_8477, 23))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.JUUOUEN
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8745, 26), ItemStackWrapper.of(class_1802.field_8389, 20))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.KINJOUKYOU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_20391, 31), ItemStackWrapper.of(class_1802.field_8695, 38))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.SANGETSUSEI
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_20399, 28), ItemStackWrapper.of(class_1802.field_8801, 26))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.HIFUU
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8529, 19), ItemStackWrapper.of(class_1802.field_8449, 20))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);
        RoleCards.TASOGARE_FURONTIA
                .createRecipeBuilder()
                .itemStack(ItemStackWrapper.of(class_1802.field_8469, 20), ItemStackWrapper.of(RDIngredientItems.PEACH, 15))
                .build()
                .apply(this.gensokyoAltarRecipeFactory);

    }

    public void generateGensokyoAltarRecipe() {
        this.gensokyoAltarRecipeFactory.register(RDItems.HORAI_DAMA_NO_EDA,
                new GensokyoAltarRecipe(
                        this.ofItem(class_1802.field_8603),
                        List.of(
                                this.ofItem(RDItems.RED_ORB, 10), this.ofItem(RDItems.BLUE_ORB, 10), this.ofItem(RDItems.YELLOW_ORB, 10),
                                this.ofEmpty(), this.ofItem(RDItems.GREEN_ORB, 10),
                                this.ofItem(class_1802.field_8600), this.ofEmpty(), this.ofItem(RDItems.PURPLE_ORB, 10)
                        ),
                        this.ofItem(RDItems.HORAI_DAMA_NO_EDA)
                )
        );
        this.gensokyoAltarRecipeFactory.register(RDItems.CROSSING_CHISEL, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8303),
                List.of(
                        this.ofItem(class_1802.field_8634, 2), this.ofItem(class_1802.field_8494), this.ofItem(class_1802.field_8634, 4),
                        this.ofItem(class_1802.field_8695, 4), this.ofItem(class_1802.field_8695, 4),
                        this.ofItem(class_1802.field_8634, 8), this.ofItem(class_1802.field_8494), this.ofItem(class_1802.field_8634, 16)
                ),
                this.ofItem(RDItems.CROSSING_CHISEL)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.GAP_BALL, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8251),
                List.of(
                        this.ofItem(class_1802.field_8296, 2), this.ofItem(class_1802.field_8634, 6), this.ofItem(class_1802.field_8793, 1),
                        this.ofItem(class_1802.field_8669, 2), this.ofItem(class_1802.field_27022),
                        this.ofItem(class_1802.field_27022, 6), this.ofItem(class_1802.field_27022, 7), this.ofItem(class_1802.field_27022, 8)
                ),
                this.ofItem(RDItems.GAP_BALL)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.BAGUA_FURNACE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8251),
                List.of(
                        this.ofItem(class_1802.field_8793, 8), this.ofItem(class_1802.field_8620, 12), this.ofItem(class_1802.field_8797),
                        this.ofItem(class_1802.field_22020, 4), this.ofItem(class_1802.field_27022, 16),
                        this.ofItem(class_1802.field_8797), this.ofItem(class_1802.field_8620, 12), this.ofItem(class_1802.field_8793, 8)
                ),
                this.ofItem(RDItems.BAGUA_FURNACE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.TIME_STOP_CLOCK, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8557),
                List.of(
                        this.ofItem(class_1802.field_8296, 4), this.ofItem(class_1802.field_8793, 2), this.ofItem(class_1802.field_8296, 4),
                        this.ofItem(class_1802.field_8695, 5), this.ofItem(class_1802.field_8695, 5),
                        this.ofItem(class_1802.field_8296, 4), this.ofItem(class_1802.field_8793, 2), this.ofItem(class_1802.field_8296, 4)
                ),
                this.ofItem(RDItems.TIME_STOP_CLOCK)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.MAPLE_LEAF_FAN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_17503, 48),
                List.of(
                        this.ofItem(class_1802.field_49098, 16), this.ofItem(class_1802.field_8695, 9), this.ofItem(class_1802.field_49098, 16),
                        this.ofItem(class_1802.field_8695, 9), this.ofItem(class_1802.field_8695, 9),
                        this.ofItem(class_1802.field_49821, 2), this.ofItem(class_1802.field_8695, 9), this.ofItem(class_1802.field_49098, 16)
                ),
                this.ofItem(RDItems.MAPLE_LEAF_FAN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.EARPHONE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8743),
                List.of(
                        this.ofItem(class_1802.field_27063, 5), this.ofItem(class_1802.field_8695, 6), this.ofItem(class_1802.field_27063, 5),
                        this.ofItem(class_1802.field_28101, 9), this.ofItem(class_1802.field_28101, 9),
                        this.ofEmpty(), this.ofItem(class_1802.field_8725, 18), this.ofEmpty()
                ),
                this.ofItem(RDItems.EARPHONE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.KOISHI_HAT, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8743),
                List.of(
                        this.ofItem(class_1802.field_8226, 2), this.ofItem(class_1802.field_8620, 1), this.ofItem(class_1802.field_8226, 2),
                        this.ofItem(class_1802.field_8620, 1), this.ofItem(class_1802.field_8620, 1),
                        this.ofItem(class_1802.field_8192, 3), this.ofItem(class_1802.field_8226, 2), this.ofItem(class_1802.field_8192, 3)
                ),
                this.ofItem(RDItems.KOISHI_HAT)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.HAKUREI_CANE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8091),
                List.of(
                        this.ofEmpty(), this.ofItem(class_1802.field_8407, 6), this.ofItem(class_1802.field_8407, 6),
                        this.ofItem(class_1802.field_8620, 1), this.ofItem(class_1802.field_8407, 6),
                        this.ofItem(class_1802.field_8600, 1), this.ofEmpty(), this.ofItem(class_1802.field_8407, 3)
                ),
                this.ofItem(RDItems.HAKUREI_CANE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.WIND_BLESSING_CANE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8091),
                List.of(
                        this.ofEmpty(), this.ofItem(class_1802.field_8407, 5), this.ofItem(class_1802.field_8407, 7),
                        this.ofItem(class_1802.field_49098, 12), this.ofItem(class_1802.field_8407, 5),
                        this.ofItem(class_1802.field_8600, 1), this.ofEmpty(), this.ofItem(class_1802.field_8407, 2)
                ),
                this.ofItem(RDItems.WIND_BLESSING_CANE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.MAGIC_BROOM, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8793, 3),
                List.of(
                        this.ofItem(class_1802.field_17528, 2), this.ofItem(class_1802.field_8719), this.ofItem(class_1802.field_8175),
                        this.ofItem(class_1802.field_17528, 2), this.ofItem(class_1802.field_8600, 3),
                        this.ofItem(class_1802.field_17528, 2), this.ofItem(class_1802.field_8777), this.ofEmpty()
                ),
                this.ofItem(RDItems.MAGIC_BROOM)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.KNIFE, new GensokyoAltarRecipe(
                this.ofItem(RDBlocks.SILVER_BLOCK, 2),
                List.of(
                        this.ofItem(RDItems.SILVER_SWORD), this.ofEmpty(), this.ofItem(RDItems.SILVER_INGOT, 3),
                        this.ofItem(RDItems.SILVER_SWORD), this.ofEmpty(),
                        this.ofItem(class_1802.field_8600, 3), this.ofEmpty(), this.ofEmpty()
                ),
                this.ofItem(RDItems.KNIFE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.ROKANKEN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8371),
                List.of(
                        this.ofItem(class_1802.field_8067, 7), this.ofItem(class_1802.field_8067, 8), this.ofItem(RDItems.SILVER_INGOT, 12),
                        this.ofItem(class_1802.field_8067, 6), this.ofEmpty(),
                        this.ofItem(class_1802.field_42693, 4), this.ofEmpty(), this.ofEmpty()
                ),
                this.ofItem(RDItems.ROKANKEN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.HAKUROKEN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8371),
                List.of(
                        this.ofItem(class_1802.field_8067, 8), this.ofItem(class_1802.field_8067, 9), this.ofItem(RDItems.SILVER_INGOT, 12),
                        this.ofItem(class_1802.field_8067, 7), this.ofEmpty(),
                        this.ofItem(class_1802.field_42693, 4), this.ofEmpty(), this.ofItem(RDItems.SPEED_FEATHER, 4)
                ),
                this.ofItem(RDItems.HAKUROKEN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.PAPILIO_PATTERN_FAN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8620, 1),
                List.of(
                        this.ofEmpty(), this.ofItem(class_1802.field_19055, 3), this.ofItem(class_1802.field_19054, 3),
                        this.ofItem(class_1802.field_8067, 9), this.ofItem(class_1802.field_19050, 3),
                        this.ofItem(class_1802.field_42693, 5), this.ofItem(class_1802.field_42688), this.ofEmpty()
                ),
                this.ofItem(RDItems.PAPILIO_PATTERN_FAN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.GUNGNIR, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8556),
                List.of(
                        this.ofItem(class_1802.field_8477, 2), this.ofItem(class_1802.field_8620, 5), this.ofItem(class_1802.field_8793, 2),
                        this.ofItem(class_1802.field_8067, 9), this.ofItem(class_1802.field_8620, 5),
                        this.ofItem(class_1802.field_49821, 5), this.ofItem(class_1802.field_8067, 6), this.ofEmpty()
                ),
                this.ofItem(RDItems.GUNGNIR)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.LEVATIN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_22026),
                List.of(
                        this.ofEmpty(), this.ofItem(class_1802.field_8695, 5), this.ofItem(class_1802.field_22020, 1),
                        this.ofItem(class_1802.field_8725, 3), this.ofItem(class_1802.field_8620, 5),
                        this.ofItem(class_1802.field_8894, 4), this.ofItem(class_1802.field_8067, 4), this.ofItem(class_1802.field_8713, 11)
                ),
                this.ofItem(RDItems.LEVATIN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.IBUKIHO, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_20417),
                List.of(
                        this.ofItem(class_1802.field_8695, 8), this.ofItem(class_1802.field_8695, 5), this.ofItem(class_1802.field_8479, 1),
                        this.ofItem(class_1802.field_8725, 8), this.ofItem(class_1802.field_8070, 8),
                        this.ofItem(class_1802.field_8477, 4), this.ofItem(class_1802.field_8894, 8), this.ofItem(class_1802.field_8711, 8)
                ),
                this.ofItem(RDItems.IBUKIHO)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.SWORD_OF_HISOU, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8845),
                List.of(
                        this.ofItem(class_1802.field_8695, 7), this.ofItem(class_1802.field_8477, 5), this.ofItem(class_1802.field_27022, 2),
                        this.ofItem(class_1802.field_8725, 6), this.ofItem(class_1802.field_8725, 6),
                        this.ofItem(class_1802.field_8894, 4), this.ofItem(RDIngredientItems.PEACH, 7), this.ofItem(class_1802.field_8279, 6)
                ),
                this.ofItem(RDItems.SWORD_OF_HISOU)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.MANPOZUCHI, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_49814),
                List.of(
                        this.ofItem(class_1802.field_8695, 2), this.ofItem(class_1802.field_8056, 1), this.ofItem(class_1802.field_8620, 2),
                        this.ofItem(class_1802.field_8725, 8), this.ofItem(class_1802.field_27022, 7),
                        this.ofItem(class_1802.field_8675, 18), this.ofItem(class_1802.field_8477, 4), this.ofItem(class_1802.field_8397, 18)
                ),
                this.ofItem(RDItems.MANPOZUCHI)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.NUE_TRIDENT, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8547),
                List.of(
                        this.ofEmpty(), this.ofEmpty(), this.ofItem(class_1802.field_8251),
                        this.ofItem(class_1802.field_8207), this.ofItem(class_1802.field_8429, 3),
                        this.ofItem(class_1802.field_22020), this.ofItem(class_1802.field_8583, 8), this.ofEmpty()
                ),
                this.ofItem(RDItems.NUE_TRIDENT)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.TREASURE_HUNTING_ROD, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8377),
                List.of(
                        this.ofItem(class_1802.field_8620, 5), this.ofItem(class_1802.field_8620, 6), this.ofItem(class_1802.field_8073, 9),
                        this.ofItem(class_1802.field_22020), this.ofItem(class_1802.field_8695, 10),
                        this.ofItem(class_1802.field_22020), this.ofItem(class_1802.field_8725, 8), this.ofItem(class_1802.field_8781, 1)
                ),
                this.ofItem(RDItems.TREASURE_HUNTING_ROD)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.TRUMPET_GUN, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8399),
                List.of(
                        this.ofItem(RDBlocks.POWER_BLOCK, 5), this.ofItem(class_1802.field_8711, 2), this.ofItem(class_1802.field_8073, 5),
                        this.ofItem(RDBlocks.POWER_BLOCK, 4), this.ofItem(class_1802.field_8695, 5),
                        this.ofItem(class_1802.field_20414), this.ofItem(class_1802.field_8675, 3), this.ofItem(class_1802.field_8894, 3)
                ),
                this.ofItem(RDItems.TRUMPET_GUN)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.DEATH_SCYTHE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_22026),
                List.of(
                        this.ofItem(class_1802.field_8067, 32), this.ofItem(class_1802.field_8067, 16), this.ofItem(class_1802.field_8067, 8),
                        this.ofItem(class_1802.field_22020, 1), this.ofItem(class_1802.field_8477, 5),
                        this.ofItem(class_1802.field_8511, 8), this.ofItem(class_1802.field_8606, 7)
                ),
                this.ofItem(RDItems.DEATH_SCYTHE)
        ));
        class_1799 kanjuKusuri = RDPotions.createStack(RDPotions.KANJU_KUSURI_POTION);
        this.gensokyoAltarRecipeFactory.register(ReverieDreams.id("kanju_kusuri"), new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8469),
                List.of(
                        this.ofItem(class_1802.field_8067, 20), this.ofItem(class_1802.field_8858, 20), this.ofItem(class_1802.field_8790, 5),
                        this.ofItem(class_1802.field_8183, 8), this.ofItem(class_1802.field_8463, 1),
                        this.ofItem(class_1802.field_8071, 2), this.ofItem(RDItems.SILVER_INGOT, 4), this.ofItem(class_1802.field_8634, 1)
                ),
                this.ofItem(kanjuKusuri)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.CURSED_DECOY_DOLl, new GensokyoAltarRecipe(
                        this.ofItem(class_1802.field_8694),
                        List.of(
                                this.ofItem(class_1802.field_8067, 6), this.ofItem(class_1802.field_8067, 6), this.ofItem(class_1802.field_8067, 6),
                                this.ofItem(class_1802.field_8067, 6), this.ofItem(class_1802.field_8067, 6),
                                this.ofItem(class_1802.field_8067, 6), this.ofItem(class_1802.field_8067, 6), this.ofItem(class_1802.field_8067, 6)
                        ),
                        this.ofItem(RDItems.CURSED_DECOY_DOLl)
                )
        );
        this.gensokyoAltarRecipeFactory.register(RDItems.VAISRAVANAS_PAGODA, new GensokyoAltarRecipe(
                this.ofItem(RDBlocks.POWER_BLOCK, 10),
                List.of(
                        this.ofItem(class_1802.field_20391, 15), this.ofItem(class_1802.field_8695, 20), this.ofItem(class_1802.field_20391, 15),
                        this.ofItem(class_1802.field_27022, 10), this.ofItem(class_1802.field_8183, 8),
                        this.ofItem(class_1802.field_20391, 15), this.ofItem(class_1802.field_8620, 20), this.ofItem(class_1802.field_20391, 15)
                ),
                this.ofItem(RDItems.VAISRAVANAS_PAGODA)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.TENGU_SHIELD, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8255, 1),
                List.of(
                        this.ofItem(class_1802.field_8153, 3), this.ofItem(class_1802.field_8153, 5), this.ofItem(class_1802.field_8153, 2),
                        this.ofItem(RDItems.SILVER_INGOT, 7), this.ofItem(RDItems.SILVER_INGOT, 7),
                        this.ofItem(class_1802.field_8477, 3), this.ofItem(class_1802.field_8620, 6), this.ofItem(class_1802.field_8606, 3)
                ),
                this.ofItem(RDItems.TENGU_SHIELD)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.TENGU_CAMERA, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8773, 1),
                List.of(
                        this.ofItem(class_1802.field_8601, 8), this.ofItem(class_1802.field_8781, 2), this.ofItem(class_1802.field_8601, 8),
                        this.ofItem(RDItems.SILVER_INGOT, 6), this.ofItem(class_1802.field_8620, 6),
                        this.ofItem(class_1802.field_8725, 23), this.ofItem(class_1802.field_8620, 6), this.ofItem(class_1802.field_8725, 13)
                ),
                this.ofItem(RDItems.TENGU_CAMERA)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.BAD_APPLE, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8463, 1),
                List.of(
                        this.ofItem(class_1802.field_8226, 2), this.ofItem(RDItems.POWER, 11), this.ofItem(class_1802.field_8226, 2),
                        this.ofItem(class_1802.field_8725, 6), this.ofItem(class_1802.field_8725, 6),
                        this.ofItem(class_1802.field_8226, 2), this.ofItem(RDItems.POINT, 8), this.ofItem(class_1802.field_8226, 2)
                ),
                this.ofItem(RDItems.BAD_APPLE)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.EXORCISM_PAPER, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8407, 6),
                List.of(
                        this.ofItem(class_1802.field_8606, 12), this.ofItem(class_1802.field_8511, 12), this.ofItem(class_1802.field_8264, 3),
                        this.ofItem(class_1802.field_8407, 6), this.ofItem(class_1802.field_8407, 8),
                        this.ofItem(class_1802.field_8407, 6), this.ofItem(class_1802.field_8407, 8), this.ofItem(class_1802.field_8725, 7)
                ),
                this.ofItem(RDItems.EXORCISM_PAPER, 4)
        ));
        this.gensokyoAltarRecipeFactory.register(RDItems.YUKA_FLOWER_UMBRELLA, new GensokyoAltarRecipe(
                this.ofItem(class_1802.field_8371),
                List.of(
                        this.ofItem(class_1802.field_17525, 16), this.ofItem(class_1802.field_22020), this.ofItem(class_1802.field_19044, 8),
                        this.ofItem(class_1802.field_17527, 16), this.ofItem(RDIngredientItems.UDUMBARA, 4),
                        this.ofItem(class_1802.field_8145, 1), this.ofItem(class_1802.field_8648, 2), this.ofItem(RDItems.POWER, 36)
                ),
                this.ofItem(RDItems.YUKA_FLOWER_UMBRELLA)
        ));
    }

    public void generateKitchenRecipe() {
        class_2960 cookingPot = KitchenRecipeType.KitchenType.COOKING_POT.toId();
        class_2960 grill = KitchenRecipeType.KitchenType.GRILL.toId();
        class_2960 cuttingBoard = KitchenRecipeType.KitchenType.CUTTING_BOARD.toId();
        class_2960 streamer = KitchenRecipeType.KitchenType.STREAMER.toId();
        class_2960 fryingPan = KitchenRecipeType.KitchenType.FRYING_PAN.toId();

        // 煮锅
        this.kitchenRecipeFactory.register(ReverieDreams.id("seafood_miso_soup"), new KitchenRecipe(
                cookingPot,
                List.of(
                        this.ofItem(class_1802.field_17532)
                ),
                this.ofItem(RDFoodItems.SEAFOOD_MISO_SOUP),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("tofu_miso"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.TOFU_MISO),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("strength_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.WILD_BOAR_MEAT, class_1802.field_17532),
                this.ofItem(RDFoodItems.STRENGTH_SOUP),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("game_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8567, class_1802.field_17518, RDIngredientItems.BLACK_PORK),
                this.ofItem(RDFoodItems.GAME_SOUP),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pork_rice"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8389),
                this.ofItem(RDFoodItems.PORK_RICE),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("beef_rice"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8046),
                this.ofItem(RDFoodItems.BEEF_RICE),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("snow_white"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8323, RDIngredientItems.HAGFISH, class_1802.field_17532),
                this.ofItem(RDFoodItems.SNOW_WHITE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("tofu_pot"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.TOFU_POT),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("zhaji"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_17532, RDIngredientItems.TOFU, RDIngredientItems.TROUT),
                this.ofItem(RDFoodItems.ZHAJI),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("grand_banquet"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.BLACK_PORK, RDIngredientItems.WAGYU_BEEF, RDIngredientItems.PUFF_YO_FRUIT),
                this.ofItem(RDFoodItems.GRAND_BANQUET),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("tonkotsu_ramen"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8389, class_1802.field_8803, class_1802.field_17532),
                this.ofItem(RDFoodItems.TONKOTSU_RAMEN),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("magma"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8046, RDIngredientItems.WAGYU_BEEF, RDIngredientItems.PUFF_YO_FRUIT, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.MAGMA),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("peach_blossom_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.PEACH, RDBlocks.MAGIC_ICE_BLOCK.method_8389(), RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.PEACH_BLOSSOM_SOUP),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("real_seafood_miso_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.TROUT),
                this.ofItem(RDFoodItems.REAL_SEAFOOD_MISO_SOUP),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cooking_tofu"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.COOKING_TOFU),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("ginko_and_radish_pork_rib_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.GINKGO, RDIngredientItems.WHITE_RADISH, class_1802.field_8389),
                this.ofItem(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("boiled_fish"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TROUT, RDIngredientItems.CHILI),
                this.ofItem(RDFoodItems.BOILED_FISH),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("dumpling"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.DUMPLING),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("glutinous_rice_balls"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.STICKY_RICE),
                this.ofItem(RDFoodItems.GLUTINOUS_RICE_BALLS),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pseudo_jiritama"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.VENISON, RDIngredientItems.TRUFFLE, RDIngredientItems.CICADA_SHELL),
                this.ofItem(RDFoodItems.PSEUDO_JIRITAMA),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("secret_mushroom_casserole"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TRUFFLE, class_1802.field_17516, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.SECRET_MUSHROOM_CASSEROLE),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("mushroom_girls_dance_stew"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_17516, RDIngredientItems.SHRIMP, RDIngredientItems.OCTOPUS, RDIngredientItems.CHILI),
                this.ofItem(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW),
                14.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("milky_mushroom_soup"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_17516, class_1802.field_8567, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.MILKY_MUSHROOM_SOUP),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("gensokyo_buddha_jumps_over_the_wall"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.WAGYU_BEEF, RDIngredientItems.SUPREME_TUNA, RDIngredientItems.BLACK_PORK, class_1802.field_8323, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL),
                18.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("screaming_oden"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.CHILI, RDIngredientItems.CHILI, class_1802.field_8046, RDIngredientItems.WHITE_RADISH, RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.SCREAMING_ODEN),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("lion_head"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8046),
                this.ofItem(RDFoodItems.LION_HEAD),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("luohan_vegetarian"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.UDUMBARA, RDIngredientItems.BAMBOO_SHOOTS, RDIngredientItems.TRUFFLE, RDIngredientItems.PINE_NUT, RDIngredientItems.LOTUS_NUTS),
                this.ofItem(RDFoodItems.LUOHAN_VEGETARIAN),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("taichi_bagua_fish_maw"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.SUPREME_TUNA, class_1802.field_17516, RDIngredientItems.WHITE_RADISH, class_1802.field_8803, RDIngredientItems.GINKGO),
                this.ofItem(RDFoodItems.TAICHI_BAGUA_FISH_MAW),
                14.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("tianshi_braised_chestnut_mushrooms"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.CHESTNUT, class_1802.field_17516, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("the_beauty_of_han_palace"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.HAGFISH, RDIngredientItems.TOFU, RDIngredientItems.CRAB, class_1802.field_8648, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bamboo_shoots_stewed_in_stone_pot"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8648, RDIngredientItems.BAMBOO_SHOOTS, class_1802.field_8046),
                this.ofItem(RDFoodItems.BAMBOO_SHOOTS_STEWED_IN_STONE_POT),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("plum_tea_rice"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.PLUM, class_1802.field_17532),
                this.ofItem(RDFoodItems.PLUM_TEA_RICE),
                4.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("green_fairy_mushroom"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TOON, class_1802.field_17516),
                this.ofItem(RDFoodItems.GREEN_FAIRY_MUSHROOM),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("poisonous_garden"), new KitchenRecipe(
                cookingPot,
                this.ofList(class_1802.field_8323, RDIngredientItems.PLUM, RDIngredientItems.HAGFISH, RDIngredientItems.GINKGO),
                this.ofItem(RDFoodItems.POISONOUS_GARDEN),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("beef_hot_pot"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.CHILI, RDIngredientItems.WHITE_RADISH, RDIngredientItems.TRUFFLE, class_1802.field_8046, RDIngredientItems.WAGYU_BEEF),
                this.ofItem(RDFoodItems.BEEF_HOT_POT),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("sea_urchin_shingen_pancake"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.SEA_URCHIN, RDIngredientItems.TUNA, RDIngredientItems.TREMELLA, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("heart_porridge_gruel"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.TREMELLA, RDIngredientItems.LOTUS_NUTS),
                this.ofItem(RDFoodItems.HEART_PORRIDGE_GRUEL),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("superme_seafood_noodles"), new KitchenRecipe(
                cookingPot,
                this.ofList(RDIngredientItems.SUPREME_TUNA, class_1802.field_17532, RDIngredientItems.OCTOPUS, RDIngredientItems.CRAB, RDIngredientItems.SHRIMP),
                this.ofItem(RDFoodItems.SUPERME_SEAFOOD_NOODLES),
                12.0
        ));
        // 烧烤架
        this.kitchenRecipeFactory.register(ReverieDreams.id("pork_and_trout_smoked"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.TROUT, class_1802.field_8389),
                this.ofItem(RDFoodItems.PORK_AND_TROUT_SMOKED),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("grilled_hagfish"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.HAGFISH),
                this.ofItem(RDFoodItems.GRILLED_HAGFISH),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("energy_string"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_8046, RDIngredientItems.ONION, class_1802.field_17518),
                this.ofItem(RDFoodItems.ENERGY_STRING),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("two_heavens_one_style"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.BLACK_PORK, RDIngredientItems.WILD_BOAR_MEAT),
                this.ofItem(RDFoodItems.TWO_HEAVENS_ONE_STYLE),
                18.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("roasted_mushrooms"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_17516),
                this.ofItem(RDFoodItems.ROASTED_MUSHROOMS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("honey_bbq_pork"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_8389, class_1802.field_20417),
                this.ofItem(RDFoodItems.HONEY_BBQ_PORK),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("phoenix"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.FLOUR, class_1802.field_20417, class_1802.field_8567, RDIngredientItems.ONION, RDIngredientItems.WHITE_RADISH),
                this.ofItem(RDFoodItems.PHOENIX),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("horai_dama_no_rda"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_8648, class_1802.field_8389, RDIngredientItems.SALMON, RDIngredientItems.WAGYU_BEEF, RDIngredientItems.VENISON),
                this.ofItem(RDFoodItems.HORAI_DAMA_NO_EDA),
                13.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("all_meat_feast"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.WILD_BOAR_MEAT, RDIngredientItems.VENISON, RDIngredientItems.BLACK_PORK, RDIngredientItems.WAGYU_BEEF),
                this.ofItem(RDFoodItems.ALL_MEAT_FEAST),
                14.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("one_hit_kill"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.WILD_BOAR_MEAT, RDIngredientItems.VENISON, RDIngredientItems.ONION),
                this.ofItem(RDFoodItems.ONE_HIT_KILL),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("baked_sweet_potatoes"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.SWEET_POTATO),
                this.ofItem(RDFoodItems.BAKED_SWEET_POTATOES),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("biscay_biscuits"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.FLOUR, RDIngredientItems.CHEESE),
                this.ofItem(RDFoodItems.BISCAY_BISCUITS),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pirate_bacon"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_8046, RDIngredientItems.BLACK_SALT, RDIngredientItems.CHILI, class_1802.field_20417),
                this.ofItem(RDFoodItems.PIRATE_BACON),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fantasy_is_all_the_rage"), new KitchenRecipe(
                grill,
                this.ofList(RDIngredientItems.ONION, RDIngredientItems.WILD_BOAR_MEAT, class_1802.field_8046, RDIngredientItems.TRUFFLE, RDIngredientItems.TOMATO),
                this.ofItem(RDFoodItems.FANTASY_IS_ALL_THE_RAGE),
                18.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cat_kululi"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_8116, RDIngredientItems.FLOUR, class_1802.field_8803),
                this.ofItem(RDFoodItems.CAT_KULULI),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cat_pizza"), new KitchenRecipe(
                grill,
                this.ofList(class_1802.field_17516, RDIngredientItems.ONION, RDIngredientItems.BROCCOLI, RDIngredientItems.WILD_BOAR_MEAT),
                this.ofItem(RDFoodItems.CAT_PIZZA),
                10.0
        ));
        // 料理台
        this.kitchenRecipeFactory.register(ReverieDreams.id("rice_ball"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_17532),
                this.ofItem(RDFoodItems.RICE_BALL),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("grilled_pork_rice_balls"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8389),
                this.ofItem(RDFoodItems.GRILLED_PORK_RICE_BALLS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("warm_rice_ball"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.ONION, RDIngredientItems.TROUT),
                this.ofItem(RDFoodItems.WARM_RICE_BALL),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("failing_sakura_snow"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.SUPREME_TUNA),
                this.ofItem(RDFoodItems.FAILING_SAKURA_SNOW),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cold_tofu"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.WHITE_RADISH, RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.COLD_TOFU),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("vegetable_special"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8567, RDIngredientItems.ONION, class_1802.field_17518),
                this.ofItem(RDFoodItems.VEGETABLE_SPECIAL),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("sashimi_platter"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.TUNA),
                this.ofItem(RDFoodItems.SASHIMI_PLATTER),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("secret_dried_fish"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.TROUT),
                this.ofItem(RDFoodItems.SECRET_DRIED_FISH),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cold_dish_carving"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.WHITE_RADISH),
                this.ofItem(RDFoodItems.COLD_DISH_CARVING),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("arctic_sweet_shrimp_and_peach_salad"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.PEACH, RDBlocks.MAGIC_ICE_BLOCK.method_8389(), RDIngredientItems.SHRIMP),
                this.ofItem(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("moonlight_dumplings"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.MOONFLOWER, RDIngredientItems.STICKY_RICE),
                this.ofItem(RDFoodItems.MOONLIGHT_DUMPLINGS),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("mochi"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.STICKY_RICE),
                this.ofItem(RDFoodItems.MOCHI),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("white_peach_eight_bridge"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.STICKY_RICE, RDIngredientItems.PEACH),
                this.ofItem(RDFoodItems.WHITE_PEACH_EIGHT_BRIDGE),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("moon_lover"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.BUTTER, RDIngredientItems.FLOUR, class_1802.field_8803, RDIngredientItems.MOONFLOWER),
                this.ofItem(RDFoodItems.MOON_LOVERS),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("flowing_water_noodles"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.FLOUR, class_1802.field_8648),
                this.ofItem(RDFoodItems.FLOWING_WATER_NOODLES),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("maoyu_tricolor_ice_cream"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.DEW, RDIngredientItems.TOFU, class_1802.field_20417, class_1802.field_8803),
                this.ofItem(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("maoyu_lava_tofu"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.TOFU, RDIngredientItems.CHILI, class_1802.field_8046, RDIngredientItems.ONION),
                this.ofItem(RDFoodItems.MAOYU_LAVA_TOFU),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("scarlet_devils_cake"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.DEW, class_1802.field_17518, class_1802.field_8567, class_1802.field_20417),
                this.ofItem(RDFoodItems.SCARLET_DEVILS_CAKE),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("unconscious_monster_mousse"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.TOFU, RDIngredientItems.BUTTER, class_1802.field_20417, RDIngredientItems.ONION),
                this.ofItem(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pickled_cucumbers"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.CUCUMBER, RDIngredientItems.BLACK_SALT),
                this.ofItem(RDFoodItems.PICKLED_CUCUMBERS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("sea_urchin_sashimi"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.SEA_URCHIN, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.SEA_URCHIN_SASHIMI),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("nigiri_sushi"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.TUNA),
                this.ofItem(RDFoodItems.NIGIRI_SUSHI),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("gloomy_fruit_pie"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.LEMON, RDIngredientItems.GRAPE, RDIngredientItems.CHEESE),
                this.ofItem(RDFoodItems.GLOOMY_FRUIT_PIE),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("crisp_cyclone"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.FLOUR, class_1802.field_20417, RDIngredientItems.CICADA_SHELL),
                this.ofItem(RDFoodItems.CRISP_CYCLONE),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("oedo_boat_festival"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.TUNA, RDIngredientItems.SUPREME_TUNA, RDIngredientItems.TROUT, RDBlocks.MAGIC_ICE_BLOCK.method_8389()),
                this.ofItem(RDFoodItems.OEDO_BOAT_FESTIVAL),
                24.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cat_food"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.TROUT, RDIngredientItems.DEW, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.CAT_FOOD),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("skinny_horse_dumpling"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.STICKY_RICE, RDIngredientItems.STICKY_RICE),
                this.ofItem(RDFoodItems.SKINNY_HORSE_DUMPLING),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("gensokyo_star_lotus_ship"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_17518, RDIngredientItems.LOTUS_NUTS, RDIngredientItems.TUNA, RDIngredientItems.TWIN_LOTUS, RDIngredientItems.MOONFLOWER),
                this.ofItem(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP),
                13.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("candied_chestnuts"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_20417, RDIngredientItems.CHESTNUT),
                this.ofItem(RDFoodItems.CANDIED_CHESTNUTS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("reversing_the_world"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8648, RDIngredientItems.FLOWERS, RDIngredientItems.PLUM, RDIngredientItems.BLACK_PORK, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.REVERSING_THE_WORLD),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("red_bean_daifuku"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.RED_BEANS, RDIngredientItems.STICKY_RICE),
                this.ofItem(RDFoodItems.RED_BEAN_DAIFUKU),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bamboo_tube_roasted_drunken_shrimp"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8648, RDIngredientItems.SHRIMP, RDIngredientItems.BROCCOLI),
                this.ofItem(RDFoodItems.BAMBOO_TUBE_ROASTED_DRUNKEN_SHRIMP),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cats_playing_in_water"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.PEACH, RDIngredientItems.FICUS_MICROCARPA, RDIngredientItems.CREAM, RDIngredientItems.FLOUR, class_1802.field_8116),
                this.ofItem(RDFoodItems.CATS_PLAYING_IN_WATER),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("moonlight_over_lotus_pond"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(RDIngredientItems.GRAPE, RDIngredientItems.FICUS_MICROCARPA, RDIngredientItems.CREAM, RDIngredientItems.TREMELLA),
                this.ofItem(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("longyin_peach"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8116, RDIngredientItems.PEACH, RDIngredientItems.PEACH, RDIngredientItems.PEACH, RDIngredientItems.PEACH),
                this.ofItem(RDFoodItems.LONGYIN_PEACH),
                18.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("molecular_egg"), new KitchenRecipe(
                cuttingBoard,
                this.ofList(class_1802.field_8116, class_1802.field_17518, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.MOLECULAR_EGG),
                18.0
        ));
        // 蒸锅
        this.kitchenRecipeFactory.register(ReverieDreams.id("dew_boiled_eggs"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.DEW, class_1802.field_8803),
                this.ofItem(RDFoodItems.DEW_BOILED_EGGS),
                3.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("udumbara_cake"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.UDUMBARA, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.UDUMBARA_CAKE),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bear_paw"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.BLACK_PORK, RDIngredientItems.BAMBOO_SHOOTS, class_1802.field_8323),
                this.ofItem(RDFoodItems.BEAR_PAW),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("poetry_and_ginkgo"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.GINKGO, class_1802.field_20417),
                this.ofItem(RDFoodItems.POETRY_AND_GINKGO),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("risotto"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.ONION, class_1802.field_17516, RDIngredientItems.BAMBOO_SHOOTS, RDIngredientItems.BUTTER),
                this.ofItem(RDFoodItems.RISOTTO),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("scones"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.BUTTER, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.SCONES),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cream_stew"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_17516, RDIngredientItems.ONION, RDIngredientItems.BUTTER),
                this.ofItem(RDFoodItems.CREAM_STEW),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("taketorihime"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_8648, RDIngredientItems.BAMBOO_SHOOTS, RDIngredientItems.TRUFFLE, RDIngredientItems.GINKGO, RDIngredientItems.BLACK_PORK),
                this.ofItem(RDFoodItems.TAKETORIHIME),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pig_deer_butterfly"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.WILD_BOAR_MEAT, RDIngredientItems.VENISON, RDIngredientItems.MOONFLOWER),
                this.ofItem(RDFoodItems.PIG_DEER_BUTTERFLY),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bamboo_steamed_egg"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_8648, class_1802.field_8803, class_1802.field_17532, class_1802.field_17516),
                this.ofItem(RDFoodItems.BAMBOO_STEAMED_EGG),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("moon_cake"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.MOONFLOWER, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.MOON_CAKE),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("ordinary_small_cake"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_8803, RDIngredientItems.GRAPE, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.ORDINARY_SMALL_CAKE),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("seven_colored_yokan"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_17532, RDIngredientItems.GRAPE, RDIngredientItems.DEW, RDIngredientItems.UDUMBARA),
                this.ofItem(RDFoodItems.SEVEN_COLORED_YOKAN),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pumpkin_shrimp_cake"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_17518, RDIngredientItems.SHRIMP, RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.PUMPKIN_SHRIMP_CAKE),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("depressed_cheese_sticks"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.CHEESE, RDIngredientItems.GINKGO, RDIngredientItems.GINKGO),
                this.ofItem(RDFoodItems.DEPRESSED_CHEESE_STICKS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("looking_up_at_the_ceiling_fruit_pie"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.TROUT, RDIngredientItems.FLOUR, RDIngredientItems.PEACH),
                this.ofItem(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("beetle_steamed_cake"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.FLOUR, RDIngredientItems.BLACK_PORK, class_1802.field_20417, RDIngredientItems.CICADA_SHELL),
                this.ofItem(RDFoodItems.BEETLE_STEAMED_CAKE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("sakura_pudding"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_20417, RDIngredientItems.PEACH),
                this.ofItem(RDFoodItems.SAKURA_PUDDING),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("refreshing_pudding"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.GRAPE, RDIngredientItems.GRAPE, RDIngredientItems.LEMON),
                this.ofItem(RDFoodItems.REFRESHING_PUDDING),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("burnt_pudding"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.GRAPE, class_1802.field_20417, RDIngredientItems.LEMON, RDIngredientItems.LEMON),
                this.ofItem(RDFoodItems.BURNT_PUDDING),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fish_leaps_over_dragon_gate"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.SUPREME_TUNA, RDIngredientItems.VENISON, class_1802.field_20417, RDIngredientItems.MOONFLOWER, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fright_adventure"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_17516, RDIngredientItems.UDUMBARA, class_1802.field_20417, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.FRIGHT_ADVENTURE),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("holy_white_lotus_seed_cake"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.GINKGO, RDIngredientItems.LOTUS_NUTS, RDIngredientItems.FLOUR, RDIngredientItems.BUTTER),
                this.ofItem(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pine_nut_cake"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.STICKY_RICE, RDIngredientItems.PINE_NUT),
                this.ofItem(RDFoodItems.PINE_NUT_CAKE),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("shiraga_sadamatsu"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.VENISON, RDIngredientItems.GINKGO, RDIngredientItems.PINE_NUT),
                this.ofItem(RDFoodItems.SHIRAGA_SADAMATSU),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("lotus_fish_rice_bowl"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.SUPREME_TUNA, RDIngredientItems.TWIN_LOTUS, RDIngredientItems.LOTUS_NUTS, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.LOTUS_FISH_RICE_BOWL),
                11.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bamboo_tube_steamed_pork"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.BAMBOO_SHOOTS, RDIngredientItems.DEW, RDIngredientItems.BLACK_PORK),
                this.ofItem(RDFoodItems.BAMBOO_TUBE_STEAMED_PORK),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("green_bamboo_welcomes_spring"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.CUCUMBER, class_1802.field_8803, RDIngredientItems.WHITE_RADISH, RDIngredientItems.VENISON, RDIngredientItems.MOONFLOWER),
                this.ofItem(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING),
                14.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("steamed_egg_with_sea_urchin"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.SEA_URCHIN, class_1802.field_8803),
                this.ofItem(RDFoodItems.STEAMED_EGG_WITH_SEA_URCHIN),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("flowers_birds_wind_and_moon"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.FLOWERS, RDIngredientItems.MOONFLOWER, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("the_dream"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.FLOWERS, RDIngredientItems.UDUMBARA, RDIngredientItems.MOONFLOWER, RDIngredientItems.DEW, RDIngredientItems.CREAM),
                this.ofItem(RDFoodItems.THE_DREAM),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("a_little_sweet_poison"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.UDUMBARA, RDIngredientItems.CREAM, RDIngredientItems.GRAPE, RDIngredientItems.GINKGO),
                this.ofItem(RDFoodItems.A_LITTLE_SWEET_POISON),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("rapunzel"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_17518, RDIngredientItems.SHRIMP),
                this.ofItem(RDFoodItems.RAPUNZEL),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("mad_hatter_tea_party"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_8116, RDIngredientItems.CREAM, RDIngredientItems.FLOUR, class_1802.field_8506, RDIngredientItems.BROCCOLI),
                this.ofItem(RDFoodItems.MAD_HATTER_TEA_PARTY),
                15.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("peach_blossom_glaze_roll"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.PEACH, RDIngredientItems.RED_BEANS, RDIngredientItems.FICUS_MICROCARPA),
                this.ofItem(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("the_source_of_life"), new KitchenRecipe(
                streamer,
                this.ofList(class_1802.field_8116, RDIngredientItems.TREMELLA, class_1802.field_17518, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.THE_SOURCE_OF_LIFE),
                13.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("the_mars"), new KitchenRecipe(
                streamer,
                this.ofList(RDIngredientItems.FICUS_MICROCARPA, RDIngredientItems.GRAPE, RDIngredientItems.CRAB, RDIngredientItems.DEW),
                this.ofItem(RDFoodItems.THE_MARS),
                24.0
        ));
        // 炒锅
        this.kitchenRecipeFactory.register(ReverieDreams.id("fried_pork_shreds"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_8389),
                this.ofItem(RDFoodItems.FRIED_PORK_SHREDS),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("braised_eel"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.ONION, RDIngredientItems.HAGFISH),
                this.ofItem(RDFoodItems.BRAISED_EEL),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("potato_croquettes"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.HAGFISH),
                this.ofItem(RDFoodItems.FRIED_HAGFISH),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("deep_fried_cicada_shells"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TOFU, RDIngredientItems.CICADA_SHELL),
                this.ofItem(RDFoodItems.DEEP_FRIED_CICADA_SHELLS),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fried_pork_cutlet"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_8389),
                this.ofItem(RDFoodItems.FRIED_PORK_CUTLET),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("butter_steak"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.WAGYU_BEEF),
                this.ofItem(RDFoodItems.BUTTER_STEAK),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("beef_wellington"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.WAGYU_BEEF, RDIngredientItems.FLOUR, class_1802.field_8803, RDIngredientItems.BUTTER, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.BEEF_WELLINGTON),
                14.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("eggs_benedict"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_8803, RDIngredientItems.BAMBOO_SHOOTS, RDIngredientItems.BUTTER, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.EGGS_BENEDICT),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("hot_waffles"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_20417, RDIngredientItems.FLOUR, class_1802.field_8803),
                this.ofItem(RDFoodItems.HOT_WAFFLES),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pan_fried_salmon"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.BAMBOO_SHOOTS),
                this.ofItem(RDFoodItems.PAN_FRIED_SALMON),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("bamboo_shoots_fried_meat"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.BAMBOO_SHOOTS, class_1802.field_8389),
                this.ofItem(RDFoodItems.BAMBOO_SHOOTS_FRIED_MEAT),
                10.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("stinky_tofu"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TOFU, RDIngredientItems.CHILI),
                this.ofItem(RDFoodItems.STINKY_TOFU),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("colorful_jade_fried_buns"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_17516, RDIngredientItems.BLACK_PORK),
                this.ofItem(RDFoodItems.COLORFUL_JADE_FRIED_BUNS),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("mapo_tofu"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TOFU, class_1802.field_8389, RDIngredientItems.CHILI),
                this.ofItem(RDFoodItems.MAPO_TOFU),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fried_shrimp_tempura"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.SHRIMP, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.FRIED_SHRIMP_TEMPURA),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("golden_crispy_fish_cake"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TROUT, RDIngredientItems.FLOUR, class_1802.field_20417),
                this.ofItem(RDFoodItems.GOLDEN_CRISPY_FISH_CAKE),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("baked_crab_with_cream"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.CREAM, RDIngredientItems.CRAB),
                this.ofItem(RDFoodItems.BAKED_CRAB_WITH_CREAM),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("okonomiyaki"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.FLOUR, class_1802.field_8803, RDIngredientItems.WHITE_RADISH),
                this.ofItem(RDFoodItems.OKONOMIYAKI),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("takoyaki"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.FLOUR, class_1802.field_17532, RDIngredientItems.OCTOPUS),
                this.ofItem(RDFoodItems.TAKOYAKI),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("mushroom_meat_slices"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_17516, class_1802.field_8389),
                this.ofItem(RDFoodItems.MUSHROOM_MEAT_SLICES),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("giant_tamagoyaki"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.FLOUR, RDIngredientItems.FLOUR, class_1802.field_8803, class_1802.field_8803),
                this.ofItem(RDFoodItems.GIANT_TAMAGOYAKI),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("salmon_tempura"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.SALMON, RDIngredientItems.BUTTER, class_1802.field_8803, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.SALMON_TEMPURA),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("cheese_egg"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_8803, RDIngredientItems.CHEESE),
                this.ofItem(RDFoodItems.CHEESE_EGG),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("hell_thrill_warning"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.CHILI, RDIngredientItems.CHILI, RDIngredientItems.CHILI, RDIngredientItems.CHEESE, class_1802.field_8046),
                this.ofItem(RDFoodItems.HELL_THRILL_WARNING),
                12.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("yunshan_cotton_candy"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_20417, RDIngredientItems.PEACH),
                this.ofItem(RDFoodItems.YUNSHAN_COTTON_CANDY),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("candied_sweet_potato"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.SWEET_POTATO, class_1802.field_20417),
                this.ofItem(RDFoodItems.CANDIED_SWEET_POTATO),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("pan_fried_mushroom_meat_roll"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_8389, class_1802.field_17516, RDIngredientItems.TRUFFLE),
                this.ofItem(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL),
                9.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("assorted_tempura"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.BLACK_PORK, RDIngredientItems.TRUFFLE, RDIngredientItems.HAGFISH, RDIngredientItems.MOONFLOWER),
                this.ofItem(RDFoodItems.ASSORTED_TEMPURA),
                7.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("fried_tomato_strips"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TOMATO, class_1802.field_8567),
                this.ofItem(RDFoodItems.FRIED_TOMATO_STRIPS),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("braised_pork_with_peach"), new KitchenRecipe(
                fryingPan,
                this.ofList(class_1802.field_20417, RDIngredientItems.PEACH, class_1802.field_8389),
                this.ofItem(RDFoodItems.BRAISED_PORK_WITH_PEACH),
                8.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("dorayaki"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.RED_BEANS, class_1802.field_8803, RDIngredientItems.FLOUR),
                this.ofItem(RDFoodItems.DORAYAKI),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("toon_pancakes"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.TWIN_LOTUS, class_1802.field_8803),
                this.ofItem(RDFoodItems.TOON_PANCAKES),
                6.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("eel_egg_donburi"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.HAGFISH, class_1802.field_8803),
                this.ofItem(RDFoodItems.EEL_EGG_DONBURI),
                5.0
        ));
        this.kitchenRecipeFactory.register(ReverieDreams.id("hula_soup"), new KitchenRecipe(
                fryingPan,
                this.ofList(RDIngredientItems.CHILI, class_1802.field_8046, RDIngredientItems.TOFU),
                this.ofItem(RDFoodItems.HULA_SOUP),
                8.0
        ));
    }

    public void generateDanmakuRecipe() {
        Stream<DanmakuType> stream = RegistryHandlers.DANMAKU_TYPE.method_10220();
        stream.forEach(value -> {
            class_2960 key = RegistryHandlers.DANMAKU_TYPE.method_10221(value);
            if (!value.isDeleteFromList()) {
                for (class_3545<class_1792, class_1799> pair : value.getColorPairs()) {
                    class_1792 dye = pair.method_15442();
                    class_1799 result = pair.method_15441();
                    class_1792 item = result.method_7909();
                    class_2960 itemId = class_7923.field_41178.method_10221(item);
                    class_2960 dyeId = class_7923.field_41178.method_10221(dye);
                    class_2960 registryKey = class_2960.method_60655(itemId.method_12836(), itemId.method_12832() + "_dye_" + dyeId.method_12832());
                    DanmakuRecipe recipe = new DanmakuRecipe(
                            new ItemStackWrapper(new class_1799(dye, 4)),
                            new ItemStackWrapper(new class_1799(RDItems.DANMAKU_CORE, 4)),
                            new ItemStackWrapper(new class_1799(RDItems.POWER, 35)),
                            new ItemStackWrapper(new class_1799(RDItems.POINT, 35)),
                            new ItemStackWrapper(value.toShape().getItemStack()),
                            new ItemStackWrapper(result)
                    );
                    this.danmakuRecipeFactory.register(registryKey, recipe);
                }
            }
        });
    }

    @Override
    public String method_10321() {
        return "Recipe Types";
    }
}
