package cc.thonly.reverie_dreams.datagen;

import autovalue.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuTrajectory;
import cc.thonly.reverie_dreams.data.npc.NPCRole;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7417;
import net.minecraft.class_9793;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

@CanIgnoreReturnValue
@Getter
@Slf4j
public class TranslationExporter implements ITranslationExporterBuilder {
    public static final Map<class_1299<?>, class_1792> MAPPER = RDEntityTypes.SPAWN_EGG_BIND;
    private final class_7225.class_7874 wrapperLookup;
    private final FabricLanguageProvider.TranslationBuilder translationBuilder;

    public TranslationExporter(class_7225.class_7874 wrapperLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.wrapperLookup = wrapperLookup;
        this.translationBuilder = translationBuilder;
    }

    public TranslationExporter add(String translationKey, String value) {
        this.translationBuilder.add(translationKey, value);
        return this;
    }

    public TranslationExporter add(class_1792 item, String value) {
        this.translationBuilder.add(item, value);
        return this;
    }

    public TranslationExporter add(class_2248 block, String value) {
        this.translationBuilder.add(block, value);
        return this;
    }

    public TranslationExporter add(class_5321<class_1761> registryKey, String value) {
        this.translationBuilder.add(registryKey, value);
        return this;
    }

    public TranslationExporter add(class_1761 itemGroup, String value) {
        class_2561 text = itemGroup.method_7737();
        class_7417 content = text.method_10851();
        if (content instanceof class_2588 translatableTextContent) {
            this.translationBuilder.add(translatableTextContent.method_11022(), value);
        } else {
            class_7417.class_8823<?> type = content.method_54163();
            String string = type.method_15434();
            log.error("Can't get translatable text content in item group {}", string);
        }
        return this;
    }

    public TranslationExporter add(class_1299<?> entityType, String value) {
        this.translationBuilder.add(entityType, value);
        return this;
    }

    public TranslationExporter addEnchantment(class_5321<class_1887> enchantment, String value) {
        this.translationBuilder.addEnchantment(enchantment, value);
        return this;
    }

    public TranslationExporter add(class_6880<class_1320> entityAttribute, String value) {
        this.translationBuilder.add(entityAttribute, value);
        return this;
    }

    public TranslationExporter add(class_3448<?> statType, String value) {
        this.translationBuilder.add(statType, value);
        return this;
    }

    public TranslationExporter add(class_1291 statusEffect, String value) {
        this.translationBuilder.add(statusEffect, value);
        return this;
    }

    public TranslationExporter add(class_2960 identifier, String value) {
        this.translationBuilder.add(identifier, value);
        return this;
    }

    public TranslationExporter add(class_6862<?> tagKey, String value) {
        this.translationBuilder.add(tagKey, value);
        return this;
    }

    public TranslationExporter add(Path existingLanguageFile) throws IOException {
        this.translationBuilder.add(existingLanguageFile);
        return this;
    }

    public TranslationExporter add(class_1299<?> entityType, String name, String spawnEggName) {
        this.add(entityType, name);
        class_1792 item = MAPPER.get(entityType);
        if (item != null) {
            this.add(item, spawnEggName);
        }
        return this;
    }

    public TranslationExporter add(class_2561 mutableText, String value) {
        class_7417 content = mutableText.method_10851();
        if (content instanceof class_2588 translatableText) {
            String key = translatableText.method_11022();
            this.add(key, value);
        } else {
            log.error("Can't parse Translatable Text Content {}", mutableText);
        }
        return this;
    }

    public TranslationExporter generateDanmakuType(DanmakuTrajectory trajectory, String value) {
        this.translationBuilder.add(RegistryHandlers.DANMAKU_TRAJECTORY.method_10221(trajectory).method_42094(), value);
        return this;
    }

    public TranslationExporter generateJukeBox(class_5321<class_9793> key, String value) {
        this.translationBuilder.add(this.getSoundEventSubtitle(key), value);
        this.translationBuilder.add(this.getJukeBoxSongDisc(key), value);
        return this;
    }

    public TranslationExporter generateStatusEffect(class_6880<class_1291> registryEntry, String value) {
        this.translationBuilder.add(getStatusEffect(registryEntry), value);
        return this;
    }

    public TranslationExporter generatePotion(
            class_1842 registryEntry,
            String potion,
            String splash,
            String lingering
    ) {
        this.translationBuilder.add(getPotion(registryEntry), potion);
        this.translationBuilder.add(getSplashPotion(registryEntry), splash);
        this.translationBuilder.add(getLingeringPotion(registryEntry), lingering);
        this.translationBuilder.add(getPotionArrow(registryEntry), potion);
        return this;
    }

    public TranslationExporter generateSoundEventSubtitle(class_3414 soundEvent, String value) {
        this.translationBuilder.add(getSoundEventSubtitle(soundEvent), value);
        return this;
    }

    public TranslationExporter addRoleEntity(NPCRole role, String value, String spawnEggValue) {
        class_1299<?> entityType = role.getEntityType();
        class_1792 egg = role.getEgg();
        String item_value = value + spawnEggValue;
        this.add(entityType, value);
        this.add(egg, item_value);
        return this;
    }

    public String getStatusEffect(class_6880<class_1291> registryEntry) {
        StringBuilder sb = new StringBuilder();
        String idAsString = registryEntry.method_55840();
        idAsString = idAsString.replaceAll(":", ".");
        idAsString = idAsString.replaceAll("/", ".");
        sb = sb.append("effect.");
        sb = sb.append(idAsString);
        return sb.toString();
    }

    public String getPotion(class_1842 registryEntry) {
        StringBuilder sb = new StringBuilder();
        String idAsString = registryEntry.method_63990();
        idAsString = idAsString.replaceAll(":", ".");
        idAsString = idAsString.replaceAll("/", ".");
        sb = sb.append("item.minecraft.potion.effect.");
        sb = sb.append(idAsString);
        return sb.toString();
    }

    public String getSplashPotion(class_1842 registryEntry) {
        StringBuilder sb = new StringBuilder();
        String idAsString = registryEntry.method_63990();
        idAsString = idAsString.replaceAll(":", ".");
        idAsString = idAsString.replaceAll("/", ".");
        sb.append("item.minecraft.splash_potion.effect.");
        sb.append(idAsString);
        return sb.toString();
    }

    public String getLingeringPotion(class_1842 registryEntry) {
        StringBuilder sb = new StringBuilder();
        String idAsString = registryEntry.method_63990();
        idAsString = idAsString.replaceAll(":", ".");
        idAsString = idAsString.replaceAll("/", ".");
        sb.append("item.minecraft.lingering_potion.effect.");
        sb.append(idAsString);
        return sb.toString();
    }

    public String getPotionArrow(class_1842 registryEntry) {
        StringBuilder sb = new StringBuilder();
        String idAsString = registryEntry.method_63990();
        idAsString = idAsString.replaceAll(":", ".");
        idAsString = idAsString.replaceAll("/", ".");
        sb.append("item.minecraft.tipped_arrow.effect.");
        sb.append(idAsString);
        return sb.toString();
    }

    public String getSoundEventSubtitle(class_3414 soundEvent) {
        class_2960 id = soundEvent.comp_3319();
        return id.method_42093("sound");
    }

    public String getSoundEventSubtitle(class_5321<class_9793> registryKey) {
        class_2960 id = registryKey.method_29177();
        return id.method_42093("sound");
    }

    public String getJukeBoxSongDisc(class_5321<class_9793> registryKey) {
        class_2960 key = registryKey.method_29177();
        String namespace = key.method_12836();
        String path = key.method_12832().replaceAll("/", ".");
        return key.method_42093("jukebox_song");
    }

}
