package cc.thonly.reverie_dreams.datagen.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;
import net.minecraft.class_2960;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Accessors(chain = true)
@Setter
@Getter
public class SoundEventBuilder {
    private final class_2960 key;
    private String subtitle;
    private List<Object> sounds = new LinkedList<>();

    public SoundEventBuilder(class_2960 key) {
        this.key = key;
    }

    public SoundEventBuilder setSubtitle(class_2960 key) {
        this.subtitle = key.method_42093("sound");
        return this;
    }

    public SoundEventBuilder addSounds(String sound) {
        this.sounds.add(sound);
        return this;
    }

    public SoundEventBuilder addSounds(class_2960 key) {
        this.sounds.add(key.toString());
        return this;
    }

    public SoundEventBuilder addSoundsByName(String name) {
        Map<String, String> map = Map.of("name", name);
        this.sounds.add(map);
        return this;
    }

    public SoundEventBuilder addSoundsByName(class_2960 key) {
        return addSoundsByName(key.toString());
    }

    public SoundEventBuilder addSoundsByName(String name, boolean stream) {
        Map<String, Object> map = new HashMap<>();
        map.put("name", name);
        map.put("stream", stream);
        this.sounds.add(map);
        return this;
    }

    public SoundEventBuilder addSoundsByName(class_2960 key, boolean stream) {
        return addSoundsByName(key.toString(), stream);
    }

    public JsonElement toJsonElement() {
        JsonObject jsonObject = new JsonObject();

        if (this.subtitle != null && !this.subtitle.isEmpty()) {
            jsonObject.addProperty("subtitle", this.subtitle);
        }

        JsonArray soundsArray = new JsonArray();

        for (Object sound : this.sounds) {
            if (sound instanceof String) {
                soundsArray.add((String) sound);
            } else if (sound instanceof Map) {
                JsonObject soundObject = new JsonObject();
                Map<String, String> soundMap = (Map<String, String>) sound;
                soundMap.forEach(soundObject::addProperty);
                soundsArray.add(soundObject);
            }
        }

        jsonObject.add("sounds", soundsArray);

        return jsonObject;
    }
}
