package cc.thonly.reverie_dreams.datagen.tag;

import cc.thonly.reverie_dreams.block.BlockTypeGroup;
import cc.thonly.reverie_dreams.block.creator.WoodCreator;
import cc.thonly.reverie_dreams.data.FumoType;
import cc.thonly.reverie_dreams.registry.content.FumoTypes;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.registry.tag.RDBlockTags;
import lombok.AccessLevel;
import lombok.Getter;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_11389;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Getter(AccessLevel.PRIVATE)
public class BlockTagProvider extends FabricTagProvider.BlockTagProvider {
    public BlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        class_11389<class_2248, class_2248> fumo = valueLookupBuilder(RDBlockTags.FUMO);
        class_11389<class_2248, class_2248> empty = valueLookupBuilder(RDBlockTags.EMPTY);
        class_11389<class_2248, class_2248> sliver = valueLookupBuilder(RDBlockTags.SILVER);
        class_11389<class_2248, class_2248> minTools = valueLookupBuilder(RDBlockTags.MIN_TOOL);
        class_11389<class_2248, class_2248> axeMineables = valueLookupBuilder(class_3481.field_33713);
        class_11389<class_2248, class_2248> hoeMineables = valueLookupBuilder(class_3481.field_33714);
        class_11389<class_2248, class_2248> pickaxeMineables = valueLookupBuilder(class_3481.field_33715);
        class_11389<class_2248, class_2248> shovelMineables = valueLookupBuilder(class_3481.field_33716);
        class_11389<class_2248, class_2248> ores = valueLookupBuilder(ConventionalBlockTags.ORES);
        class_11389<class_2248, class_2248> villagerJobSites = valueLookupBuilder(ConventionalBlockTags.VILLAGER_JOB_SITES);
//        ProvidedTagBuilder<Block, Block> villagerJobSites = valueLookupBuilder(PointOfInterestTypeTags.ACQUIRABLE_JOB_SITE);

        class_11389<class_2248, class_2248> logs = valueLookupBuilder(class_3481.field_15475);
        class_11389<class_2248, class_2248> planks = valueLookupBuilder(class_3481.field_15471);
        for (WoodCreator instance : WoodCreator.INSTANCES) {
            logs.method_71554(instance.log());
            planks.method_71554(instance.planks());
        }
        logs.method_71554(RDWoodBlocks.BLESSED_SPIRITUAL_LOG);

        for (FumoType instance : FumoTypes.getView()) {
            fumo.method_71554(instance.block());
        }

        Map<class_6862<class_2248>, Collection<? extends class_1935>> blockItemGroups = Map.of(
                class_3481.field_16584, BlockTypeGroup.FENCE.blocks(),
                class_3481.field_25147, BlockTypeGroup.FENCE_GATE.blocks(),
                class_3481.field_15504, BlockTypeGroup.WALL.blocks(),
                class_3481.field_15459, BlockTypeGroup.STAIR.blocks(),
                class_3481.field_15469, BlockTypeGroup.SLAB.blocks(),
                class_3481.field_15493, BlockTypeGroup.BUTTON.blocks(),
                class_3481.field_15487, BlockTypeGroup.TRAPDOOR.blocks(),
                class_3481.field_15495, BlockTypeGroup.DOOR.blocks(),
                class_3481.field_15503, BlockTypeGroup.LEAVES.blocks()
        );
        blockItemGroups.forEach((tag, list) -> {
            class_11389<class_2248, class_2248> builder = valueLookupBuilder(tag);
            for (class_1935 itemConvertible : list) {
                if (itemConvertible instanceof class_2248 block) {
                    builder.method_71554(block);
                }
            }
        });
        villagerJobSites.method_71558(
                RDBlocks.WOODEN_BOX.chestBlock(),
                RDBlocks.CASH_BOX_BLOCK
        );

        pickaxeMineables.method_71558(RDBlocks.SILVER_BLOCK, RDBlocks.SILVER_ORE, RDBlocks.DEEPSLATE_SILVER_ORE);
        pickaxeMineables.method_71554(RDBlocks.SILVER_CHEST_BLOCK.chestBlock());
        pickaxeMineables.method_71558(RDBlocks.ORB_ORE, RDBlocks.DEEPSLATE_ORB_ORE);
        pickaxeMineables.method_71554(RDBlocks.DREAM_CRYSTAL_ORE);
        pickaxeMineables.method_71554(RDBlocks.GENSOKYO_ALTAR);
        pickaxeMineables.method_71554(RDBlocks.ANTI_COLLISION_BARREL);
        pickaxeMineables.method_71554(RDBlocks.WHEEL_CHAIR);
//        pickaxeMineables.add(MIBlocks.COOKTOP);
        RDWoodBlocks.SPIRITUAL.stream().forEach(axeMineables::method_71554);
        RDWoodBlocks.LEMON.stream().forEach(axeMineables::method_71554);
        RDWoodBlocks.GINKGO.stream().forEach(axeMineables::method_71554);
        RDWoodBlocks.PEACH.stream().forEach(axeMineables::method_71554);
        RDWoodBlocks.SPIRITUAL.stream().forEach(axeMineables::method_71554);
        axeMineables.method_71554(RDBlocks.DANMAKU_CRAFTING_TABLE);
        axeMineables.method_71554(RDBlocks.MUSIC_BLOCK);
        axeMineables.method_71554(RDBlocks.CASH_BOX_BLOCK);
        hoeMineables.method_71554(RDBlocks.POWER_BLOCK);
        hoeMineables.method_71554(RDBlocks.POINT_BLOCK);
        sliver.method_71558(RDBlocks.SILVER_BLOCK, RDBlocks.SILVER_ORE, RDBlocks.DEEPSLATE_SILVER_ORE);
        ores.method_71558(RDBlocks.SILVER_ORE, RDBlocks.DEEPSLATE_SILVER_ORE);
        ores.method_71558(RDBlocks.ORB_ORE, RDBlocks.DEEPSLATE_ORB_ORE);

        pickaxeMineables.method_71558(RDBlocks.ICE_SCALES.block(), RDBlocks.ICE_SCALES.slab(), RDBlocks.ICE_SCALES.stair());
        pickaxeMineables.method_71558(RDBlocks.DREAM_STONE.block(), RDBlocks.DREAM_STONE.slab(), RDBlocks.DREAM_STONE.stair());
        pickaxeMineables.method_71558(RDBlocks.DREAM_STONE_BRICK.block(), RDBlocks.DREAM_STONE_BRICK.slab(), RDBlocks.DREAM_STONE_BRICK.stair());
        pickaxeMineables.method_71558(RDBlocks.MOON_STONE.block(), RDBlocks.MOON_STONE.slab(), RDBlocks.MOON_STONE.stair());
        pickaxeMineables.method_71558(RDBlocks.MOON_STONE_BRICK.block(), RDBlocks.MOON_STONE_BRICK.slab(), RDBlocks.MOON_STONE_BRICK.stair());

        minTools.method_71554(class_2246.field_9987);
        minTools.method_71554(class_2246.field_10499);
        empty.method_71554(class_2246.field_9987);
        empty.method_71554(class_2246.field_10499);
    }
}
