package cc.thonly.reverie_dreams.entity;

import cc.thonly.reverie_dreams.data.skin.SkinType;
import cc.thonly.reverie_dreams.entity.ai.goal.DanmakuGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.DifferentRevengeGoal;
import cc.thonly.reverie_dreams.entity.interfaces.DanmakuShooter;
import cc.thonly.reverie_dreams.entity.interfaces.FriendlyFaction;
import cc.thonly.reverie_dreams.entity.interfaces.Yousei;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import cc.thonly.reverie_dreams.server.DelayedTask;
import lombok.Getter;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_9817;

@Getter
public class SunflowerYouseiEntity extends BaseNPCLikeEntity implements class_9817, FriendlyFaction, Yousei {
    public SunflowerYouseiEntity(class_1299<? extends class_1321> entityType, class_1937 world, SkinType skinType) {
        super(entityType, world, skinType);
        this.field_6194 = 5;
        NPCInventoryImpl inventory = this.getInventory();
        inventory.setHead(class_1802.field_17525.method_7854());
        inventory.setMainHand(class_1802.field_17525.method_7854());
    }

    @Override
    protected void method_5959() {
        super.method_5959();

        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1386(this));
//        this.goalSelector.add(2, new SmartFlyGoal(this, 1.5));

//        this.goalSelector.add(8, new WanderAroundFarGoal(this, 1.0));

        this.field_6201.method_6277(3, new DanmakuGoal(this, (self, target, world) -> {
            class_1799 stack = DanmakuTypes.random(DanmakuTypes.BUBBLE);
            float[] pitchYaw = DanmakuShooter.getPitchYaw(self, target);
            DelayedTask.repeat(world.method_8503(), 2, 0.8f, () -> {
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] - 15.0f, 0.5f, 5.0f, 0.2f);
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1], 0.5f, 5.0f, 0.2f);
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] + 15.0f, 0.5f, 5.0f, 0.2f);
            });
        }));
        this.field_6201.method_6277(3, new class_1361(this, class_1657.class, 10.0f));
        this.field_6201.method_6277(4, new class_1361(this, class_1308.class, 10.0f));
        this.field_6201.method_6277(5, new class_1376(this));

        this.field_6185.method_6277(1, new DifferentRevengeGoal(this).setGroupRevenge());
        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1439.class, true));
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        int i = this.field_5974.method_39332(1, 9);
        if (i<=3) {
            class_1937 world = this.method_37908();
            class_1799 itemStack = new class_1799(RDIngredientItems.MOONFLOWER, this.field_5974.method_39332(1,2));
            class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), itemStack);
            world.method_8649(itemEntity);
        }
    }

    @Override
    public Boolean canPickItem() {
        return false;
    }

    @Override
    public String getFactionId() {
        return "mob";
    }

    @Override
    public boolean method_17326() {
        return false;
    }

}
