package cc.thonly.reverie_dreams.entity;

import cc.thonly.reverie_dreams.entity.ai.goal.DanmakuGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.UniversalLivingAngerGoal;
import cc.thonly.reverie_dreams.entity.interfaces.DanmakuShooter;
import cc.thonly.reverie_dreams.entity.interfaces.FriendlyFaction;
import cc.thonly.reverie_dreams.entity.interfaces.VariantData;
import cc.thonly.reverie_dreams.entity.interfaces.Yousei;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.entity.variant.YouseiVariant;
import cc.thonly.reverie_dreams.entity.variant.YouseiVariants;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.server.DelayedTask;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1321;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_9817;
import net.minecraft.server.MinecraftServer;
import java.util.Objects;

@Setter
@Getter
public class YouseiEntity extends BaseNPCLikeEntity implements class_9817, FriendlyFaction, VariantData, Yousei {
    private YouseiVariant variant = null;

    public YouseiEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType,
                world,
                (
                        YouseiVariants.isEmpty()
                                ? (YouseiVariants.REGISTRY.method_60385().isPresent() ? YouseiVariants.REGISTRY.method_60385().get().comp_349().getSkinType() : YouseiVariants.BLUE.getSkinType())
                                : Objects.requireNonNull(YouseiVariants.random()).getSkinType()
                )
       );
        this.field_6194 = 5;
        this.variant = YouseiVariants.getFromProperty(this.getSkin());
    }

    @Override
    protected void method_5959() {
        super.method_5959();

        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new DanmakuGoal(this, (self, target, world) -> {
            class_1799 stack = DanmakuTypes.random(DanmakuTypes.FIREBALL_GLOWY);
            final MinecraftServer server = world.method_8503();
            final float[] pitchYaw = DanmakuShooter.getPitchYaw(self, target);

            DelayedTask.repeat(server, 1, 0.3f, () -> {
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] - 15.0f, 0.5f, 5.0f, 0.2f);
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1], 0.5f, 5.0f, 0.2f);
                DanmakuShooter.spawn(world, self, stack, pitchYaw[0], pitchYaw[1] + 15.0f, 0.5f, 5.0f, 0.2f);
            });
        }));
//        this.goalSelector.add(2, new SmartFlyGoal(this, 1.2));

        this.field_6201.method_6277(3, new class_1361(this, class_1657.class, 6.0f));
        this.field_6201.method_6277(4, new class_1361(this, class_1308.class, 6.0f));
        this.field_6201.method_6277(5, new class_1376(this));

        this.field_6201.method_6277(8, new class_1394(this, 1.0));

        this.field_6185.method_6277(1, new class_1399(this).method_6318());
        this.field_6185.method_6277(3, new UniversalLivingAngerGoal<>(this, false));
    }

    @Override
    public void method_5773() {
        this.skinType = this.variant != null ? this.variant.getSkinType() : YouseiVariants.BLUE.getSkinType();
        super.method_5773();
    }

    @Override
    public void method_6007() {
        super.method_6007();
        class_243 vec3d = method_18798();
        if (!method_24828() && vec3d.field_1351 < 0.0 && !(field_6207.method_6235() < method_23318())) {
            method_18799(vec3d.method_18805(1.0, 0.6, 1.0));
        }
    }

    @Override
    public void method_5749(class_11368 view) {
        super.method_5749(view);
        String youseiVariantId = view.method_71428("YouseiVariant", YouseiVariants.DEFAULT_ID.toString());
        class_2960 variantId = class_2960.method_60654(youseiVariantId);
        this.variant = RegistryHandlers.YOUSEI_VARIANT.method_63535(variantId);
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71469("YouseiVariant", this.variant.getId().toString());
    }

    @Override
    public Boolean canPickItem() {
        return false;
    }

    @Override
    public String getFactionId() {
        return "mob";
    }

    @Override
    public void setVariantData(class_2960 id) {
        this.variant = RegistryHandlers.YOUSEI_VARIANT.method_63535(id);
        if (this.variant != null) {
            this.skinType = this.variant.getSkinType();
        }
    }

    @Override
    public class_2960 getVariantData() {
        return this.variant.getId();
    }

    @Override
    public boolean method_17326() {
        return false;
    }
}
