package cc.thonly.reverie_dreams.entity.ai.goal;

import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1405;
import net.minecraft.class_1928;
import net.minecraft.class_238;
import net.minecraft.class_4051;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.List;

public class DifferentRevengeGoal extends class_1405 {
    private static final class_4051 VALID_AVOIDABLES_PREDICATE = class_4051.method_36625().method_36627().method_18424();
    private static final int BOX_VERTICAL_EXPANSION = 10;
    private boolean groupRevenge;
    private int lastAttackedTime;
    private final Class<?>[] noRevengeTypes;
    @Nullable
    private Class<?>[] noHelpTypes;

    public DifferentRevengeGoal(class_1314 mob, Class<?> ... noRevengeTypes) {
        super(mob, true);
        this.noRevengeTypes = noRevengeTypes;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }

    @Override
    public boolean method_6264() {
        int i = this.field_6660.method_6117();
        class_1309 livingEntity = this.field_6660.method_6065();
        if (i == this.lastAttackedTime || livingEntity == null) {
            return false;
        }
        if (livingEntity.method_5864() == class_1299.field_6097 && class_1399.method_64451(this.field_6660).method_64395().method_8355(class_1928.field_25402)) {
            return false;
        }
        if (livingEntity.method_5864() == this.field_6660.method_5864()) {
            return false;
        }
        for (Class<?> class_ : this.noRevengeTypes) {
            if (!class_.isAssignableFrom(livingEntity.getClass())) continue;
            return false;
        }
        return this.method_6328(livingEntity, VALID_AVOIDABLES_PREDICATE);
    }

    public DifferentRevengeGoal setGroupRevenge(Class<?> ... noHelpTypes) {
        this.groupRevenge = true;
        this.noHelpTypes = noHelpTypes;
        return this;
    }

    @Override
    public void method_6269() {
        this.field_6660.method_5980(this.field_6660.method_6065());
        this.field_6664 = this.field_6660.method_5968();
        this.lastAttackedTime = this.field_6660.method_6117();
        this.field_6657 = 300;
        if (this.groupRevenge) {
            this.callSameTypeForRevenge();
        }
        super.method_6269();
    }

    protected void callSameTypeForRevenge() {
        double d = this.method_6326();
        class_238 box = class_238.method_29968(this.field_6660.method_19538()).method_1009(d, 10.0, d);
        List<? extends class_1308> list = this.field_6660.method_37908().method_8390(this.field_6660.getClass(), box, class_1301.field_6155);
        for (class_1308 mobEntity : list) {
            if (this.field_6660 == mobEntity || mobEntity.method_5968() != null || this.field_6660 instanceof class_1321 && ((class_1321)this.field_6660).method_35057() != ((class_1321)mobEntity).method_35057() || mobEntity.method_5722(this.field_6660.method_6065())) continue;
            if (this.noHelpTypes != null) {
                boolean bl = false;
                for (Class<?> class_ : this.noHelpTypes) {
                    if (mobEntity.getClass() != class_) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
            }
            this.setMobEntityTarget(mobEntity, this.field_6660.method_6065());
        }
    }

    protected void setMobEntityTarget(class_1308 mob, class_1309 target) {
        mob.method_5980(target);
    }
}

