package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.block.entity.CustomChestBlockEntity;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_3341;
import net.minecraft.class_3417;

public class NPCOpenSilverChestGoal extends class_1352 {
    private final BaseNPCLikeEntity roleEntity;
    @Nullable
    private OperationalTarget operationalTarget;
    private int tick = 0;

    public NPCOpenSilverChestGoal(BaseNPCLikeEntity roleEntity) {
        this.roleEntity = roleEntity;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    private List<class_2338> findSilverChestBlockPosList() {
        List<class_2338> blockPosList = new LinkedList<>();
        class_1937 world = this.roleEntity.method_37908();
        class_2338 center = this.roleEntity.getWorkingPos();
        int r = 8;

        class_3341 box = new class_3341(
                center.method_10263() - r,
                center.method_10264() - r,
                center.method_10260() - r,
                center.method_10263() + r,
                center.method_10264() + r,
                center.method_10260() + r
        );
        class_2338.class_2339 pos = new class_2338.class_2339();

        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                    pos.method_10103(x, y, z);
                    if (!(world.method_8320(pos).method_26204() == RDBlocks.SILVER_CHEST_BLOCK.getChestBlock())) {
                        continue;
                    }
                    if (world.method_8321(pos) instanceof CustomChestBlockEntity customChestBlockEntity) {
                        blockPosList.add(pos.method_10062());
                    }
                }
            }
        }
        return blockPosList;
    }

    @Override
    public boolean method_6264() {
        if (!this.roleEntity.method_6181()) {
            return false;
        }
        if (this.operationalTarget != null) {
            return true;
        }

        return this.trySetTarget();
    }

    private boolean trySetTarget() {
        class_1937 world = this.roleEntity.method_37908();
        List<class_2338> silverChestBlockPosList = this.findSilverChestBlockPosList();
        for (class_2338 blockPos : silverChestBlockPosList) {
            class_2586 blockEntity = world.method_8321(blockPos);
            if (!(blockEntity instanceof CustomChestBlockEntity customChestBlockEntity)) {
                continue;
            }
            if (customChestBlockEntity.method_5442()) {
                continue;
            }
            for (int i = 0; i < customChestBlockEntity.getInventory().getContainerSize(); i++) {
                class_1799 itemStack = customChestBlockEntity.method_5438(i);
                if (itemStack.method_7960()) {
                    continue;
                }
                NPCInventoryImpl inventory = this.roleEntity.getInventory();
                if (!inventory.method_27070(itemStack)) {
                    continue;
                }
                this.operationalTarget = new OperationalTarget(i, itemStack, blockPos, customChestBlockEntity);
                return true;
            }
        }
        return false;
    }

    @Override
    public void method_6268() {
        super.method_6268();
        if (this.tick < 20 * 1.5) {
            this.tick++;
            return;
        }
        this.tick = 0;
        if (this.operationalTarget != null) {
            class_2338 blockPos = this.operationalTarget.blockPos;
            if (!this.isReached(blockPos)) {
                this.roleEntity.method_5942().method_6337(
                        blockPos.method_10263() + 0.5,
                        blockPos.method_10264() + 0.5,
                        blockPos.method_10260() + 0.5,
                        1.0D
                );
            } else {
                CustomChestBlockEntity customChestBlockEntity = this.operationalTarget.customChestBlock;
                class_1799 itemStack = this.operationalTarget.itemStack;
                int slotIndex = this.operationalTarget.index;

                NPCInventoryImpl inventory = this.roleEntity.getInventory();

                int inserted = inventory.insertStack(itemStack);
                if (inserted > 0) {
                    itemStack.method_7934(inserted);
                    customChestBlockEntity.method_5431();
                    this.roleEntity.method_56078(class_3417.field_14982);
                    this.roleEntity.method_6104(class_1268.field_5808);
                    double x = blockPos.method_10263() + 0.5;
                    double y = blockPos.method_10264() + 0.5;
                    double z = blockPos.method_10260() + 0.5;
                    this.roleEntity.method_5988().method_20248(x, y, z);
                }

                if (itemStack.method_7960()) {
                    this.operationalTarget = null;
                }
            }
        } else {
            this.trySetTarget();
        }
    }

    private boolean isReached(class_2338 blockPos) {
        double distanceSq = blockPos.method_19770(this.roleEntity.method_19538());
        return distanceSq <= 9; // 半径 3 格
    }

    @Override
    public boolean method_6266() {
        return this.operationalTarget != null;
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    public record OperationalTarget(int index,
                                    class_1799 itemStack,
                                    class_2338 blockPos,
                                    CustomChestBlockEntity customChestBlock) {
    }
}
