package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.data.npc.NPCState;
import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.registry.content.NPCStates;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import lombok.Getter;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1405;
import net.minecraft.class_1588;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_4051;
import java.util.EnumSet;
import java.util.List;

@Getter
public class NPCCleanMonsterGoal extends class_1405 {

    public NPCCleanMonsterGoal(BaseNPCLikeEntity maid) {
        super(maid, false);
        this.maid = maid;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
    }


    private final BaseNPCLikeEntity maid;


    class_4051 targetPredicate = class_4051.method_36625().method_18418(16).method_18420((e,w)->{return  !e.method_16914();});
    class_1309 targetEntity;

    @Override
    public boolean method_6264() {
//        System.out.println("invoke");
        if (!this.maid.method_6181() || this.maid.method_24345()) {
//            System.out.println("ret1"+this.maid.isTamed());
            return false;
        }
        NPCState state = maid.getNpcState();
        class_1309 owner = this.maid.method_35057();
//        boolean isMaidHasWeapon = this.maid.getMainHandStack().isIn(ItemTags.SWORDS);
        if (owner == null||state!= NPCStates.WORKING|| maid.getWorkMode()!= NPCWorkModes.COMBAT) {
//            System.out.println("ret2"+" own"+owner);
            return false;
        }
        class_2338 workPos = maid.getWorkingPos();
        class_3218 serverWorld = method_64451(maid);

        //serverWorld.getClosestEntity(HostileEntity.class,)
        List<class_1588> targets = this.field_6660.method_37908().method_8390(class_1588.class, new class_238(workPos).method_1009(16, 8, 16), (e)->{
            return e.method_5805()&& EntityTargetUtil.canAttack(e,maid);
        });
//        System.out.println(targets.size());
        //处于工作原点水平方向拓展16格内的所有怪物
        targetEntity = serverWorld.method_64393(targets, targetPredicate, this.maid, this.maid.method_23317(), this.maid.method_23320(), this.maid.method_23321());
        //挑选离女仆最近的怪物
        return targetEntity!=null;
    }
    @Override
    public void method_6269() {
        this.maid.method_5980(targetEntity);
    }
}
