package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.block.base.AbstractCropBlock;
import cc.thonly.reverie_dreams.compat.BorukvaFoodCompatImpl;
import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.inf.IMatureBlock;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3489;
import net.minecraft.class_5712;

public class NPCFarmGoal extends class_1352 {


    //计时器 避免种植太快显得不是人
    private int workTimer = 0;


    private final BaseNPCLikeEntity maid;
    private class_2338 targetPos;
    private static final Predicate<class_1799> IS_SEED = stack -> !stack.method_7960() && stack.method_31573(class_3489.field_44591) && stack.method_7909() instanceof class_1747;


    public NPCFarmGoal(BaseNPCLikeEntity maid) {
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.maid = maid;

    }

    @Override
    public boolean method_6264() {
        if (!EntityTargetUtil.isThisWorkMode(maid, NPCWorkModes.FARM)) {
            return false;
        }
//        System.out.println("tryStartNPCFarmGoal");
        targetPos = getNearTargetBlock(maid, new class_2338(maid.method_31477(), (int) Math.floor(maid.method_23318()), maid.method_31479())
                , true);
//        System.out.println("Target: "+targetPos);
        if (targetPos != null) {
//            System.out.println("ret True");
            return true;
        }


        return false;
    }


    @Override
    public void method_6269() {


    }

    @Override
    public void method_6268() {
        workTimer++;
        if (maid.method_5942().method_23966()) {
            maid.method_5942().method_6340();
            workTimer = 0;
        }
        if (isCrop(targetPos, method_64451(maid)) || isFarmLandTop(targetPos, method_64451(maid))) {
            this.maid.method_5988().method_19615(targetPos.method_46558().method_43206(class_2350.field_11033, 0.5));
            if (workTimer % 8 == 0) {
                this.maid.method_6104(class_1268.field_5808);
                harvest(targetPos);
                planting(targetPos);
            }
        }
        super.method_6268();
    }

    @Override
    public void method_6270() {
        workTimer = 0;
        super.method_6270();
    }

    public static boolean isMature(IMatureBlock crop, class_2680 cropsState) {
        if (crop instanceof class_2302 cropBlock) {
            return cropBlock.method_9825(cropsState);
        } else if (crop instanceof AbstractCropBlock basicCropBlock) {
            return basicCropBlock.isMature(cropsState);
        }
        return false;
    }

    public boolean harvest(class_2338 targetFarmLandTop) {
        class_3218 serverWorld = method_64451(maid);
        class_2680 cropsState = serverWorld.method_8320(targetFarmLandTop);
        if (cropsState.method_26204() instanceof IMatureBlock crop && this.isMature(crop, cropsState)) {
            dropItem(targetFarmLandTop);
            //调用breakBlock无法吃到时运 自定义掉落并关闭break的掉落
            serverWorld.method_8651(targetFarmLandTop, false, maid);
            maid.method_5942().method_6348(targetFarmLandTop, 10);
            return true;
        }
        return false;
    }

    public boolean planting(class_2338 targetFarmLandTop) {
        if (!isFarmLandTop(targetFarmLandTop, method_64451(maid))) return false;
        class_3218 serverWorld = method_64451(maid);
        Integer seedSlot = maid.getInventory().findHand(IS_SEED);
        if (seedSlot == null) return false;
        class_1799 seedStack = maid.getInventory().getItem(seedSlot);
        class_2680 statePlant = ((class_1747) seedStack.method_7909()).method_7711().method_9564();
        serverWorld.method_8501(targetFarmLandTop, statePlant);
        serverWorld.method_43276(class_5712.field_28164, targetFarmLandTop, class_5712.class_7397.method_43286(maid, statePlant));
        serverWorld.method_43128(
                null, targetFarmLandTop.method_10263(), targetFarmLandTop.method_10264(), targetFarmLandTop.method_10260(), class_3417.field_17611, class_3419.field_15245, 1.0F, 1.0F
        );
        seedStack.method_7934(1);
        if (seedStack.method_7960()) {
            maid.getInventory().setItem(seedSlot, class_1799.field_8037);
        }
        return true;
    }

    //掉落农作物
    public void dropItem(class_2338 cropPos) {
        class_3218 serverWorld = method_64451(maid);
        class_2680 cropState = serverWorld.method_8320(cropPos);
        class_2586 blockEntity = cropState.method_31709() ? serverWorld.method_8321(cropPos) : null;

        class_2248.method_9511(cropState, serverWorld, cropPos, blockEntity, maid, maid.method_6047());
    }


    public static class_2338 getNearTargetBlock(BaseNPCLikeEntity maid, class_2338 origen, boolean random) {
        List<class_2338> targetFarmlands = new LinkedList<>();
        class_2338.class_2339 mutable = maid.method_24515().method_25503();
        for (int i = -1; i <= 1; i++) {
            for (int j = -1; j <= 1; j++) {
                for (int k = -1; k <= 1; k++) {
                    mutable.method_10103(origen.method_10263() + i, Math.round(origen.method_10264()) + j, origen.method_10260() + k);
                    if (NPCFarmGoal.isCrop(mutable, method_64451(maid)) || (isMaidHasSeeds(maid) && isFarmLandTop(mutable, method_64451(maid)))) {
                        if (!random) return new class_2338(mutable);
//                        this.targetPositions.add(new BlockPos(mutable));
                        targetFarmlands.add(new class_2338(mutable));
                    }
                }
            }
        }
        return targetFarmlands.isEmpty() ? null : (class_2338) targetFarmlands.get(method_64451(maid).method_8409().method_43048(targetFarmlands.size()));


    }

    public static boolean isMaidHasSeeds(BaseNPCLikeEntity maid) {
        return maid.getInventory().findHand(IS_SEED) != null;
    }

    //这个位置是否可以收割/种植
    public static boolean isCrop(class_2338 pos, class_3218 world) {
        class_2680 blockState = world.method_8320(pos);
        class_2248 crop = blockState.method_26204();
        if (!(crop instanceof IMatureBlock iMatureBlock)) {
            return false;
        }
        return isMature(iMatureBlock, blockState);
//        return is && ((IMatureBlock) crop).isMature(blockState);
    }

    //这个方块下面是不是耕地
    public static boolean isFarmLandTop(class_2338 b, class_3218 world) {
        class_2248 block = world.method_8320(b.method_10074()).method_26204();
        return world.method_8320(b).method_26215() && (block instanceof class_2344 || (BorukvaFoodCompatImpl.hasBorukvaFood() && block == BorukvaFoodCompatImpl.BETTER_FARMLAND));
    }


}
