package cc.thonly.reverie_dreams.entity.elemental;

import cc.thonly.reverie_dreams.entity.interfaces.ElementalMob;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.skin.MobSkinTypes;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.world.entity.*;
import net.minecraft.world.entity.ai.goal.*;

public class IceElementalEntity extends BaseNPCLikeEntity implements ElementalMob {
    public int aTick = 0;

    public IceElementalEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world, MobSkinTypes.ICE_ELEMENTAL);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1386(this));

        this.field_6201.method_6277(7, new class_1341(this, 1.0));
        this.field_6201.method_6277(8, new class_1394(this, 1.0));

        this.field_6201.method_6277(10, new class_1361(this, class_1657.class, 16.0f));
        this.field_6201.method_6277(10, new class_1361(this, BaseNPCLikeEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1376(this));

        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, false));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1439.class, false));
        this.field_6185.method_6277(3, new class_1399(this).method_6318());
    }

    @Override
    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            if (this.aTick > 10) {
                class_2680 blockState = serverWorld.method_8320(this.method_24515());
                class_2248 block = blockState.method_26204();
                boolean bl1 = block.equals(class_2246.field_10382);
                boolean bl2 = block.equals(class_2246.field_10164) || block.equals(class_2246.field_10036);
                if (bl1) {
                    this.method_6092(new class_1293(class_1294.field_5904, 3 * 20));
                    this.method_6092(new class_1293(class_1294.field_5900, 3 * 20));
                    this.method_6092(new class_1293(class_1294.field_5924, 3 * 20));
                }
                if (bl2) {
                    this.method_6092(new class_1293(class_1294.field_5920, 3 * 20));
                }
                this.aTick = -1;
            }
            this.aTick++;
        }
    }

    @Override
    public boolean method_6121(class_3218 world, class_1297 target) {
        if (target instanceof class_1309) {
            ((class_1309) target).method_6092(new class_1293(class_1294.field_5909, 20 * 15, 1));
            ((class_1309) target).method_6092(new class_1293(class_1294.field_5901, 20 * 15));
        }
        return super.method_6121(world, target);
    }

    public static class_5132 createAttributes() {
        return class_1309.method_26827()
                .method_26868(class_5134.field_23716, 40.0)
                .method_26868(class_5134.field_23719, 0.22)
                .method_26868(class_5134.field_23722, 0.25)
                .method_26868(class_5134.field_23721, 3.5)
                .method_26868(class_5134.field_23718, 0.1)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_52450, 10.0)
                .method_26868(class_5134.field_47759, 3)
                .method_26866();
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        class_1937 world = this.method_37908();
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            class_1542 itemEntity = new class_1542(serverWorld, this.method_23317(), this.method_23318(), this.method_23321(), new class_1799(RDBlocks.MAGIC_ICE_BLOCK, class_5819.method_43047().method_39332(0, 5)), 0, 0.1, 0);
            world.method_8649(itemEntity);
        }
    }

    @Override
    public Boolean canPickItem() {
        return false;
    }

    public static boolean canSpawn(
            class_1299<? extends class_1308> type,
            class_5425 world,
            class_3730 spawnReason,
            class_2338 pos,
            class_5819 random
    ) {
        class_3218 serverWorld = world.method_8410();
        // 脚下方块
        class_2680 ground = world.method_8320(pos.method_10074());
        boolean isSnowBlock = ground.method_27852(class_2246.field_10491)
                || ground.method_27852(class_2246.field_10477)
                || ground.method_27852(class_2246.field_27879)
                || (ground.method_27852(class_2246.field_10219) && ground.method_11654(class_2741.field_12512)); // 有雪覆盖的草方块

        if (!isSnowBlock) {
            return false;
        }

        // 光照条件（火把等会提高亮度）
        int light = world.method_22335(pos, 0);

        // 世界时间（0~23999，0~12000 白天，12000~23999 夜晚）
        long timeOfDay = serverWorld.method_8532() % 24000L;
        boolean isNight = timeOfDay >= 13000 && timeOfDay <= 23000; // 晚上时间段

        return isNight && light <= 7;
    }

}
