package cc.thonly.reverie_dreams.entity.holder;

import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1309;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@Setter
@Getter
public class WheelChairHolder extends ElementHolder {
    private ItemDisplayElement element;
    private class_1309 entity;

    public WheelChairHolder(class_1309 entity) {
        this.entity = entity;
    }

    @Override
    protected void onTick() {
        super.onTick();
        if(this.element != null) {
            if (this.entity.method_29504()) {
                this.element.setScale(new Vector3f(0));
                return;
            }
            Matrix4f transform = new Matrix4f()
                    .translate(0f, 0.3f, 0f)
                    .rotateY((float) Math.PI)
                    .rotateY((float) Math.toRadians(-this.entity.method_5791()))
                    .scale(1f);

            this.element.setTransformation(transform);
            this.element.startInterpolationIfDirty();
        }
    }
}
