package cc.thonly.reverie_dreams.entity.misc;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.entity.interfaces.FriendlyFaction;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_10707;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;


@Setter
@Getter
@ToString
public class DanmakuEntity extends class_1665 {
    public static final class_2940<Float> ROLL = class_2945.method_12791(DanmakuEntity.class, class_2943.field_13320);
    private static final Map<String, Long> PARTICLE_COOLDOWN = new HashMap<>();
    private static final long PARTICLE_INTERVAL_MS = 50;
    private static final double GRAZE_RADIUS = 0.5;
    private static final Map<Integer, Long> GRAZE_CACHE = new HashMap<>(); // 记录 entityId -> lastTick
    public static final int MAX_FLIGHT_TICK = 20 * 20;
    protected class_1792 danmakuItem;
    protected class_1799 itemStack = class_1802.field_8543.method_7854();
    protected OnHitFactory onHitEffect = (livingEntity, damage) -> {

    };
    public DanmakuProperties properties = DanmakuProperties.ofDefault();
    private float originPitch;
    private float originYaw;

    public int flyAge = 0;
    protected int fluidAge = 0;
    protected int fightTick = 0;
    protected int particleTick = 0;
    private int remainingBounces = 16;

    public DanmakuEntity(@Nullable class_1297 livingEntity,
                         class_3218 world,
                         Double x, Double y, Double z,
                         class_1799 stack,
                         DanmakuProperties properties,
                         Float pitch, Float yaw,
                         Float divergence, Float offsetDist
    ) {
        this(livingEntity, world, x, y, z, stack, properties, pitch, yaw, divergence, offsetDist, true);
    }

    public DanmakuEntity(@Nullable class_1297 livingEntity,
                         class_3218 world,
                         Double x, Double y, Double z,
                         class_1799 stack,
                         DanmakuProperties properties,
                         Float pitch, Float yaw,
                         Float divergence, Float offsetDist,
                         boolean entityDelta
    ) {
        super(RDEntityTypes.DANMAKU,
                x,
                y + (livingEntity != null ? livingEntity.method_5751() : 0),
                z,
                world,
                stack.method_7972(),
                stack.method_7972()
        );
        this.originPitch = pitch;
        this.originYaw = yaw;
        this.properties = properties;
        double offsetX = -Math.sin(Math.toRadians(yaw)) * offsetDist;
        double offsetZ = Math.cos(Math.toRadians(yaw)) * offsetDist;

        double newX = x + offsetX;
        double newY = y + (livingEntity != null ? livingEntity.method_5751() : 0) + (entityDelta ? 0 : -0.5);
        double newZ = z + offsetZ;
        this.method_23327(newX, newY, newZ);

        this.method_7432(livingEntity);
        if (livingEntity != null && entityDelta) {
            this.method_24919(livingEntity, pitch, yaw, 0.0F, this.properties.getSpeed(), divergence);
            this.method_18799(this.method_18798().method_1020(livingEntity.method_18798()));
        } else {
            this.shootFromRotation(pitch, yaw);
        }

        this.method_36456(yaw);
        this.method_36457(pitch);
        this.field_7572 = class_1666.field_7594;
        this.method_7438(properties.getDamage() * 1.5);
        this.setCustomPierceLevel((byte) 1);
        this.setItemStack(stack.method_7972());
        this.setDanmakuItem(stack.method_7909());
        this.method_5875(true);
    }

    public DanmakuEntity(class_1299<DanmakuEntity> danmakuEntityEntityType, class_1937 world) {
        super(danmakuEntityEntityType, world);
        this.setDanmakuItem(null);
        this.originPitch = 0;
        this.originYaw = 0;
    }

    void shootFromRotation(float pitch, float yaw) {
        this.method_36456(yaw);
        this.method_36457(pitch);

        float pitchRad = (float) Math.toRadians(pitch);
        float yawRad = (float) Math.toRadians(yaw);

        double dx = -Math.sin(yawRad) * Math.cos(pitchRad);
        double dy = -Math.sin(pitchRad);
        double dz = Math.cos(yawRad) * Math.cos(pitchRad);

        double speed = 0.5 * (this.properties != null ? this.properties.getSpeed() : 0.6d);
        class_243 motion = new class_243(dx * speed, dy * speed, dz * speed);
        this.method_18799(motion);

        this.method_5875(true);
    }


    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ROLL, 0f);
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        if (!this.itemStack.method_7960()) {
            view.method_71468("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC, this.itemStack.method_7972());
        }
        view.method_71468("Properties", DanmakuProperties.CODEC, this.properties);
        view.method_71465("FlyAge", this.flyAge);
        view.method_71465("RemainingBounces", this.remainingBounces);
        view.method_71468("VelocityVector", class_243.field_38277, this.method_18798());
    }

    @Override
    protected void method_5749(class_11368 view) {
        super.method_5749(view);
        this.itemStack = view.method_71426("Item", ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC).orElse(class_1799.field_8037);
        this.properties = view.method_71426("Properties", DanmakuProperties.CODEC).orElse(DanmakuProperties.ofDefault());
        this.flyAge = view.method_71424("FlyAge", 0);
        this.remainingBounces = view.method_71424("RemainingBounces", 0);
        Optional<class_243> velocityVector = view.method_71426("VelocityVector", class_243.field_38277);
        velocityVector.ifPresent(this::method_18799);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_65059()) {
            this.field_6011.method_12778(ROLL, (float) (this.field_6011.method_12789(ROLL) - class_3532.field_29847 * this.method_18798().method_1027() * 15) % class_3532.field_29846);
        }

        this.method_36457(this.originPitch);
        this.method_36456(this.originYaw);

        this.particleTick();
        this.waterTick();
        this.fightTick();
//        this.grazeTick();
    }

    private void grazeTick() {
        if (!(this.method_37908() instanceof class_3218 serverLevel)) return;
        if (serverLevel.method_8510() % 2 != 0) return;
        List<class_1297> nearby = serverLevel.method_18467(
                class_1297.class,
                this.method_5829().method_1014(GRAZE_RADIUS)
        );

        for (class_1297 entity : nearby) {
            if (entity.method_7325() || entity.method_31481()) {
                continue;
            }
            if (entity == this.method_24921()) {
                continue;
            }
            if (this.method_24921() != null && this.method_24921().method_49694() == entity) {
                continue;
            }
            if (entity instanceof class_1665) {
                continue;
            }
            if (!this.canDamage(entity, this.method_24921())) {
                continue;
            }
            if (this.method_5739(entity) <= GRAZE_RADIUS) {
                continue;
            }

            int id = entity.method_5628();
            long now = serverLevel.method_8510();
            long last = GRAZE_CACHE.getOrDefault(id, -100L);
            if (now - last < 10) continue;

            GRAZE_CACHE.put(id, now);
            SoundEventInit.playSound(entity, SoundEventInit.GRAZE, 1.0f, 1.0f);
        }
    }


    private void particleTick() {
        this.particleTick++;
        if (this.particleTick > 2) {
            class_1937 world = this.method_37908();
            if (!world.method_8608() && world instanceof class_3218 serverWorld) {
                long now = System.currentTimeMillis();
                String key = this.method_5864().toString(); // 或 "danmaku"
                Long last = PARTICLE_COOLDOWN.getOrDefault(key, 0L);

                if (now - last >= PARTICLE_INTERVAL_MS) {
                    serverWorld.method_65096(
                            class_2398.field_28013,
                            this.method_19538().field_1352,
                            this.method_19538().field_1351,
                            this.method_19538().field_1350,
                            1,
                            0,
                            0,
                            0,
                            0.1
                    );
                    PARTICLE_COOLDOWN.put(key, now);
                }
            }
            this.particleTick = 0;
        }
    }

    private void waterTick() {
        if (this.method_5799()) {
            this.fluidAge++;
            if (this.fluidAge > 80) {
                this.method_31472();
            }
        }
    }

    private void fightTick() {
        this.fightTick++;
        if (this.fightTick > MAX_FLIGHT_TICK) {
            this.method_31472();
        }
    }

    @Override
    public void method_24920(class_3965 blockHitResult) {
        if (this.itemStack.method_7909() == DanmakuTypes.NOTE.getItem()) {
            method_5783(class_3417.field_14624.comp_349(), 1.0F, 1.0F);
            if (this.remainingBounces <= 0) {
                this.method_31472();
                return;
            }

            var dir = blockHitResult.method_17780();

            class_243 normal = new class_243(dir.method_10148(), dir.method_10164(), dir.method_10165()).method_1029();
            class_243 velocity = this.method_18798();

            double dot = velocity.method_1026(normal);
            class_243 reflected = velocity.method_1020(normal.method_1021(2.0 * dot));

            float damping = 0.95f;
            reflected = reflected.method_1021(damping);

            if (reflected.method_1027() < 1e-4) {
                this.method_31472();
                return;
            }

            this.method_18799(reflected);
            this.method_33574(this.method_19538().method_1019(normal.method_1021(0.05)));

            float yaw = this.method_36454();
            float pitch = this.method_36455();

            switch (dir) {
                case field_11034, field_11039, field_11043, field_11035 -> {
                    yaw = 180f - yaw;
                }
                case field_11036, field_11033 -> {
                    pitch = -pitch;
                }
            }

            yaw = (yaw % 360 + 360) % 360;
            pitch = class_3532.method_15363(pitch, -90f, 90f);
            this.method_36456(yaw);
            this.method_36457(pitch);
            this.method_5636(yaw);
            this.setOriginPitch(pitch);
            this.setOriginYaw(yaw);

            this.remainingBounces--;
            return;
        }

        this.method_33574(blockHitResult.method_17784());
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_2680 block = this.method_37908().method_8320(blockHitResult.method_17777());
            blockHitParticles(this.method_19538(), block, this.method_37908(), this.properties.getDamage() * this.method_18798().method_1033());
            class_3414 soundEvent = block.method_26231().method_10596();
            method_5803(false);
            method_5783(soundEvent, 0.2F, 1.0F);
            method_5803(true);
        }

        this.method_33572(true);
        super.method_24920(blockHitResult);
        this.method_33572(false);
        this.method_31472();
    }

    public boolean canDamage(class_1297 entity, class_1297 owner) {
        if (entity instanceof BypassHitEntity) {
            return false;
        }
        if (owner == entity) {
            return false;
        }
        if (owner instanceof FriendlyFaction ownerFaction &&
                entity instanceof FriendlyFaction entityFaction) {
            return !ownerFaction.getFactionId().equals(entityFaction.getFactionId());
        }
        return true;
    }

    @Override
    public void method_7454(class_3966 entityHitResult) {
        class_1297 entity = entityHitResult.method_17782();
        class_1297 owner = this.method_24921();
        if (!this.canDamage(entity, owner)) {
            return;
        }

        if (entity instanceof class_1657 player) {
            if (player.method_6039()) {
                boolean isInAttackRange = false;
                class_1799 activeItem = player.method_6030();
                if (!activeItem.method_7960()) {
                    class_10707 blocksAttacksComponent = activeItem.method_58694(class_9334.field_56396);
                    if (blocksAttacksComponent != null) {
                        List<class_10707.class_10708> damageReductions = blocksAttacksComponent.comp_3588();
                        for (class_10707.class_10708 damageReduction : damageReductions) {
                            float blockingAngle = damageReduction.comp_3638();

                            // ① 使用 EyePos，避免高度误差
                            class_243 toProjectile = this.method_19538().method_1020(player.method_33571()).method_1029();

                            // ② 只取水平向量，忽略 Y
                            class_243 playerLook = player.method_5828(1.0F);
                            class_243 look2D = new class_243(playerLook.field_1352, 0, playerLook.field_1350).method_1029();
                            class_243 toProj2D = new class_243(toProjectile.field_1352, 0, toProjectile.field_1350).method_1029();

                            // ③ 点积求角度，clamp 防止 NaN
                            double dot = class_3532.method_15350(look2D.method_1026(toProj2D), -1.0, 1.0);
                            double angle = Math.toDegrees(Math.acos(dot));

                            // ④ 给一个小容错（比如 +5°）
                            if (angle <= (blockingAngle / 2.0F) + 5.0F) {
                                isInAttackRange = true;
                                break; // 找到一个满足条件的就可以退出循环了
                            }
                        }
                    }
                    if (isInAttackRange) {
                        activeItem.method_61653(1, player);
                        this.method_31472(); // 拦截并移除投射物
                        return;
                    }
                }
            }

        }

        this.method_33574(entityHitResult.method_17784());
        this.method_5803(false);
        this.method_5803(true);

        this.method_7438(this.properties.getDamage());
        this.entityHitParticles(entityHitResult.method_17782(), this.properties.getDamage() * this.method_18798().method_1033());

        this.hitDamage(entityHitResult, this.method_37908());
        this.method_31472();
    }

    protected void hitDamage(class_3966 entityHitResult, class_1937 world) {
        if (world instanceof class_3218 serverWorld) {
            class_1297 target = entityHitResult.method_17782();
            class_1297 owner = this.method_24921();
            boolean bypassHurtTick = true;

            if (target instanceof class_1508 part && part.field_7007 instanceof class_1510 dragon) {
                target = dragon;
                bypassHurtTick = false;
            }

            if (target instanceof class_1309 livingTarget && this.method_24921() != entityHitResult.method_17782()) {
                class_1282 damageSource;

                if (owner instanceof class_1309 attacker) {
                    damageSource = world.method_48963().method_48800(this, attacker);
                } else {
                    class_5455 registryAccess = this.method_56673();
                    class_6880.class_6883<class_8110> damageType = registryAccess.method_30530(class_7924.field_42534)
                            .method_46747(this.properties.getDamageType());
                    damageSource = new class_1282(damageType, livingTarget);
                }

                float damageAmount = this.properties.getDamage();
                livingTarget.method_64397(serverWorld, damageSource, damageAmount);
                livingTarget.method_5684(false);
                if (bypassHurtTick) {
                    livingTarget.field_6253 = 0;
                } else {
                    livingTarget.field_6253 = 5;
                }
                this.onHitEffect.damage(livingTarget, this.properties.getDamage());
            }
        }

        if (this.itemStack.method_7909() == DanmakuTypes.NOTE.getItem()) {
            method_5783(class_3417.field_14624.comp_349(), 1.0F, 1.0F);
        }
    }

    protected void entityHitParticles(class_1297 livingEntity, double damage) {
        if (livingEntity.method_37908() instanceof class_3218 world) {
            class_243 pos = livingEntity.method_19538();
            int particleCount = (int) damage * 4;
            double radius = livingEntity.method_17681() / 2 + 0.5;
            double heightOffset = livingEntity.method_17682();

            for (int i = 0; i < particleCount; i++) {
                double angle = (2 * Math.PI / particleCount) * i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);

                class_2392 itemStackParticleEffect = new class_2392(class_2398.field_11218, this.method_57314());
                world.method_65096(
                        itemStackParticleEffect,
                        pos.field_1352,
                        pos.field_1351,
                        pos.field_1350,
                        1,
                        xOffset,
                        (heightOffset / particleCount) * i,
                        zOffset,
                        0.25
                );
            }
        }
    }

    protected void blockHitParticles(class_243 pos, class_2680 blockState, class_1937 worldTemp, double damage) {
        if (worldTemp instanceof class_3218 world) {
            int particleCount = (int) damage * 4;
            double radius = 1;
            double heightOffset = 1;


            for (int i = 0; i < particleCount; i++) {
                double angle = (2 * Math.PI / particleCount) * i;
                double xOffset = radius * Math.cos(angle);
                double zOffset = radius * Math.sin(angle);

                class_2388 blockStateParticleEffect = new class_2388(class_2398.field_11217, blockState);
                world.method_65096(
                        blockStateParticleEffect,
                        pos.field_1352,
                        pos.field_1351,
                        pos.field_1350,
                        1,
                        xOffset,
                        (heightOffset / particleCount) * i,
                        zOffset,
                        0.25
                );
            }
        }
    }


    public void setCustomPierceLevel(byte level) {
        if (!tryInvokeMethod(class_1665.class, "setPierceLevel", byte.class, level)) {
            tryInvokeMethod(class_1665.class, "method_7451", byte.class, level);
        }
    }

    private boolean tryInvokeMethod(Class<?> targetClass, String methodName, Class<?> paramType, Object paramValue) {
        try {
            Method method = targetClass.getDeclaredMethod(methodName, paramType);
            method.setAccessible(true);
            method.invoke(this, paramValue);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    @Override
    protected class_1799 method_57314() {
        if (this.danmakuItem != null && !this.danmakuItem.method_7854().method_7960()) {
            return this.danmakuItem.method_7854();
        } else {
            return new class_1799(RDItems.ICON);
        }
    }

    public interface OnHitFactory {
        void damage(class_1309 livingEntity, double damage);
    }

}
