package cc.thonly.reverie_dreams.entity.npc;

import cc.thonly.polymer.entity.PlayerPolymerEntity;
import cc.thonly.reverie_dreams.component.RoleFollowerArchive;
import cc.thonly.reverie_dreams.data.npc.NPCState;
import cc.thonly.reverie_dreams.data.npc.NPCWorkMode;
import cc.thonly.reverie_dreams.data.skin.SkinType;
import cc.thonly.reverie_dreams.entity.ai.goal.attack.NPCBowAttackGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.attack.NPCCrossbowAttackGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.attack.NPCDanmakuItemGoal;
import cc.thonly.reverie_dreams.entity.ai.goal.attack.RangedAttackUtil;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.mixin.accessor.EntityTrackerAccessor;
import cc.thonly.reverie_dreams.mixin.accessor.ServerChunkLoadingManagerAccessor;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.NPCStates;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponents;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.registry.content.skin.MobSkinTypes;
import cc.thonly.reverie_dreams.util.item.ItemUtils;
import com.google.common.collect.ImmutableList;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import eu.pb4.polymer.core.api.entity.PolymerEntity;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_10192;
import net.minecraft.class_10264;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1366;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_174;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1781;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3231;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_3898;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_5131;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5455;
import net.minecraft.class_5629;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_8942;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import net.minecraft.world.entity.*;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.Predicate;

@Getter
@Setter
public abstract class BaseNPCLikeEntity extends AbstractNPCEntity implements class_1603, NPCSettings {
    // 皮肤
    protected SkinType skinType = MobSkinTypes.DEFAULT;
    // 实体信息
    protected NPCState npcState = NPCStates.NORMAL;
    protected NPCState lastNpcState = NPCStates.NORMAL;
    protected NPCWorkMode workMode = NPCWorkModes.COMBAT;
    protected boolean sit = false;
    protected String npcOwner = "";
    protected String seatUUID = "";
    protected class_1531 seat;
    protected boolean paused = false;
    // 背包
    protected NPCInventoryImpl inventory = new NPCInventoryImpl(NPCInventoryImpl.MAX_SIZE);
    // 回血
    protected int healthTick = 20;
    protected int maxHealthTick = 20 * 8;
    // 攻击tick
    protected int updateAttackTick = 0;
    protected int maxUpdateAttackTick = 20 * 2 + 1;
    // 饥饿
    protected int nutrition = 20;
    protected int saturation = 20;//饱食
    protected float exhaustionLevel = 0;//消耗
    protected int hungerTick = 20;
    // 经验
    protected int storedExperience = 0;
    // 好感度
    protected int goodwill = 100;
    // 工作
    protected class_2338 workingPos = new class_2338(0, 0, 0);
    protected int workTick = 0;
    // 睡眠
    protected int bedWakeCd = 0;
    protected class_243 prevPos;
    protected int freshTick = 0;
    // 其他
    protected boolean autoPick = false;
    public static final HashSet<class_1792> ARROW_ITEMS = new HashSet<>();

    static {
        ARROW_ITEMS.add(class_1802.field_8107);
        ARROW_ITEMS.add(class_1802.field_8087);
        ARROW_ITEMS.add(class_1802.field_8236);
    }

    private final NPCBowAttackGoal<BaseNPCLikeEntity> bowAttackGoal = new NPCBowAttackGoal<>(this, 1.0, 20, 15.0f);
    private final NPCCrossbowAttackGoal crossBowAttackGoal = new NPCCrossbowAttackGoal(this, 1.0, 20);
    private final NPCDanmakuItemGoal<BaseNPCLikeEntity> danmakuItemGoal = new NPCDanmakuItemGoal<>(this, 1.0, 20, 15.0f);

    private final class_1366 meleeAttackGoal = new class_1366(this, 1.5, false) {
        @Override
        public void method_6270() {
            super.method_6270();
            BaseNPCLikeEntity.this.method_19540(false);
        }

        @Override
        public void method_6269() {
            super.method_6269();
            BaseNPCLikeEntity.this.method_19540(true);
        }
    };
    private static final ImmutableList<class_4140<?>> MEMORY_MODULES = ImmutableList.of(class_4140.field_26389, class_4140.field_19007);
    private static final ImmutableList<class_4149<? extends class_4148<? super BaseNPCLikeEntity>>> SENSORS = ImmutableList.of();

    public BaseNPCLikeEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
        this.init();
        this.updateAttackType();
    }

    public BaseNPCLikeEntity(class_1299<? extends class_1321> entityType, class_1937 world, SkinType skinType) {
        this(entityType, world);
        this.skinType = skinType;
    }

    protected class_4095.class_5303<BaseNPCLikeEntity> method_28306() {
        return class_4095.method_28311(MEMORY_MODULES, SENSORS);
    }

    public void init() {
        class_5131 attributeContainer = this.method_6127();
        if (attributeContainer != null) {
            class_1324 scale = attributeContainer.method_45329(class_5134.field_47760);
            if (scale != null) {
                scale.method_6192(0.9);
            }
        }
        this.method_5875(false);
        this.method_5952(true);
        this.method_6173(false, false);
        this.method_5952(true);

        this.method_5941(class_7.field_9, 16.0f);
        this.method_5941(class_7.field_3, -1.0f);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
    }

    @Override
    public void method_5749(class_11368 view) {
        super.method_5749(view);
        class_5455 registryManager = this.method_56673();

        this.sit = view.method_71433("IsSit", false);

        this.npcState = NPCStates.get(class_2960.method_60654(view.method_71428("NPCStateId", NPCState.DEFAULT_ID.toString())));
        this.workMode = NPCWorkModes.get(class_2960.method_60654(view.method_71428("NPCWorkStateId", NPCWorkMode.DEFAULT_ID.toString())));
        this.npcOwner = view.method_71428("NpcOwner", "");

        NPCInventoryImpl inventory = new NPCInventoryImpl(NPCInventoryImpl.MAX_SIZE);
        class_1262.method_5429(view, inventory.field_5828);

        view.method_71433("AutoPick", false);

        this.inventory = inventory;

        this.seatUUID = view.method_71428("SeatUUID", "null");

        this.nutrition = view.method_71424("FoodNutrition", 20);
        this.saturation = view.method_71424("FoodSaturation", 20);

        this.exhaustionLevel = view.method_71424("FoodExhaustionLevel", 0);
        Optional<Long> workingPosOptional = view.method_71440("WorkingPos");
        this.workingPos = workingPosOptional
                .map(class_2338::method_10092)
                .orElseGet(() -> class_2338.method_10092(new class_2338(0, 0, 0).method_10063()));

        this.storedExperience = view.method_71424("ExperienceAmount", 0);
        this.goodwill = view.method_71424("GoodWIll", 100);

        this.readSkinData(view);

        this.updateAttackType();
    }

    @Override
    protected void method_5652(class_11372 view) {
        super.method_5652(view);
        view.method_71472("IsSit", this.sit);
        view.method_71469("NpcOwner", this.npcOwner);
        view.method_71469("NPCStateId", Optional.ofNullable(RegistryHandlers.NPC_STATE.method_10221(this.npcState)).orElse(NPCState.DEFAULT_ID).toString());
        view.method_71469("NPCWorkStateId", Optional.ofNullable(RegistryHandlers.NPC_WORK_MODE.method_10221(this.workMode)).orElse(NPCWorkMode.DEFAULT_ID).toString());
        view.method_71464("FoodNutrition", this.nutrition);
        view.method_71464("FoodSaturation", this.saturation);
        view.method_71464("FoodExhaustionLevel", this.exhaustionLevel);

        class_1262.method_5426(view, this.inventory.field_5828);

        view.method_71466("WorkingPos", this.workingPos.method_10063());

        view.method_71472("AutoPick", this.autoPick);

        if (!this.seatUUID.isEmpty() && !this.seatUUID.equals("null")) {
            view.method_71469("SeatUUID", this.seatUUID);
        }

        view.method_71465("ExperienceAmount", this.storedExperience);
        view.method_71465("GoodWill", this.goodwill);
        this.writeSkinData(view);
    }

    public void writeSkinData(class_11372 view) {
        RegistryHandlers.SKIN_TYPE.method_10221(this.skinType);
        view.method_71468("Skin", SkinType.CODEC, this.skinType);
    }

    public void readSkinData(class_11368 view) {
        view.method_71426("Skin", SkinType.CODEC).ifPresent(value -> {
            this.skinType = value;
        });
    }

    @Override
    public void method_18400() {
        super.method_18400();
        this.bedWakeCd = 20 * 5;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
    }

    public void addExperience(int xp) {
        this.storedExperience += xp;
    }

    @Override
    public class_1799 method_18808(class_1799 stack) {
        if (stack.method_7909() instanceof class_1811) {
            Predicate<class_1799> predicate = ((class_1811) stack.method_7909()).method_20310();
            class_1799 itemStack = class_1811.method_18815(this, predicate);
            return itemStack.method_7960() ? new class_1799(class_1802.field_8107) : itemStack;
        }
        return class_1799.field_8037;
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        class_1799 itemStack = this.method_5998(class_1675.method_18812(this,
                this.inventory.findHand((stack -> stack.method_31574(class_1802.field_8102) || stack.method_7909() instanceof class_1753)) != null ? class_1802.field_8102 : class_1802.field_8399));
//        ItemStack itemStack2 = this.getProjectileType(itemStack);

        if (itemStack.method_7909() instanceof class_1764) {
            class_9278 chargedProjectilesComponent = itemStack.method_57379(class_9334.field_49649, class_9278.field_49298);
            if (chargedProjectilesComponent != null) {
                for (class_1799 projStack : chargedProjectilesComponent.method_57437()) {
                    class_1676 projectile = this.createArrowProjectile(projStack, 3.15f, itemStack);
                    shoot(target, projStack, projectile);
                    shoot(target, projStack, projectile);
                }
            }
//            shoot(this,3.15f);
            //CrossBowItem L86 玩家射箭的箭矢速度
            return;
        } else {
            class_1799 arrow = RangedAttackUtil.getArrowStack(this);
            if (arrow != null) {
                class_1676 projectile = this.createArrowProjectile(arrow, pullProgress, itemStack);
                arrow.method_7934(1);
                shoot(target, arrow, projectile);
            }
        }


    }

    private void shoot(class_1297 target, class_1799 arrow, class_1676 arrowEntity) {
//        ItemStack arrow = RangedAttackUtil.getArrowStack(this);
//        if (arrow==null)return;

        //PersistentProjectileEntity persistentProjectileEntity = this.createArrowProjectile(arrow, pullProgress, itemStack);
        double d = target.method_23317() - this.method_23317();
        double e = target.method_23323(0.3333333333333333) - arrowEntity.method_23318();
        double f = target.method_23321() - this.method_23321();
        double g = Math.sqrt(d * d + f * f);
        class_1937 world = this.method_37908();
        if (world instanceof class_3218 serverWorld) {
            class_1676.method_61552(arrowEntity, serverWorld, arrow, d, e + g * (double) 0.2f, f, 1.6f, 14 - serverWorld.method_8407().method_5461() * 4);
        }
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
    }


    protected class_1676 createArrowProjectile(class_1799 arrow, float damageModifier, @Nullable class_1799 shotFrom) {
        if (arrow.method_7909() instanceof class_1781)
            return new class_1671(this.method_37908(), arrow, this, this.method_23317(), this.method_23320() - 0.15F, this.method_23321(), true);
        return class_1675.method_18813(this, arrow, damageModifier, shotFrom);
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        super.method_6078(damageSource);
        class_1937 world = this.method_37908();
        if (this.storedExperience > 0) {
            class_1303 orbEntity = new class_1303(world, this.method_19538(), this.method_18798(), this.storedExperience);
            world.method_8649(orbEntity);
        }
        KeepInventoryTypes keepInventoryType = this.getKeepInventoryType();
        if (keepInventoryType == KeepInventoryTypes.ARCHIVED) {
            class_1799 archive = this.toArchive();
            class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), archive);
            world.method_8649(itemEntity);
        } else if (keepInventoryType == KeepInventoryTypes.DROP_ALL_ITEM) {
            for (int i = 0; i < this.inventory.method_5439(); i++) {
                if (this.getDonDropSlotIndex().contains(i)) continue;
                class_1799 copiedStack = this.inventory.method_5438(i).method_7972();
                class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), copiedStack);
                world.method_8649(itemEntity);
            }
            List<class_1799> stacks = List.of(
                    this.inventory.getHead(),
                    this.inventory.getChest(),
                    this.inventory.getLegs(),
                    this.inventory.getFeet()
            );
            for (class_1799 stack : stacks) {
                class_1799 copiedStack = stack.method_7972();
                class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), copiedStack);
                world.method_8649(itemEntity);
            }
        } else if (keepInventoryType == KeepInventoryTypes.ONLY_HAND_AND_ARMOR) {
            List<class_1799> stacks = List.of(
                    this.inventory.getMainHand(),
                    this.inventory.getOffHand(),
                    this.inventory.getHead(),
                    this.inventory.getChest(),
                    this.inventory.getLegs(),
                    this.inventory.getFeet()
            );
            for (class_1799 stack : stacks) {
                class_1799 copiedStack = stack.method_7972();
                class_1542 itemEntity = new class_1542(world, this.method_23317(), this.method_23318(), this.method_23321(), copiedStack);
                world.method_8649(itemEntity);
            }
        }
//        System.out.println("death");
    }

    @Override
    protected void method_16080(class_3218 serverLevel, class_1282 damageSource) {
        if (this.getKeepInventoryType() != KeepInventoryTypes.NOT_DROP_ANY) {
            super.method_16080(serverLevel, damageSource);
        }
    }

    @Override
    public @Nullable class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        var world = this.method_37908();
        if (!world.method_8608() && world instanceof class_3218 serverWorld && player instanceof class_3222 serverPlayerEntity) {

        }

        return super.method_5992(player, hand);
    }

    //    @Override
    public void setOwnerUuid(@Nullable UUID uuid) {
        if (uuid != null) {
            this.npcOwner = uuid.toString();
            this.method_6173(true, true);
        }
    }

    @Override
    public void method_6174(class_1309 player) {
        if (player != null) {
            this.npcOwner = player.method_5667().toString();
        }
        this.method_6173(true, true);
        if (player instanceof class_3222 serverPlayerEntity) {
            class_174.field_1201.method_9132(serverPlayerEntity, this);
        }
    }

    @Override
    public boolean method_6171(class_1309 entity) {
        return entity.method_5667().toString().equalsIgnoreCase(this.npcOwner);
    }

    @Override
    public boolean method_5936() {
        return this.canPickItem();
    }

    @Override
    public void method_6007() {
        class_1937 world = this.method_37908();
//        long start = System.nanoTime();
        if (world instanceof class_3218 serverWorld) {
            if (this.method_6113()) return;
            if (this.method_5936() && this.method_5805()) {
                class_2382 vec3i = this.method_42646();
                List<class_1542> list = this.method_37908().method_18467(class_1542.class, this.method_5829().method_1009(vec3i.method_10263(), vec3i.method_10264(), vec3i.method_10260()));
                for (class_1542 itemEntity : list) {
                    if (itemEntity.method_31481() || itemEntity.method_6983().method_7960() || itemEntity.method_6977() || !this.method_20820(serverWorld, itemEntity.method_6983()))
                        continue;
                    this.method_5949(serverWorld, itemEntity);
                }
            }
            this.field_6037 = true;
        }
        super.method_6007();
        if (this.freshTick >= 1) {
            if (this.method_37908() instanceof class_3218 serverWorld) {
                class_3898.class_3208 tracker = ((ServerChunkLoadingManagerAccessor) serverWorld.method_14178().field_17254).getEntityTrackerMap().get(this.method_5628());
                if (tracker != null) {
                    Set<class_5629> listeners = ((EntityTrackerAccessor) tracker).getListenerSet();
                    for (var handler : listeners) {
                        class_3222 player = handler.method_32311();
                        if (!player.method_14239() && player.method_5805()) {
                            class_3231 entry = ((EntityTrackerAccessor) tracker).getTrackEntry();
                            entry.method_18757(handler.method_32311(), packets -> {
                                entry.method_14306();
                                entry.method_18758(class_10264.method_64558(this));
                            });
                        }
                    }
                }
            }
            this.freshTick = 0;
        } else {
            this.freshTick++;
        }
//
//        long end = System.nanoTime();
//        long duration = end - start; // 纳秒
//        System.out.println("耗时: " + (duration / 1_000_000) + " ms");
    }

    @Override
    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
    }

    @Override
    public void method_5837(class_3222 player) {
        super.method_5837(player);
        PolymerEntity polymerEntity = PolymerEntity.get(this);
        if (polymerEntity instanceof PlayerPolymerEntity playerPolymerEntity) {
            playerPolymerEntity.onCreated();
        }
    }

    @Override
    public void method_5742(class_3222 player) {
        super.method_5742(player);
        PolymerEntity polymerEntity = PolymerEntity.get(this);
        if (polymerEntity instanceof PlayerPolymerEntity playerPolymerEntity) {
            playerPolymerEntity.onTrackingStopped(player);
        }
    }

    @Override
    protected void method_5949(class_3218 world, class_1542 itemEntity) {
        class_1799 itemStack = itemEntity.method_6983();
        if (this.inventory.method_27070(itemStack)) {
            if (ItemUtils.isArmorItem(itemStack)) {
                class_10192 equippableComponent = itemStack.method_58694(class_9334.field_54196);
                if (equippableComponent != null) {
                    boolean head = equippableComponent.comp_3174() == class_1304.field_6169;
                    boolean chest = equippableComponent.comp_3174() == class_1304.field_6174;
                    boolean legs = equippableComponent.comp_3174() == class_1304.field_6172;
                    boolean feet = equippableComponent.comp_3174() == class_1304.field_6166;
                    if (head && this.inventory.getHead().method_7960()) {
                        this.inventory.setHead(itemStack.method_7972());
                    } else if (chest && this.inventory.getChest().method_7960()) {
                        this.inventory.setChest(itemStack.method_7972());
                    } else if (legs && this.inventory.getLegs().method_7960()) {
                        this.inventory.setLegs(itemStack.method_7972());
                    } else if (feet && this.inventory.getFeet().method_7960()) {
                        this.inventory.setFeet(itemStack.method_7972());
                    } else {
                        this.inventory.method_5491(itemStack.method_7972());
                    }
                } else {
                    this.inventory.method_5491(itemStack.method_7972());
                }
            } else if ((itemStack.method_7909() instanceof class_1819) || (itemStack.method_7909() == class_1802.field_8810)) {
                if (this.inventory.getOffHand().method_7960()) {
                    this.inventory.setOffHand(itemStack.method_7972());
                } else {
                    this.inventory.method_5491(itemStack.method_7972());
                }
            } else {
                if (this.inventory.getMainHand().method_7960()) {
                    this.inventory.setMainHand(itemStack.method_7972());
                } else {
                    this.inventory.method_5491(itemStack.method_7972());
                }
            }
            itemEntity.method_31472();
        }
    }

    protected void updateHealth() {
        if (this.method_37908().field_9236) return;
        if (this.method_6032() < this.method_6063()) {
            this.healthTick--;
        } else {
//            this.healthTick = 10;
        }
        if (this.consumeHunger() && this.method_6032() < this.method_6063() && this.healthTick <= 0) {
            if (this.method_29504()) return;
            if (this.nutrition == 20 && this.saturation > 1) {
                this.method_6033(method_6032() + Math.min(1, saturation / 6));
                this.healthTick = 10;
                this.exhaustionLevel += 6;
            } else if (nutrition >= 18) {
                this.method_6033(method_6032() + 1);
                this.healthTick = 80;
                this.exhaustionLevel += 6;
            } else if (nutrition == 0 && this.method_6032() > this.method_6063() / 2) {
                this.method_64397((class_3218) this.method_37908(), this.method_48923().method_48825(), 1);
                this.healthTick = 80;
            }
        }
    }

    private void updateHunger() {
        if (this.consumeHunger()) {
            nutrition = Math.clamp(this.nutrition, 0, 20);
            saturation = Math.clamp(this.saturation, 0, this.nutrition);
            if (exhaustionLevel >= 4) {
                if (this.saturation > 0) {
                    this.saturation--;
                    this.exhaustionLevel = 0;
                } else if (this.nutrition > 0) {
                    this.nutrition--;
                    this.exhaustionLevel = 0;
                }
            }
        }
    }

    private void updateHungerConsumption() {
        this.hungerTick--;
        if (hungerTick <= 0) {
            hungerTick = 20;
            int hungerEffectLevel = 0;
            class_1293 hungerEff = this.method_6112(class_1294.field_5903);
            if (hungerEff != null) {
                hungerEffectLevel = hungerEff.method_5578();
                // System.out.println("饥饿消耗 "+ hungerEffectLevel);
            }
            this.exhaustionLevel += (float) (hungerEffectLevel * 0.1);
            if (this.method_5942().method_23966()) {
                this.exhaustionLevel += 0.015F;//无法检测具体行为 按0.015计算 略微提高消耗
                // System.out.println("寻路增加消耗");
            }
        }


    }


    protected void updateAttackType() {
        if (this.method_37908() == null || this.method_37908().field_9236) {
            return;
        }
        this.field_6201.method_6280(this.meleeAttackGoal);
        this.field_6201.method_6280(this.bowAttackGoal);
        this.field_6201.method_6280(this.crossBowAttackGoal);
        this.field_6201.method_6280(this.danmakuItemGoal);
//        ItemStack itemStack = this.getMainHandStack();

        if (RangedAttackUtil.getArrowStack(this) != null && (this.inventory.findHand((stack -> stack.method_31574(class_1802.field_8102) || stack.method_7909() instanceof class_1753)) != null)) {
            int i = this.getRegularAttackInterval();
            this.bowAttackGoal.setAttackInterval(i);
            this.field_6201.method_6277(4, this.bowAttackGoal);
        } else if (RangedAttackUtil.getCrossBowAmmoStack(this) != null && (this.inventory.findHand((stack -> stack.method_31574(class_1802.field_8399) || stack.method_7909() instanceof class_1764)) != null)) {
            this.field_6201.method_6277(4, this.crossBowAttackGoal);
        } else if (RangedAttackUtil.isDanmakuInHand(this)) {
            this.field_6201.method_6277(4, this.danmakuItemGoal);
        } else {
            this.field_6201.method_6277(4, this.meleeAttackGoal);
        }
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 initialize = super.method_5943(world, difficulty, spawnReason, entityData);
        this.updateAttackType();
        return initialize;
    }

    protected int getHardAttackInterval() {
        return 20;
    }

    protected int getRegularAttackInterval() {
        return 40;
    }

    public NPCState getNextState() {
        if (this.method_6113()) return this.npcState;
        int rawId = RegistryHandlers.NPC_STATE.method_10206(this.npcState);
        NPCState next = NPCStates.fromInt(rawId + 1);
        return next != null ? next : NPCStates.fromInt(0);
    }

    public NPCState getPreviousState() {
        if (this.method_6113()) return this.npcState;
        int rawId = RegistryHandlers.NPC_STATE.method_10206(this.npcState);
        NPCState next = NPCStates.fromInt(rawId - 1);
        Map<Integer, class_6880.class_6883<NPCState>> rawToEntry = RegistryHandlers.NPC_STATE.getIdToEntryMap();
        int maxKey = Collections.max(rawToEntry.keySet());
        return next != null ? next : NPCStates.fromInt(maxKey);
    }

    public void reduceHunger(float value) {
        float remaining = value;

        while (remaining > 0.0f) {
            if (this.saturation > 0.0f) {
                float delta = Math.min(0.5f, Math.min(this.saturation, remaining));
                this.saturation -= delta;
                remaining -= delta;
            } else if (this.nutrition > 0.0f) {
                float delta = Math.min(0.5f, Math.min(this.nutrition, remaining));
                this.nutrition -= delta;
                remaining -= delta;
            } else {
                break;
            }
        }
    }

    public void updateWorking() {
        if (this.npcState != this.lastNpcState && this.npcState == NPCStates.WORKING) {
            this.workingPos = new class_2338(this.method_31477(), (int) Math.round(this.method_23318()), this.method_31479());
        }

        if (this.npcState == NPCStates.WORKING && this.workTick < 20) {
            this.workTick++;
        } else {
            this.workTick = 0;
        }
        if (this.npcState == NPCStates.WORKING && this.workTick >= 20) {
            this.workTick = 0;
            class_2338 blockPos = this.method_24515();
            if (this.workingPos != null) {
                double distance = blockPos.method_10262(this.workingPos);

                if (distance > 8 * 8) {
                    boolean success = this.method_5942().method_6337(
                            this.workingPos.method_10263() + 0.5,
                            this.workingPos.method_10264(),
                            this.workingPos.method_10260() + 0.5,
                            1.0D
                    );
                }
            }
        }
    }

    public void updateName() {
        this.method_5880(this.method_16914());
    }

    public void fixPitchYaw() {
        float delta = Math.abs(this.field_6283 - this.method_36454());
        if (delta > 20.0f) {
            this.method_5636(this.method_36454());
        }
    }

    @Override
    public void method_5773() {
        class_1937 world = this.method_37908();
        this.updateHealth();
        this.updateHunger();
        this.updateHungerConsumption();
        this.updateWorking();
        this.updateName();
        this.fixPitchYaw();
        this.updateAttackTick++;
        if (this.updateAttackTick > this.maxUpdateAttackTick) {
            this.updateAttackType();
            this.updateAttackTick = 0;
        }
        this.prevPos = this.method_19538();

        if (this.npcState == NPCStates.SNAKING) {
            this.method_5942().method_6340();
            if (this.method_18376() != class_4050.field_18081) {
                this.method_18380(class_4050.field_18081);
            }
            super.method_5773();
            return;
        }

        if (this.npcState == NPCStates.SEATED) {
            if (this.seat == null) {
                List<class_1531> list = world.method_8390(
                                class_1531.class,
                                new class_238(this.method_23317() + 1, this.method_23318() + 1, this.method_23321() + 1, this.method_23317() - 1, this.method_23318() - 1, this.method_23321() - 1),
                                entity -> true)
                        .stream()
                        .filter(entity -> entity.method_5667().toString().equalsIgnoreCase(this.seatUUID))
                        .toList();
                if (!list.isEmpty()) {
                    this.seat = list.getFirst();
                } else {
                    spawnSeatAndSit();
                }
            }
            this.setSit(true);
            return;
        } else {
            if (this.seat != null) {
                this.seat.method_31472();
                this.seatUUID = "";
                this.seat = null;
            }
            this.setSit(false);
        }
        if (this.method_18376() == class_4050.field_18081) {
            this.method_18380(class_4050.field_18076);
        }
        this.lastNpcState = this.npcState;
        super.method_5773();
    }

    private void spawnSeatAndSit() {
        class_1531 as = class_1299.field_6131.method_5883(this.method_37908(), class_3730.field_16461);
        if (as == null) return;

        as.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        as.method_5648(true);
        as.method_5875(true);
        as.method_6902(true);
        this.method_37908().method_8649(as);

        this.seat = as;
        this.seatUUID = this.seat.method_5667().toString();
        this.method_5873(as, true);
    }


    @Override
    public float method_6029() {
        if (this.npcState == NPCStates.NO_WALK || this.npcState == NPCStates.SNAKING) return 0;
        if (this.paused) return 0;
        return super.method_6029();
    }

    @Override
    public boolean method_6481(class_1799 stack) {
        return false;
    }

    @Override
    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        if (this.method_29504()) {
            return false;
        }
        return super.method_64397(world, source, amount);
    }

    @Override
    public void method_6105(class_1282 source, float amount) {
        if (this.canDamageEquipment()) {
            this.method_57292(source, amount, class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169);
        }
    }

    @Override
    public void method_36977(class_1282 source, float amount) {
        if (this.canDamageEquipment()) {
            this.method_57292(source, amount, class_1304.field_6169);
        }
    }

    @Override
    public boolean method_6121(class_3218 world, class_1297 target) {
        boolean result = super.method_6121(world, target);
        if (result) {
            class_1799 mainHand = this.method_6047();
            if (mainHand.method_7963()) {
                mainHand.method_71012(1, (class_1309) this, (class_1268) null);
            }
        }
        return result;
    }

    public class_1799 toArchive() {
        class_1799 itemStack = RDItems.ROLE_ARCHIVE.method_7854();
        class_2487 nbtCompound;
        try (class_8942.class_11340 logging = new class_8942.class_11340(this.method_71370(), LogUtils.getLogger())) {
            class_11362 view = class_11362.method_71459(logging, this.method_56673());
            this.method_5652(view);
            nbtCompound = view.method_71475();
        }
        class_5250 mutableComponent = class_2561.method_43473();
        mutableComponent.method_10852(itemStack.method_63693()).method_27693("(").method_10852(this.method_5477()).method_27693(")");
        itemStack.method_57379(RDDataComponents.ROLE_FOLLOWER_ARCHIVE, new RoleFollowerArchive(this.method_5477(), this.method_6063(), nbtCompound));
        itemStack.method_57379(RDDataComponents.ROLE_CAN_RESPAWN, false);
        return itemStack;
    }

    //    @Override
    public Iterable<class_1799> getArmorItems() {
        return List.of(
                this.method_6118(class_1304.field_6169),
                this.method_6118(class_1304.field_6174),
                this.method_6118(class_1304.field_6172),
                this.method_6118(class_1304.field_6166)
        );
    }

    @Override
    public class_1799 method_6047() {
        class_1799 stack = this.inventory.method_5438(NPCInventoryImpl.MAIN_HAND);
        if (stack.method_7960()) return super.method_6047();
        return stack;
    }

    @Override
    public class_1799 method_6079() {
        class_1799 stack = this.inventory.method_5438(NPCInventoryImpl.OFF_HAND);
        if (stack.method_7960()) return super.method_6079();
        return stack;
    }

    @Override
    public class_1799 method_6118(class_1304 slot) {
        if (slot == class_1304.field_6169) {
            return this.inventory.getHead();
        } else if (slot == class_1304.field_6174) {
            return this.inventory.getChest();
        } else if (slot == class_1304.field_6172) {
            return this.inventory.getLegs();
        } else if (slot == class_1304.field_6166) {
            return this.inventory.getFeet();
        } else if (slot == class_1304.field_6173) {
            return this.inventory.method_5438(NPCInventoryImpl.MAIN_HAND);
        } else if (slot == class_1304.field_6171) {
            return this.inventory.method_5438(NPCInventoryImpl.OFF_HAND);
        }
        return super.method_6118(slot);
    }

    @Override
    public void method_5673(class_1304 slot, class_1799 stack) {
        super.method_5673(slot, stack);
        int idx = switch (slot) {
            case field_6173 -> NPCInventoryImpl.MAIN_HAND;
            case field_6171 -> NPCInventoryImpl.OFF_HAND;
            case field_6169 -> -11;
            case field_6174 -> -12;
            case field_6172 -> -13;
            case field_6166 -> -14;
            default -> -1;
        };
        if (idx >= 0) this.inventory.method_5447(idx, stack);
        if (-14 <= idx && idx <= -11) {
            if (idx == -11) {
                this.inventory.setHead(stack);
            }
            if (idx == -12) {
                this.inventory.setChest(stack);
            }
            if (idx == -13) {
                this.inventory.setLegs(stack);
            }
            if (idx == -14) {
                this.inventory.setFeet(stack);
            }
        }
        if (!this.method_37908().field_9236) {
            this.updateAttackType();
        }
    }

    @Override
    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public static class_5132 createAttributes() {
        return class_1309.method_26827()
                .method_26868(class_5134.field_23716, 20.0)
                .method_26868(class_5134.field_23719, 0.25)
                .method_26868(class_5134.field_23721, 1.0)
                .method_26868(class_5134.field_23718, 0.1)
                .method_26868(class_5134.field_23717, 32.0)
                .method_26868(class_5134.field_52450, 10.0)
                .method_26868(class_5134.field_47759, 3)
                .method_26866();
    }

    public boolean isOwner(class_1297 player) {
        return this.method_35057() == player;
    }

    public boolean isAllowOpenInventory(class_3222 player) {
        return ((this.method_6171(player) || (player.method_68878())) && this.method_6181());
    }
    //return entity.getUuid().toString().equalsIgnoreCase(this.npcOwner);

    @Override
    public @Nullable class_1309 method_35057() {
        if (this.npcOwner.equalsIgnoreCase("")) return null;
//        for (int i = 0; i < this.getWorld().getPlayers().size(); i++) {
//            PlayerEntity playerEntity = (PlayerEntity)this.getWorld().getPlayers().get(i);
//            if (playerEntity.getUuid().toString().equalsIgnoreCase(this.npcOwner))
//                return playerEntity;
//        }
        return this.method_37908().method_18470(UUID.fromString(this.npcOwner));
//        return null;
    }

    //    @Override
    public @Nullable UUID getOwnerUuid() {
        if (this.npcOwner.equalsIgnoreCase("")) return null;
        return UUID.fromString(this.npcOwner);
    }

    @Override
    public boolean method_24345() {
        return this.isSit();
    }

    @Override
    public boolean method_6181() {
        return this.getOwnerUuid() != null;
    }

    @Override
    public Property getSkin() {
        return this.skinType.get();
    }

}
