package cc.thonly.reverie_dreams.entity.npc;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.npc.NPCRoleInteractionEvent;
import cc.thonly.reverie_dreams.gui.NPCGui;
import cc.thonly.reverie_dreams.inf.IItemStack;
import cc.thonly.reverie_dreams.item.base.DrinkItem;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_10131;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5131;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Slf4j
public class NPCRoleInteractionEvents {
    public static final List<NPCRoleMessage> MESSAGES = new ArrayList<>();

    static {
        registerMessage(class_2561.method_43471("npc.event.send_message.0"));
        registerMessage(class_2561.method_43471("npc.event.send_message.1"));
        registerMessage(class_2561.method_43471("npc.event.send_message.2"));
        registerMessage(class_2561.method_43471("npc.event.send_message.3"));
        registerMessage(class_2561.method_43471("npc.event.send_message.4"));
        registerMessage(class_2561.method_43471("npc.event.send_message.5"));
        registerMessage(class_2561.method_43471("npc.event.send_message.6"));
        registerMessage(class_2561.method_43471("npc.event.send_message.7"));
        registerMessage(class_2561.method_43471("npc.event.send_message.8"));
        registerMessage(class_2561.method_43471("npc.event.send_message.9"));
    }

    public static final NPCRoleInteractionEvent MESSAGE = registerEvent("message", (world, player, stack, hand, entity) -> {
        if (stack.method_7960() && !player.method_5715() && entity.method_6181()) {
            if (MESSAGES.isEmpty()) {
                return NPCInteractResult.PASS;
            }
            class_5819 random = class_5819.method_43047();
            NPCRoleMessage npcRoleMessage = MESSAGES.get(random.method_39332(0, MESSAGES.size() - 1));
            class_5250 message = npcRoleMessage.getMessage(world, player, stack, hand, entity);
            class_5250 body = class_2561.method_43473();
            body.method_10852(entity.method_5477());
            body.method_27693(": ");
            body.method_10852(message);
            Optional.ofNullable(npcRoleMessage.getSoundEvent()).ifPresent(
                    (soundEvent) -> {
                        world.method_54762(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), soundEvent, class_3419.field_15251);
                    }
            );
            player.method_7353(body, false);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent ON_OPEN_INVENTORY = registerEvent("on_open_inventory", (world, player, stack, hand, entity) -> {
        if (stack.method_7960() && entity.isAllowOpenInventory(player) && player.method_5715()) {
            NPCGui npcGui = new NPCGui(player, entity);
            npcGui.open();
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent ON_UPGRADED_HEALTH = registerEvent("on_upgraded_health", (world, player, stack, hand, entity) -> {
        if (!entity.method_6171(player)) {
            return NPCInteractResult.PASS;
        }
        if (stack.method_7909() == RDItems.UPGRADED_HEALTH) {
            class_5131 attributes = entity.method_6127();
            class_1324 max_health = attributes.method_45329(class_5134.field_23716);
            float health = entity.method_6032();
            float maxHealth = entity.method_6063();
            if (max_health != null) {
                max_health.method_6192(maxHealth + 2);
                entity.method_6033(health + 2);
            }
            player.method_6104(hand);
            player.method_5783(SoundEventInit.UP, 1.0f, 1.0f);
            stack.method_57008(1, player);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent ON_TAME = registerEvent("on_tame", (world, player, stack, hand, entity) -> {
        if (entity.npcOwner.isEmpty() && stack.method_31573(RDItemTags.ROLE_TAME_FOOD)) {
            class_5819 random = class_5819.method_43047();
            float chance = random.method_43057();
            if (chance <= 0.4) {
                entity.method_6174(player);
                entity.method_6173(true, true);
                world.method_65096(class_2398.field_11201, entity.method_23317(), entity.method_23318() + 1.0, entity.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
            }
            entity.method_6033(entity.method_6032() + 5);
            stack.method_57008(1, player);
            player.method_6104(hand);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent ON_FEED_POTIONS = registerEvent("on_feed_potions", (world, player, stack, hand, entity) -> {
        if (!entity.method_6171(player)) {
            return NPCInteractResult.PASS;
        }
        if (stack.method_7960()) {
            return NPCInteractResult.PASS;
        }
        if (entity.canFeed() && (stack.method_7909() == class_1802.field_8574 || stack.method_7909() instanceof DrinkItem drinkItem)) {
            class_10131 useRemainderComponent = stack.method_58694(class_9334.field_53965);
            entity.method_5783(class_3417.field_20613.comp_349(), 1.0f, 1.0f);
            class_1799 result = stack.method_7910(world, entity);
            if (!player.method_56992()) {
                player.method_6122(hand, result);
            }
            if (useRemainderComponent != null && !player.method_56992()) {
                class_1799 itemStack = useRemainderComponent.method_62863(stack, stack.method_7947(), player.method_56992(), player::method_64399);
                player.method_6122(hand, itemStack);
            }
            player.method_6104(hand);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent ON_FEED_FOOD = registerEvent("_feed_food", (world, player, stack, hand, entity) -> {
        if (!entity.method_6171(player)) {
            return NPCInteractResult.PASS;
        }
        if (stack.method_7960()) {
            return NPCInteractResult.PASS;
        }
        if ((((IItemStack) (Object) stack).isFood() || stack.method_31573(RDItemTags.ROLE_TAME_FOOD)) && entity.canFeed()) {
            entity.method_5783(class_3417.field_20614.comp_349(), 1.0f, 1.0f);
            class_1799 result = stack.method_7910(world, entity);
            if (!player.method_56992()) {
                player.method_6122(hand, result);
            }
            player.method_6104(hand);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });
    public static final NPCRoleInteractionEvent SET_OWNER_BY_STICk = registerEvent("set_owner_by_stick", (world, player, stack, hand, entity) -> {
        if (stack.method_7909() == RDItems.OWNER_STICK) {
            entity.method_6174(player);
            return NPCInteractResult.SUCCESS;
        }
        return NPCInteractResult.PASS;
    });

    public static void bootstrap(RegistryHandler<NPCRoleInteractionEvent> registry) {

    }

    public static class_1269 emit(class_3218 world, class_3222 player, class_1268 hand, NPCRoleEntity entity) {
        class_1799 itemStack = player.method_5998(hand);
        for (NPCRoleInteractionEvent event : RegistryHandlers.ROLE_INTERACTION_EVENT) {
            int i = 0;
            NPCInteractResult interact = null;
            try {
                i++;
                interact = event.interact(world, player, itemStack, hand, entity);
                if (interact == NPCInteractResult.PASS) {
                    continue;
                }
                return switch (interact) {
                    case SUCCESS -> class_1269.field_52422;
                    case FAIL -> class_1269.field_5814;
                    default -> throw new IllegalStateException("Unexpected value: " + interact);
                };
            } catch (Exception err) {
                log.error("Role Interaction event {} triggering failed", interact != null ? interact.name() : i, err);
            }
        }
        return class_1269.field_21466;
    }

    public static NPCRoleMessage registerMessage(class_5250 mutableText) {
        NPCRoleMessage npcRoleMessage = new NPCRoleMessage() {
            @Override
            public @NotNull class_5250 getMessage(class_3218 world, class_3222 player, class_1799 stack, class_1268 hand, BaseNPCLikeEntity entity) {
                return mutableText;
            }

            @Override
            public class_2960 getId() {
                return ReverieDreams.id("message/%s".formatted(MESSAGES.size()));
            }
        };
        MESSAGES.add(npcRoleMessage);
        return npcRoleMessage;
    }

    public static NPCRoleMessage registerMessage(NPCRoleMessage message) {
        MESSAGES.add(message);
        return message;
    }

    public static NPCRoleInteractionEvent registerEvent(String name, NPCRoleInteractionEvent.InteractionCallback callback) {
        return registerEvent(ReverieDreams.id(name), callback);
    }

    public static NPCRoleInteractionEvent registerEvent(class_2960 eventId, NPCRoleInteractionEvent.InteractionCallback callback) {
        NPCRoleInteractionEvent event = new NPCRoleInteractionEvent(callback);
        return RegistryHandlers.registerForBuiltin(RegistryHandlers.ROLE_INTERACTION_EVENT, eventId, event);
    }
}
