package cc.thonly.reverie_dreams.gui.recipe.gui;

import cc.thonly.reverie_dreams.block.entity.DanmakuCraftingTableBlockEntity;
import cc.thonly.reverie_dreams.gui.GuiCommon;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuRecipe;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import cc.thonly.reverie_dreams.util.PredicateSlot;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import lombok.Getter;
import net.minecraft.class_10130;
import net.minecraft.class_1263;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9334;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;

@Getter
public class DanmakuCraftingTableGui extends SimpleGui implements GuiCommon {
    private final DanmakuCraftingTableBlockEntity blockEntity;
    private static final String[] layout = {
            "X#X#X#X#X",
            "####R####",
            "####E####"
    };

    private int resultSlot = -1;

    public DanmakuCraftingTableGui(class_3222 player, class_1937 world, class_2338 pos) {
        super(class_3917.field_17326, player, false);
        this.setTitle(class_2561.method_43471(RDBlocks.DANMAKU_CRAFTING_TABLE.method_63499()));
        this.blockEntity = (DanmakuCraftingTableBlockEntity) world.method_8321(pos);
        this.init();
    }

    @Override
    public void init() {
        class_1263 inventory = this.blockEntity.getInventory();
        int counter = 0;
        int counter2 = 0;
        for (int i = 0; i < layout.length; i++) {
            for (int j = 0; j < layout[i].length(); j++) {
                char c = layout[i].charAt(j);
                if (c == '#') {
                    this.setSlot(counter, new GuiElementBuilder()
                            .setItem(RDGuiItems.EMPTY_SLOT));
                }
                if (c == 'X') {
                    Function<Integer, Function<class_1799, Boolean>> iffib = index -> {
                        return switch (index) {
                            case 0 -> itemStack -> itemStack.method_7909() instanceof class_1769;
                            case 1 -> itemStack -> itemStack.method_7909() == RDItems.DANMAKU_CORE;
                            case 2 -> itemStack -> itemStack.method_7909() == RDItems.POWER;
                            case 3 -> itemStack -> itemStack.method_7909() == RDItems.POINT;
                            case 4 -> itemStack -> itemStack.method_7909() == RDItems.DANMAKU_SHAPE_CREATOR;
                            default -> itemStack -> true;
                        };
                    };
                    this.setSlotRedirect(counter, new PredicateSlot(inventory, counter2, 0, 0, iffib.apply(counter2)));
                    counter2++;
                }
                if (c == 'E') {
                    this.resultSlot = counter;
                    this.setSlot(counter, new GuiElementBuilder()
                            .setItem(class_1802.field_8162)
                    );
                }
                if (c == 'R') {
                    this.setSlot(counter, new GuiElementBuilder()
                            .setItem(RDGuiItems.PROGRESS_TO_RESULT_DOWN)
                    );
                }
                counter++;
            }
        }
    }

    int tick = 0;

    @Override
    public void onTick() {
        super.onTick();
        if (this.blockEntity.method_10997() != null && this.blockEntity.method_10997().method_8320(blockEntity.method_11016()).method_26204() != RDBlocks.DANMAKU_CRAFTING_TABLE) {
            this.close();
            return;
        }

        if (this.resultSlot == -1) {
            return;
        }

        this.tick++;
        if (this.tick > 2) {
            List<ItemStackWrapper> slots = this.getInputs();
            List<DanmakuRecipe> recipeEntries = RecipeManager.DANMAKU_TYPE.getMatches(slots);
            if (!recipeEntries.isEmpty()) {
                DanmakuRecipe recipeEntry = recipeEntries.getFirst();
                ItemStackWrapper resultWrapper = recipeEntry.getOutput().copy();
                class_1799 itemStack = resultWrapper.getItemStack();
                itemStack.method_57379(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))));

                this.setSlot(this.resultSlot, new GuiElementBuilder(itemStack).setCallback(new GuiElementInterface.ItemClickCallback() {
                    @Override
                    public void click(int i, ClickType clickType, net.minecraft.class_1713 slotActionType) {
                        for (ItemStackWrapper countRecipeSlot : List.of(recipeEntry.getDye(), recipeEntry.getCore(), recipeEntry.getPower(), recipeEntry.getPoint(), recipeEntry.getMaterial())) {
                            if (countRecipeSlot.getItem() != class_1802.field_8162) {
                                class_1792 item = countRecipeSlot.getItem();
                                int count = countRecipeSlot.getCount();
                                DanmakuCraftingTableGui.this.blockEntity.getInventory().removeItemType(item, count);
                            }
                        }
                        DanmakuCraftingTableGui.this.player.method_7270(itemStack.method_7972());
                        DanmakuCraftingTableGui.this.setSlot(DanmakuCraftingTableGui.this.resultSlot, new GuiElementBuilder()
                                .setItem(RDGuiItems.PROGRESS_TO_RESULT)
                        );
                    }
                }));
            }
            this.tick = 0;
        }
    }

    private List<ItemStackWrapper> getInputs() {
        List<ItemStackWrapper> countRecipeSlotList = new LinkedList<>();
        for (int i = 0; i < 5; i++) {
            class_1799 itemStack = this.blockEntity.getInventory().getItem(i);
            countRecipeSlotList.add(new ItemStackWrapper(itemStack));
        }
        return countRecipeSlotList;
    }

    @Override
    public void onClose() {
        super.onClose();
        this.blockEntity.method_5431();
    }
}
