package cc.thonly.reverie_dreams.item.base;

import cc.thonly.reverie_dreams.data.DrinkProperty;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponents;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_10128;
import net.minecraft.class_1309;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9334;

public class DrinkItem extends class_1792 {
    public static final Map<class_1792, Set<DrinkProperty>> ITEM_DRINK_CACHED = new HashMap<>();
    public static final Map<class_1792, Integer> PRICE_CALCULATION_TABLE = new Object2ObjectOpenHashMap<>();

    public DrinkItem(class_1793 settings) {
        super(settings.method_7889(16)
                .method_57349(class_9334.field_53964, class_10128.field_53780)
                .method_62834(class_1802.field_8469));
    }

    public DrinkItem(List<DrinkProperty> drinkProperties, class_1793 settings) {
        super(settings.method_7889(16)
                .method_57349(class_9334.field_53964, class_10128.field_53780)
                .method_57349(RDDataComponents.DRINK_PROPERTIES, drinkProperties.stream().map(DrinkProperty::getId).map(class_2960::toString).toList())
                .usingConvertsTo(class_1802.field_8469));
    }

    @Override
    public class_1799 method_7861(class_1799 stack, class_1937 world, class_1309 user) {
        if (!world.field_9236 && world instanceof class_3218 serverWorld) {
            List<DrinkProperty> allProperties = DrinkProperty.getAllProperties(stack);
            for (DrinkProperty property : allProperties) {
                property.use(serverWorld, user);
            }
            if (user instanceof class_3222 player) {
                class_1702 hungerManager = player.method_7344();
                hungerManager.method_7585(1, allProperties.size() % 3);
            }
        }
        return super.method_7861(stack, world, user);
    }

//    @Override
//    public void appendTooltip(ItemStack stack, TooltipContext context, TooltipDisplayComponent displayComponent, Consumer<Text> textConsumer, TooltipType type) {
//        super.appendTooltip(stack, context, displayComponent, textConsumer, type);
//        List<DrinkProperty> allProperties = DrinkProperty.getAllProperties(stack);
//        if (!allProperties.isEmpty()) {
//            textConsumer.accept(Text.empty().append(Text.translatable("item.tooltip.food_properties")));
//        }
//        for (DrinkProperty property : allProperties) {
//            textConsumer.accept(Text.empty().append("§b+").append(Text.translatable(property.translateKey())));
//        }
//    }
}
