package cc.thonly.reverie_dreams.item.base;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.util.IdentifierGetter;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import java.util.ArrayList;
import java.util.List;

@Setter
@Getter
@ToString
public class SpawnEggItem extends net.minecraft.class_1826 implements IdentifierGetter {
    public static final List<class_1792> SPAWN_EGGS = new ArrayList<>(128);
    public static final class_9282 DEFAULT_COLOR = new class_9282(16777215);
    private final class_2960 identifier;
    private long color = -1;

    public SpawnEggItem(String identifier, class_1299<? extends class_1308> type, class_1793 settings) {
        super(type, settings.method_63686(class_5321.method_29179(class_7924.field_41197, ReverieDreams.id(identifier))).method_57349(class_9334.field_49644, DEFAULT_COLOR));
        this.identifier = ReverieDreams.id(identifier);
        SPAWN_EGGS.add(this);
    }

    public SpawnEggItem(class_2960 identifier, class_1299<? extends class_1308> type, class_1793 settings) {
        super(type, settings.method_63686(class_5321.method_29179(class_7924.field_41197, identifier)).method_57349(class_9334.field_49644, DEFAULT_COLOR));
        this.identifier = identifier;
        SPAWN_EGGS.add(this);
    }

    public void setColor(long color) {
        this.color = color;
        class_9282 dyedColorComponent = this.field_49263.method_58695(class_9334.field_49644, new class_9282(16777215));
        dyedColorComponent.comp_2384 = (int) this.color;
    }

    @Override
    public class_1799 method_7854() {
        class_1799 itemStack = super.method_7854();
        if (this.color != -1) {
            itemStack.method_57379(class_9334.field_49644, new class_9282((int) this.color));
        } else {
            itemStack.method_57379(class_9334.field_49644, new class_9282(16777215));
        }
        return itemStack;
    }

    @Override
    public class_1269 method_7884(class_1838 context) {
        super.method_7884(context);
        class_1657 player = context.method_8036();
        class_1937 world = context.method_8045();
        class_1268 hand = context.method_20287();
        if (!world.method_8608() && player instanceof class_3222 serverPlayer) {
            serverPlayer.method_6104(hand);
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }
}
