package cc.thonly.reverie_dreams.item.prop;

import cc.thonly.reverie_dreams.component.GapRecorder;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponents;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class GapBall extends class_1792 {

    public GapBall(class_1793 settings) {
        super(settings);
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608() && user instanceof class_3222 serverPlayerEntity) {
            SimpleGui gapGui = new GapGUI(serverPlayerEntity, stack);
            gapGui.open();
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    public static class GapGUI extends SimpleGui {
        public static final String[][] GRID = {
                {"X", "X", "I", "I", "I", "I", "I", "X", "X"},
                {"X", "X", "A", "A", "A", "A", "A", "X", "X"},
                {"X", "X", "D", "D", "D", "D", "D", "X", "X"},
        };
        public static final int MAX_INDEX = 4;
        public static final int MIN_INDEX = 0;
        private final class_1799 stack;
        private List<GapRecorder> gapRecorders;

        public GapGUI(class_3222 player, class_1799 stack) {
            super(class_3917.field_17326, player, false);
            this.stack = stack;
            this.gapRecorders = new ArrayList<>(stack.method_58695(RDDataComponents.GAP_RECORDER, new ArrayList<>()));
            while (gapRecorders.size() <= MAX_INDEX) {
                this.gapRecorders.add(new GapRecorder("未记录", this.getPlayer().method_51469().method_27983().method_29177().toString(), class_2338.field_10980, false));
            }
            this.init();
        }

        public void init() {
            class_2561 text = this.stack.method_65130() != null ? this.stack.method_65130() : this.stack.method_7964();
            this.setTitle(text);
            for (int row = 0; row < GRID.length; row++) {
                for (int col = 0; col < GRID[row].length; col++) {
                    String pos = GRID[row][col];
                    int slot = row * 9 + col;
                    int index = col - 2;

                    switch (pos) {
                        case "X" -> setSlot(slot, new GuiElementBuilder(RDGuiItems.EMPTY_SLOT));
                        case "I" -> {
                            if (index < MIN_INDEX || index > MAX_INDEX) break;
                            GapRecorder recorder = this.gapRecorders.get(index);
                            setSlot(slot, new GuiElementBuilder(recorder.isEnable() ? class_1802.field_8077 : class_1802.field_8449)
                                    .setName(class_2561.method_43470("传送" + index))
                                    .setCallback(click -> teleport(index)));
                        }
                        case "A" -> {
                            if (index < MIN_INDEX || index > MAX_INDEX) break;
                            setSlot(slot, new GuiElementBuilder(class_1802.field_8733)
                                    .setName(class_2561.method_43470("记录 " + index))
                                    .setCallback(click -> add(index)));
                        }
                        case "D" -> {
                            if (index < MIN_INDEX || index > MAX_INDEX) break;
                            setSlot(slot, new GuiElementBuilder(class_1802.field_8793)
                                    .setName(class_2561.method_43470("删除 " + index))
                                    .setCallback(click -> delete(index)));
                        }
                    }

                }
            }
        }

        @Override
        public void onTick() {
            super.onTick();
            this.gapRecorders = new ArrayList<>(this.stack.method_58695(RDDataComponents.GAP_RECORDER, new ArrayList<>()));
            while (gapRecorders.size() <= MAX_INDEX) {
                this.gapRecorders.add(new GapRecorder("未记录", this.getPlayer().method_51469().method_27983().method_29177().toString(), class_2338.field_10980, false));
            }
            this.updateTeleportSlots();
        }


        private void updateTeleportSlots() {
            for (int col = 2; col <= 6; col++) {
                int index = col - 2;
                int slot = 0 * 9 + col;

                GapRecorder recorder = this.gapRecorders.get(index);
                boolean hasTarget = recorder != null && recorder.isEnable();
                class_1792 item = hasTarget ? class_1802.field_8449 : class_1802.field_8077;

                this.setSlot(slot, new GuiElementBuilder(item)
                        .setName(class_2561.method_43470("传送 " + index + (hasTarget ? (" - " + recorder.getName()) : "（未记录）")))
                        .setLore(List.of(
                                class_2561.method_43470("世界：" + recorder.getWorld()),
                                class_2561.method_43470("世界：" + recorder.getValue().getX() + " " + recorder.getValue().getY() + " " + recorder.getValue().getZ())
                        ))
                        .setCallback(click -> teleport(index)));
            }
        }

        public void teleport(int index) {
            GapRecorder recorder = this.gapRecorders.get(index);
            this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            if (recorder != null && recorder.isEnable()) {
                class_2338 pos = recorder.getValue();
                MinecraftServer server = this.player.method_5682();
                class_2960 id = class_2960.method_60654(recorder.getWorld());
                class_5321<class_1937> worldKey = class_5321.method_29179(class_7924.field_41223, id);
                class_3218 targetWorld = server.method_3847(worldKey);
                if (targetWorld == null) {
                    this.player.method_7353(class_2561.method_43470("目标世界不存在: " + id), false);
                    return;
                }
                this.player.method_48105(targetWorld,
                        pos.method_10263() + 0.5,
                        pos.method_10264(),
                        pos.method_10260() + 0.5,
                        EnumSet.noneOf(class_2709.class),
                        this.player.method_36454(),
                        this.player.method_36455(),
                        true);
                this.player.method_7353(class_2561.method_43470("已传送至：" + recorder.getName()), false);
                this.player.method_17356(class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
                this.player.method_7357().method_62835(this.stack, 3 * 20);
                this.close();
            } else {
                this.player.method_7353(class_2561.method_43470("目标位置不存在。"), false);
            }
        }

        public void add(int index) {
            class_2338 pos = this.player.method_24515();
            GapRecorder recorder = new GapRecorder("位置 " + index, this.getPlayer().method_51469().method_27983().method_29177().toString(), pos, true);
            player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            this.gapRecorders.set(index, recorder);
            this.stack.method_57379(RDDataComponents.GAP_RECORDER, this.gapRecorders);
            this.player.method_7353(class_2561.method_43470("已记录当前位置至槽位 " + index), false);
            this.init();
            this.stack.method_57379(RDDataComponents.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }

        public void delete(int index) {
            GapRecorder recorder = this.gapRecorders.get(index);
            player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            if (recorder != null) {
                recorder.setEnable(false);
                this.stack.method_57379(RDDataComponents.GAP_RECORDER, this.gapRecorders);
                this.player.method_7353(class_2561.method_43470("已清除槽位 " + index), false);
                this.init();
            }
            this.stack.method_57379(RDDataComponents.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }

        @Override
        public void onClose() {
            super.onClose();
            this.stack.method_57379(RDDataComponents.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }
    }

}
