package cc.thonly.reverie_dreams.item.weapon;

import cc.thonly.minecraft.api.ItemLeftClickCallback;
import cc.thonly.reverie_dreams.item.base.SwordItem;
import cc.thonly.reverie_dreams.registry.tag.RDBlockTags;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9886;
import java.util.List;

public class YukaFlowerUmbrella extends SwordItem {
    public static final class_9886 INSTANCE = new class_9886(RDBlockTags.EMPTY, 800, 7.25f, 5.5f, 10, RDItemTags.SILVER_TOOL_MATERIALS);
    private static final double SWEEP_RADIUS = 2.5;

    public YukaFlowerUmbrella(float attackDamage, float attackSpeed, class_1793 settings) {
        super(INSTANCE, attackDamage, attackSpeed, settings);
    }

    @Override
    public class_1269 method_7836(class_1937 level, class_1657 player, class_1268 interactionHand) {
        super.method_7836(level, player, interactionHand);
        if (!level.field_9236) {
            player.method_6092(new class_1293(class_1294.field_5904, 15, 4));
            return class_1269.field_5811;
        }
        return class_1269.field_5812;
    }

    @Override
    public int method_7881(class_1799 stack, class_1309 user) {
        return 40;
    }

    @Override
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    static {
        ItemLeftClickCallback.EVENT.register((level, player, hand) -> {
            if (level instanceof class_3218 world) {
                class_1799 itemStack = player.method_5998(hand);
                if (itemStack.method_7909() instanceof YukaFlowerUmbrella) {
                    class_243 center = player.method_19538().method_1031(0, player.method_17682() * 0.5, 0);
                    List<class_1297> targets = world.method_8333(
                            player,
                            player.method_5829().method_1014(SWEEP_RADIUS),
                            (e) -> e instanceof class_1309 && e != player
                    );
                    for (class_1297 target : targets) {
                        if (!(target instanceof class_1309 living)) {
                            continue;
                        }
                        if (target == player) {
                            continue;
                        }
                        if (target == player.method_5854()){
                            continue;
                        }
                        class_243 toTarget = living.method_19538().method_1020(center).method_1029();
                        class_243 look = player.method_5720().method_1029();
                        if (toTarget.method_1026(look) < 0.2) {
                            continue;
                        }
                        player.method_7324(living);
                        living.method_6005(0.5, player.method_23317() - living.method_23317(), player.method_23321() - living.method_23321());
                    }
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                if (player.method_6115()) {
                    class_1799 using = player.method_6030();
                    if (using.method_7909() instanceof YukaFlowerUmbrella) {
                        class_1297 vehicle = player.method_5854();
                        //noinspection ConditionCoveredByFurtherCondition
                        if (vehicle != null && vehicle instanceof class_1309 livingVehicle) {
                            livingVehicle.method_6092(new class_1293(class_1294.field_5904, 15, 4));
                            livingVehicle.method_6092(new class_1293(class_1294.field_5907, 15, 2));
                        }
                        player.method_6092(new class_1293(class_1294.field_5904, 15, 4));
                        player.method_6092(new class_1293(class_1294.field_5907, 15, 2));
                    }
                }
            }
        });
    }
}
