package cc.thonly.reverie_dreams.mixin;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.npc.NPCRole;
import cc.thonly.reverie_dreams.dialog.DialogPlayer;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleFastEntity;
import cc.thonly.reverie_dreams.item.builder.RoleCard;
import cc.thonly.reverie_dreams.item.template.RoleCardItem;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_11411;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2770;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_8609;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import java.util.Optional;

@Slf4j
@Mixin(class_8609.class)
public abstract class ServerCommonNetworkHandlerMixin {
    @Shadow @Final protected MinecraftServer server;

    @Inject(method = "handleCustomClickAction", at = @At("TAIL"))
    private void handleCustomClick(class_11411 packet, CallbackInfo ci) {
        try {
            if (!packet.comp_4294().method_12836().equals(ReverieDreams.MOD_ID)) {
                return;
            }
            switch (packet.comp_4294().method_12832()) {
                case "role/summon"-> {
                    Optional<class_2520> payload = packet.comp_4295();
                    if (payload.isEmpty()) {
                        return;
                    }
                    class_2520 element = payload.get();
                    if (!(element instanceof class_2487 compound)) {
                        return;
                    }
                    Optional<String> siOptional = compound.method_10558("session_id");
                    Optional<String> eiOptional = compound.method_10558("entity_id");
                    if (siOptional.isEmpty()) {
                        return;
                    }
                    if (eiOptional.isEmpty()) {
                        return;
                    }
                    String sessionId = siOptional.get();
                    String entityId = eiOptional.get();
                    RoleCardItem.UsingData usingData = RoleCardItem.USING_DATA_MAP.get(sessionId);
                    if (usingData == null) {
                        return;
                    }
                    if (entityId.equals("random")) {
                        RoleCard roleCard = usingData.getRoleCard();
                        Optional<NPCRole> roleWrapper = roleCard.random();
                        if (roleWrapper.isPresent()) {
                            class_3222 player = usingData.getPlayer();
                            class_3218 world = usingData.getWorld();
                            class_1799 itemStack = usingData.getItemStack();
                            NPCRole role = roleWrapper.get();
                            itemStack.method_57008(1, player);
                            class_1299<NPCRoleFastEntity> entityType = role.get();
                            entityType.method_47821(world, usingData.getBlockPos(), class_3730.field_16465);

                            world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15126, player.method_5634(), 2.0f, 1.0f);
                        }
                        RoleCardItem.USING_DATA_MAP.remove(sessionId);
                        return;
                    }
                    class_2960 identifier = class_2960.method_12829(entityId);
                    if (identifier == null) {
                        return;
                    }
                    NPCRole role = usingData.getId2Role().get(identifier);
                    if (role == null) {
                        return;
                    }
                    class_3222 player = usingData.getPlayer();
                    class_3218 world = usingData.getWorld();
                    class_1799 itemStack = usingData.getItemStack();
                    itemStack.method_57008(1, player);
                    class_1299<NPCRoleFastEntity> entityType = role.get();
                    entityType.method_47821(world, usingData.getBlockPos(), class_3730.field_16465);

                    world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_15126, player.method_5634(), 2.0f, 1.0f);
                    RoleCardItem.USING_DATA_MAP.remove(sessionId);
                }
                case "stop/dialog_video"-> {
                    Optional<class_2520> payload = packet.comp_4295();
                    if (payload.isEmpty()) {
                        return;
                    }
                    class_2520 element = payload.get();
                    if (!(element instanceof class_2487 compound)) {
                        return;
                    }
                    Optional<String> uidOptional = compound.method_10558("uid");
                    if (uidOptional.isEmpty()) {
                        return;
                    }
                    String uid = uidOptional.get();
                    for (Map.Entry<String, DialogPlayer> entry : DialogPlayer.INSTANCES.entrySet()) {
                        DialogPlayer dialogPlayer = entry.getValue();
                        class_3222 player = dialogPlayer.getPlayer();
                        if (player.method_5845().equals(uid)) {
                            dialogPlayer.remove();
                            class_3414 soundEvent = dialogPlayer.getSoundEvent();
                            if (soundEvent != null) {
                                class_2770 stopSoundS2CPacket = new class_2770(soundEvent.comp_3319(), class_3419.field_15248);
                                player.field_13987.method_14364(stopSoundS2CPacket);
                            }
                        }
                    }
                }
            }

        } catch (Exception err) {
            log.error("Can't parse custom click action packet");
        }
    }
}
