package cc.thonly.reverie_dreams.mixin.entity;

import cc.thonly.reverie_dreams.item.armor.WaterproofArmor;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public abstract class EntityMixin {
    @Shadow
    public abstract boolean isAlive();

    @Shadow
    public abstract class_1937 level();

    @Shadow
    public abstract void gameEvent(class_6880<class_5712> event, @Nullable class_1297 entity);

    @Inject(method = {"isInWater", "isUnderWater", "isInWaterOrRain"}, at = @At("HEAD"), cancellable = true)
    public void modifyInWater(CallbackInfoReturnable<Boolean> cir) {
        class_1297 entity = ((class_1297)(Object) this);
        if (!(entity instanceof class_1309 livingEntity)) {
            return;
        }
        if (WaterproofArmor.hasEquipment(livingEntity)) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method = "updateInWaterStateAndDoWaterCurrentPushing", at = @At("HEAD"), cancellable = true)
    public void modifyInWaterTick(CallbackInfo ci) {
        class_1297 entity = ((class_1297)(Object) this);
        if (!(entity instanceof class_1309 livingEntity)) {
            return;
        }
        if (WaterproofArmor.hasEquipment(livingEntity)) {
            ci.cancel();
        }
    }

    @Inject(method = "clearFire", at = @At("HEAD"), cancellable = true)
    public void modifyClearFire(CallbackInfo ci) {
        class_1297 entity = ((class_1297)(Object) this);
        if (!(entity instanceof class_1309 livingEntity)) {
            return;
        }
        if (WaterproofArmor.hasEquipment(livingEntity)) {
            ci.cancel();
        }
    }
}
