package cc.thonly.reverie_dreams.mixin.entity;

import cc.thonly.reverie_dreams.config.ReverieDreamsConfiguration;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.inf.IBedBlockEntity;
import cc.thonly.reverie_dreams.inf.ILivingEntity;
import cc.thonly.reverie_dreams.inf.IWorld;
import cc.thonly.reverie_dreams.item.armor.DreamArmorItem;
import cc.thonly.reverie_dreams.item.prop.DreamPillowItem;
import cc.thonly.reverie_dreams.registry.content.effect.RDStatusEffects;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2587;
import net.minecraft.class_2709;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

@SuppressWarnings("AddedMixinMembersNamePattern")
@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements ILivingEntity {
    @Shadow
    public abstract boolean hasEffect(class_6880<class_1291> effect);

    @Shadow
    public abstract boolean addEffect(class_1293 effect);

    @Shadow
    public abstract void setHealth(float health);

    @Shadow
    public abstract float getMaxHealth();

    @Shadow
    public abstract float getHealth();

    @Shadow
    @Nullable
    protected abstract class_3414 getDeathSound();

    @Shadow
    protected abstract @Nullable class_3414 getHurtSound(class_1282 source);

    @Shadow
    @Nullable
    public abstract class_1324 getAttribute(class_6880<class_1320> attribute);

    @Shadow
    public abstract class_1799 getItemBySlot(class_1304 slot);

    @Shadow
    public abstract Optional<class_2338> getSleepingPos();

    @Shadow
    public float yHeadRot;

    @Unique
    public double manpozuchiUsingState = 1;
    @Unique
    public float maxHealthModifier = 0f;
    @Unique
    public int deathLevel = 0;
    @Unique
    private int deathLevelResetTimer = 0;
    @Unique
    private class_3218 kanjuWorld;
    @Unique
    private class_2338 kanjuBlockPos = new class_2338(0, 0, 0);
    @Unique
    private class_2338 tempSleepPosition;


    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public void setKanju(class_3218 world, class_2338 blockPos) {
        this.kanjuWorld = world;
        this.kanjuBlockPos = blockPos;
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    public void initMaxHealth(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo ci) {
        if (this.maxHealthModifier < 0) {
            this.maxHealthModifier = 0;
        }
        class_1324 maxHealthAttributeInstance = this.getAttribute(class_5134.field_23716);
        if (maxHealthAttributeInstance != null) {
            maxHealthAttributeInstance.method_6192(Math.abs(this.getMaxHealth() + this.maxHealthModifier));
        }
        if (world instanceof class_3218) {
            this.kanjuWorld = (class_3218) world;
        }
    }

    @Inject(method = "stopSleeping", at = @At(value = "HEAD"))
    public void wakeUpHead(CallbackInfo ci) {
        Optional<class_2338> blockPos = this.field_6011.method_12789(class_1309.field_18073);
        blockPos.ifPresent(pos -> this.tempSleepPosition = pos);
    }

    @Inject(method = "stopSleeping", at = @At(value = "TAIL"))
    public void wakeUp(CallbackInfo ci) {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        class_1937 world = this.method_37908();
        if (!(world instanceof class_3218 serverWorld)) {
            return;
        }
        IWorld iWorld = (IWorld) world;
        class_5321<class_1937> dreamWorldKey = iWorld.getDreamWorld();
        class_3218 dreamWorld = server.method_3847(dreamWorldKey);
        if (dreamWorld == null) {
            return;
        }
        class_3218 overworld = server.method_30002();
        if (serverWorld.equals(dreamWorld)) {
            class_2338 spawnPos = overworld.method_43126();
            this.method_48105(server.method_30002(), spawnPos.method_10263() + 0.5, spawnPos.method_10264(), spawnPos.method_10260() + 0.5,
                    EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
            serverWorld.method_65096(class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);
            return;
        }
        Optional.ofNullable(this.tempSleepPosition).ifPresent(pos -> {
            class_3545<Boolean, class_2338> bedHead = DreamPillowItem.getBedHead(serverWorld, pos);
            if (
                    bedHead.method_15442() &&
                            this.method_37908().method_8321(bedHead.method_15441()) instanceof class_2587 bedBlockEntity &&
                            this.method_37908() == server.method_30002()
            ) {
                IBedBlockEntity iBedBlockEntity = (IBedBlockEntity) bedBlockEntity;
                if (iBedBlockEntity.hasDreamPillow()) {
                    this.addEffect(new class_1293(class_1294.field_5924, 20 * 5));
                    this.method_48105(dreamWorld, this.method_23317() + 0.5, this.method_23318(), this.method_23321() + 0.5,
                            EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);

                    class_2338 targetPos = findSafeTeleportPos(dreamWorld, new class_2338((int) this.method_23317(), (int) this.method_23318(), (int) this.method_23321()));
                    this.method_48105(dreamWorld, targetPos.method_10263() + 0.5, targetPos.method_10264() + 5, targetPos.method_10260() + 0.5,
                            EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                    serverWorld.method_65096(class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 5, 0.5, 0.5, 0.5, 0.1);

                }
            }
        });
    }

    @Unique
    private class_2338 findSafeTeleportPos(class_3218 world, class_2338 pos) {
        return world.method_8598(class_2902.class_2903.field_13194, pos);
    }

    @Unique
    public void fixedPlayerData() {
        class_1324 maxHealthAttributeInstance = this.getAttribute(class_5134.field_23716);
        if (this.maxHealthModifier > ReverieDreamsConfiguration.MAX_UPGRADED_HEALTH_VALUE && maxHealthAttributeInstance != null) {
            this.maxHealthModifier--;
            maxHealthAttributeInstance.method_6192(maxHealthAttributeInstance.method_6194() - 1);
        }
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void tick(CallbackInfo ci) {
        class_1309 livingEntity = (class_1309) (Object) this;
        if (livingEntity.method_37908().field_9236) {
            return;
        }
        this.fixedPlayerData();
        this.processDeathLevel();
    }

    @Unique
    public void processDeathLevel() {
        if (this.hasEffect(RDStatusEffects.ELIXIR_OF_LIFE)) {
            if (this.deathLevel == 1) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 0));
            }
            if (this.deathLevel == 2) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 1));
            }
            if (this.deathLevel == 3) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 2));
                this.addEffect(new class_1293(class_1294.field_5901, 20, 0));
            }
            if (this.deathLevel == 3) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 3));
                this.addEffect(new class_1293(class_1294.field_5901, 20, 1));
                this.addEffect(new class_1293(class_1294.field_5911, 20, 0));
            }
            if (this.deathLevel == 3) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 3));
                this.addEffect(new class_1293(class_1294.field_5901, 20, 2));
                this.addEffect(new class_1293(class_1294.field_5911, 20, 1));
            }
            if (this.deathLevel > 3) {
                this.addEffect(new class_1293(class_1294.field_5909, 20, 3));
                this.addEffect(new class_1293(class_1294.field_5901, 20, 2));
                this.addEffect(new class_1293(class_1294.field_5911, 20, 2));
            }
        } else {
            this.deathLevel = 0;
        }

        if (!this.method_37908().method_8608()) {
            MinecraftServer server = this.method_37908().method_8503();
            class_1937 world = this.method_37908();
            double mobY = this.method_23318();
            class_5321<class_1937> moonKey = ((IWorld) world).getMoon();
            class_5321<class_1937> registryKey = world.method_27983();
            if (server != null) {
                class_3218 moonWorld = server.method_3847(moonKey);
                class_3218 endWorld = server.method_3847(class_1937.field_25181);
                if (moonWorld != null && endWorld != null) {
                    if (registryKey.equals(class_1937.field_25181)) {
                        if (mobY >= endWorld.method_31605()) {
                            this.method_48105(moonWorld, this.method_23317(), moonWorld.method_31605() - 1, this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                        }
                    } else if (registryKey.equals(moonKey)) {
                        this.addEffect(new class_1293(class_1294.field_5906, 1, 0));
                        if (mobY >= moonWorld.method_31605()) {
                            this.addEffect(new class_1293(class_1294.field_5906, 40 * 20, 0));
                            this.method_48105(endWorld, this.method_23317(), endWorld.method_31605() - 1, this.method_23321(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
                        }
                    }
                }
            }
        }

        if (!this.method_37908().method_8608()) {
            this.deathLevelResetTimer++;
            if (this.deathLevelResetTimer >= 18000) {
                this.deathLevel = Math.max(0, this.deathLevel - 1);
                this.deathLevelResetTimer = 0;
            }
        }
    }

    @Inject(method = "hurtServer", at = @At("HEAD"), cancellable = true)
    public void damage(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        MinecraftServer server = this.method_5682();
        if (server == null) {
            return;
        }
        boolean isPlayer = ((class_1309) (Object) this) instanceof class_1657;
        boolean deathInElixir = this.deathInElixir(world, source, amount, cir);
        boolean deathInKanju = this.deathInKanju(world, source, amount, cir);
        if (!deathInElixir && !deathInKanju) {
            this.deathByDanmakuEntity(world, source, amount, cir);
            if ((this.getHealth() - amount <= 0f)) {
                IWorld iWorld = (IWorld) world;
                class_5321<class_1937> dreamWorldKey = iWorld.getDreamWorld();
                class_3218 dreamWorld = server.method_3847(dreamWorldKey);
                if (this.method_37908().equals(dreamWorld) && isPlayer) {
                    this.setHealth(this.getMaxHealth());
                    this.field_6017 = 0;
                    this.method_48105(
                            server.method_30002(),
                            server.method_30002().method_43126().method_10263() + 0.5,
                            server.method_30002().method_43126().method_10264() + 1.5,
                            server.method_30002().method_43126().method_10260() + 0.5,
                            EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true
                    );
                    return;
                }
                class_1324 maxHealthAttributeInstance = this.getAttribute(class_5134.field_23716);
                if (maxHealthAttributeInstance != null) {
                    if (this.getMaxHealth() > 20) {
                        maxHealthAttributeInstance.method_6192(Math.abs(this.getMaxHealth() - 2));
                    }
                }
            }
        }
    }

    @Inject(method = "hurtServer", at = @At("RETURN"), cancellable = true)
    public void damageAfter(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        List<class_1799> armorStacks = List.of(
                this.getItemBySlot(class_1304.field_6169),
                this.getItemBySlot(class_1304.field_6174),
                this.getItemBySlot(class_1304.field_6172),
                this.getItemBySlot(class_1304.field_6166)
        );
        Stream<class_1792> itemStream = armorStacks.stream().filter(stack -> stack.method_31573(RDItemTags.DREAM_ARMOR)).map(class_1799::method_7909).filter(item -> item instanceof DreamArmorItem);
        if (!itemStream.toList().isEmpty()) {
            class_5819 random = class_5819.method_43047();
            if (random.method_39332(0, 100) < 39) {
                this.addEffect(new class_1293(class_1294.field_5924, 5 * 20));
            }
        }
    }

    @Unique
    public boolean deathByDanmakuEntity(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if ((this.getHealth() - amount <= 0f) && source.method_5526() instanceof DanmakuEntity) {
            class_1297 self = (class_1297) this;
            self.method_5783(SoundEventInit.BIU, 0.32F, 1.0F);
            return true;
        }
        return false;
    }

    @Unique
    public boolean deathInKanju(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.kanjuWorld == null) {
            return false;
        }
        if (this.kanjuWorld instanceof class_3218 serverWorld && this.hasEffect(RDStatusEffects.KANJU_KUSURI) && (this.getHealth() - amount <= 0f)) {
            this.setHealth(1f);
            this.setHealth(this.getMaxHealth());
//            System.out.println(1);
            this.method_48105(serverWorld, this.kanjuBlockPos.method_10263(), this.kanjuBlockPos.method_10264(), this.kanjuBlockPos.method_10260(), EnumSet.noneOf(class_2709.class), this.method_36454(), this.method_36455(), true);
            return true;
        }
        return false;
    }

//    @Inject(method = "onDeath", at = {
//            @At("HEAD"),
//            @At("TAIL")
//    })
//    public void test(CallbackInfo ci){
//        Thread.dumpStack();
//    }

    @Unique
    public boolean deathInElixir(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.hasEffect(RDStatusEffects.ELIXIR_OF_LIFE) && (this.getHealth() - amount <= 0f)) {
            this.deathLevel++;
            this.setHealth(1f);
            this.setHealth(this.getMaxHealth());
            class_3414 hurtSound = getHurtSound(source);
            class_3414 deathSound = getDeathSound();
            this.method_5783(hurtSound, 1.0f, 1.0f);
            this.method_5783(deathSound, 1.0f, 1.0f);
            this.method_5783(class_3417.field_14931, 1.0f, 1.0f);
            for (var player : world.method_18456()) {
                world.method_14166(player, class_2398.field_11220, true, false, this.method_23317(), this.method_23318(), this.method_23321(), 250, 1.5, 2, 1.5, 0.5);
            }
//            System.out.println("deathInElixir");
            cir.cancel();
            return true;
        }
        return false;
    }

    @Inject(method = "die", at = @At("HEAD"), cancellable = true)
    public void onDie(CallbackInfo ci) {
        if (this.maxHealthModifier >= 1) {
            this.maxHealthModifier--;
        }
        if (this.maxHealthModifier < 0) {
            this.maxHealthModifier = 0;
        }
    }

    @Inject(method = "addAdditionalSaveData", at = @At("HEAD"))
    public void writeCustomDataToNbt(class_11372 view, CallbackInfo ci) {
        class_5455 registryManager = this.method_56673();
        view.method_71464("MaxHealthModifier", this.maxHealthModifier);
        view.method_71465("DeathCount", this.deathLevel);
        view.method_71465("DeathCountResetTimer", this.deathLevelResetTimer);
        view.method_71463("ManpozuchiUsingState", this.manpozuchiUsingState);
        view.method_71469("KanjuWorld", this.kanjuWorld.method_27983().method_29177().toString());
        view.method_71466("KanjuBlockPos", this.kanjuBlockPos.method_10063());
    }

    @Inject(method = "readAdditionalSaveData", at = @At("HEAD"))
    public void readCustomDataFromNbt(class_11368 view, CallbackInfo ci) {
        class_5455 registryManager = this.method_56673();
        MinecraftServer server = this.method_5682();
        this.maxHealthModifier = view.method_71423("MaxHealthModifier", 0.0f);
        this.deathLevel = view.method_71424("DeathCount", 0);
        this.deathLevelResetTimer = view.method_71424("DeathCountResetTimer", 0);
        this.manpozuchiUsingState = view.method_71422("ManpozuchiUsingState", 0.0);
        String kanjuWorldStr = view.method_71428("KanjuWorld", "");
        if (!kanjuWorldStr.isEmpty()) {
            if (server != null) {
                this.kanjuWorld = server.method_3847(class_5321.method_29179(class_7924.field_41223, class_2960.method_60654(kanjuWorldStr)));
            }
        }
        this.kanjuBlockPos = class_2338.method_10092(view.method_71425("KanjuBlockPos", new class_2338(0, 0, 0).method_10063()));
    }

    @Override
    public void setDeathLevel(int deathLevel) {
        this.deathLevel = deathLevel;
    }

    @Override
    public int getDeathLevel() {
        return deathLevel;
    }

    @Override
    public void setMaxHealthModifier(float value) {
        this.maxHealthModifier = value;
    }

    @Override
    public float getMaxHealthModifier() {
        return this.maxHealthModifier;
    }

    @Override
    public void setManpozuchiUsingState(double value) {
        this.manpozuchiUsingState = value;
    }

    @Override
    public double getManpozuchiUsingState() {
        return this.manpozuchiUsingState;
    }
}

