package cc.thonly.reverie_dreams.mixin.item;

import cc.thonly.minecraft.api.ItemPostHitCallback;
import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.inf.IPlayerEntity;
import cc.thonly.reverie_dreams.item.base.FoodItem;
import cc.thonly.reverie_dreams.item.base.IngredientItem;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import net.fabricmc.fabric.api.item.v1.FabricItem;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7695;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import java.util.function.Consumer;

@Mixin(class_1792.class)
public abstract class ItemMixin implements class_7695, class_1935, FabricItem {
    @Inject(method = "hurtEnemy", at = @At("TAIL"))
    public void postHitCallback(class_1799 stack, class_1309 target, class_1309 attacker, CallbackInfo ci) {
        ItemPostHitCallback.EVENT.invoker().postHit(stack, target, attacker);
    }

    @Inject(method = "inventoryTick", at = @At("HEAD"))
    public void inventoryTick(class_1799 itemStack, class_3218 level, class_1297 entity, class_1304 slot, CallbackInfo ci) {
        if (entity instanceof IPlayerEntity iPlayerEntity) {
            if (itemStack.method_31573(RDItemTags.SILVER_ITEM)) {
                iPlayerEntity.setNonSleepingTime(0);
            }
        }
    }

    @Inject(method = "useOn", at = @At("HEAD"), cancellable = true)
    public void usePaperOnSpiritualStrippedLog(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        class_1657 player = context.method_8036();
        class_1268 hand = context.method_20287();
        class_1937 level = context.method_8045();
        if (player == null) {
            return;
        }
        class_1799 itemStack = player.method_5998(hand);
        if (!itemStack.method_31574(class_1802.field_8407)) {
            return;
        }

        class_2338 blockPos = context.method_8037();
        class_2680 blockState = level.method_8320(blockPos);
        if (blockState.method_27852(RDWoodBlocks.SPIRITUAL.strippedLog())) {
            if (level.field_9236) {
                cir.setReturnValue(class_1269.field_5812);
                cir.cancel();
            } else {
                level.method_8652(blockPos, RDWoodBlocks.BLESSED_SPIRITUAL_LOG.method_34725(blockState), class_2248.field_31031);
                level.method_8396(null, blockPos, class_3417.field_59992, class_3419.field_15245, 1.0f, 1.0f);
                itemStack.method_57008(1, player);
                cir.setReturnValue(class_1269.field_52422);
                cir.cancel();
            }
        }


    }

    @Inject(method = "appendHoverText", at = @At("HEAD"))
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type, CallbackInfo ci) {
        class_1792 item = this.method_8389();
        if (item instanceof IngredientItem || item instanceof FoodItem) {
            return;
        }
        List<FoodProperty> foodProperties = FoodProperty.getIngredientProperties(item);
        if (!foodProperties.isEmpty()) {
            textConsumer.accept(class_2561.method_43473().method_10852(class_2561.method_43471("item.tooltip.food_properties")));
        }
        for (FoodProperty foodProperty : foodProperties) {
            textConsumer.accept(class_2561.method_43473().method_27693(FoodProperty.getDisplayPrefix(stack, foodProperty)).method_10852(foodProperty.getTooltip()));
        }
    }
}
