package cc.thonly.reverie_dreams.mixin.item;

import cc.thonly.reverie_dreams.entity.villager.TavernVillager;
import cc.thonly.reverie_dreams.inf.IItemStack;
import cc.thonly.reverie_dreams.item.base.DrinkItem;
import cc.thonly.reverie_dreams.item.base.FoodItem;
import cc.thonly.reverie_dreams.server.ItemDescriptionManager;
import net.fabricmc.fabric.api.item.v1.FabricItemStack;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_9322;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;

@Mixin(class_1799.class)
public abstract class ItemStackMixin<T> implements IItemStack,
        class_9322,
        FabricItemStack {
    @Shadow
    public abstract class_1792 getItem();

    @Shadow
    public abstract boolean isEmpty();

    @Shadow public abstract void consume(int amount, @Nullable class_1309 entity);

    @Shadow public abstract class_9323 method_57353();

    @Shadow @Final public class_9335 components;

    @Shadow @Final @Deprecated private @Nullable class_1792 item;

    @Inject(method = "interactLivingEntity", at = @At("HEAD"), cancellable = true)
    public void useOnVillager(class_1657 user, class_1309 entity, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (entity instanceof class_1646 villager && this.getItem() == class_1802.field_16307) {
            if (user.method_37908() instanceof class_3218 world) {
                class_2338 blockPos = entity.method_24515();
                class_243 pos = villager.method_19538();
                class_2561 name = villager.method_5477();
                boolean hasCN = villager.method_16914();
                villager.method_31472();
                TavernVillager sellerVillager = new TavernVillager(villager.method_7231(), world);
                sellerVillager.method_23327(pos.method_10216(), pos.method_10214(), pos.method_10215());
                if (hasCN) {
                    sellerVillager.method_5665(name);
                }
                world.method_8649(sellerVillager);
                world.method_45447(null, blockPos, class_3417.field_14727, class_3419.field_15248);

                this.consume(1, user);
                user.method_6104(hand);

                cir.setReturnValue(class_1269.field_52422);
            } else {
                cir.setReturnValue(class_1269.field_5812);
            }
        }
    }

    @Inject(method = "getTooltipLines", at = @At("RETURN"), cancellable = true)
    public void appendTooltip(class_1792.class_9635 context, @Nullable class_1657 player, class_1836 type, CallbackInfoReturnable<List<class_2561>> cir) {
        if (this.isEmpty()) {
            return;
        }
        class_1792 item = this.getItem();
        List<class_5250> texts = ItemDescriptionManager.getDescription(item);
        try {
            if (!texts.isEmpty()) {
                List<class_2561> textList = cir.getReturnValue();
                textList.addAll(texts);
            }
        } catch (Exception ignored) {
        }
    }

    @Unique
    @Override
    public boolean isFood() {
        class_1792 item = this.getItem();
        if (item instanceof FoodItem) {
            return true;
        }
//        System.out.println(item);
//        this.components.forEach(component -> System.out.println(component.type()));
        return this.components.method_57832(class_9334.field_50075);
    }

    @Unique
    @Override
    public boolean isDrink() {
        class_1792 item = this.getItem();
        return item instanceof DrinkItem;
    }
}
