package cc.thonly.reverie_dreams.recipe.type;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.data.danmaku.DanmakuType;
import cc.thonly.reverie_dreams.item.danmaku.DanmakuItem;
import cc.thonly.reverie_dreams.item.template.SpellCardTemplateItem;
import cc.thonly.reverie_dreams.recipe.BaseRecipeType;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.StrengthTableRecipe;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponents;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTemplates;
import cc.thonly.reverie_dreams.registry.content.item.RDItems;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Slf4j
@SuppressWarnings("unchecked")
public class StrengthTableRecipeType extends BaseRecipeType<StrengthTableRecipe> {
    private static StrengthTableRecipeType INSTANCE;
    private final Map<String, Integer> automaticRecipeIdCounter = new Object2ObjectOpenHashMap<>();
    private final LinkedHashMap<class_2960, StrengthTableRecipe> dynamicBuilder = new LinkedHashMap<>();
    private static final float MAX_SPEED = 2.5f;
    private static final int MAX_COUNT = 3;
    private static final float MAX_DAMAGE = 5.5f;

    public StrengthTableRecipeType() {
        INSTANCE = this;
    }

    public static synchronized StrengthTableRecipeType getInstance() {
        return INSTANCE;
    }

    @Override
    public void reload(class_3300 manager) {
        this.dynamicBuilder.clear();
        this.automaticRecipeIdCounter.clear();
        Map<class_2960, class_3298> resources = manager.method_14488((this.getTypeId() + "_recipe"), id -> {
            return id.method_12836().equals(ReverieDreams.MOD_ID) && id.method_12832().endsWith(".json");
        });
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 id = entry.getKey();
            class_2960 registryKey = class_2960.method_60655(id.method_12836(), id.method_12832().replaceFirst("^strength_table_recipe/", "").replaceAll("\\.json$", ""));
            class_3298 resource = entry.getValue();
            try (InputStream stream = resource.method_14482()) {
                JsonElement json = JsonParser.parseReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, json);

                DataResult<StrengthTableRecipe> result = this.getCodec().parse(input);

                result.resultOrPartial(error -> log.error("Failed to load strength table recipe {}, {}", id, error))
                        .ifPresent(recipe -> {
                            this.add(registryKey, recipe);
                        });
            } catch (IOException e) {
                log.error("Failed to load strength table recipe {}, {}, {}", id, e.getMessage(), e);
            }
        }
        List<class_1792> danmakuItemView = RegistryHandlers.DANMAKU_TYPE
                .values().stream().map(DanmakuType::getItem).toList();
        List<class_1799> danmakuItemStackView = danmakuItemView.stream().map(class_1792::method_7854).toList();
        List<class_1799> templateStackView = DanmakuTemplates.getRegistryItemStackView().values().stream().map(class_1799::method_7972).toList();

        this.registerAutomaticDynamic(danmakuItemStackView, templateStackView, RDDataComponents.DANMAKU_PROPERTIES);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(RDItems.SPEED_FEATHER.method_7854()), RDDataComponents.DANMAKU_PROPERTIES);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(class_1802.field_8828.method_7854()), RDDataComponents.DANMAKU_PROPERTIES);
        this.registerAutomaticDynamic(danmakuItemStackView, List.of(class_1802.field_8371.method_7854()), RDDataComponents.DANMAKU_PROPERTIES);

        Map<class_2960, StrengthTableRecipe> sortedByKey = this.dynamicBuilder.entrySet().stream()
                .sorted(Map.Entry.comparingByKey())
                .collect(
                        LinkedHashMap::new,
                        (m, e) -> m.put(e.getKey(), e.getValue()),
                        Map::putAll
                );
        sortedByKey.forEach(this::add);
    }

    @SuppressWarnings("rawtypes")
    private void registerAutomaticDynamic(List<class_1799> main, List<class_1799> off, class_9331 componentType) {
        class_1799[] mainItems = main.toArray(new class_1799[0]);
        class_1799[] offItems = off.toArray(new class_1799[0]);

        for (class_1799 mainItem : mainItems) {
            for (class_1799 offItem : offItems) {
                String value = null;
                try {
                    String mainItemIdStr = class_7923.field_41178.method_10221(mainItem.method_7909()).method_12832();
                    String offItemIdStr = class_7923.field_41178.method_10221(offItem.method_7909()).method_12832();
                    String builder = mainItemIdStr + offItemIdStr;
                    Integer num = this.automaticRecipeIdCounter.computeIfAbsent(builder, (x) -> 0);
                    String builderByCounter = builder + "_" + num;
                    this.automaticRecipeIdCounter.put(builder, ++num);
                    class_1799 outputStack = mainItem.method_7972();
                    Object object = offItem.method_58694(componentType);
                    if (object != null) {
                        outputStack.method_57379(componentType, object);
                    }
                    value = builderByCounter;
                    StrengthTableRecipe strengthTableRecipe = new StrengthTableRecipe(ItemStackWrapper.of(mainItem), ItemStackWrapper.of(offItem), ItemStackWrapper.of(outputStack));
                    strengthTableRecipe.setVirtual(true);
                    this.dynamicBuilder.put(class_2960.method_60654(builderByCounter.toLowerCase()), strengthTableRecipe);
                } catch (Exception e) {
                    log.error("Can't register dynamic recipe, id: {} , {}", value, e);
                }
            }
        }
    }

    @Override
    public void bootstrap() {

    }

    @Override
    public List<StrengthTableRecipe> getMatches(List<ItemStackWrapper> wrappers) {
        if (wrappers.size() < 2) {
            return List.of();
        }
        List<StrengthTableRecipe> recipe = new ArrayList<>();
        ItemStackWrapper main = wrappers.get(0);
        ItemStackWrapper off = wrappers.get(1);
        ItemStackWrapper output = this.tryGetOutput(main, off);
        if (output != null) {
            ItemStackWrapper mainClone = main.clone();
            ItemStackWrapper offClone = off.clone();
            ItemStackWrapper outputClone = output.clone();
            mainClone.getItemStack().setCount(1);
            offClone.getItemStack().setCount(1);
            recipe.add(new StrengthTableRecipe(mainClone, offClone, outputClone));
        }
        return recipe;
    }

    public ItemStackWrapper tryGetOutput(ItemStackWrapper main, ItemStackWrapper off) {
        class_1799 mainStack = main.getItemStack().copy();
        class_1799 offStack = off.getItemStack().copy();
        class_1792 mainItem = mainStack.method_7909();
        class_1792 offItem = offStack.method_7909();
        boolean isDanmakuItem = mainItem instanceof DanmakuItem;
        boolean isSpellCardTemplate = offItem instanceof SpellCardTemplateItem;
        boolean isSpeedItem = offItem == RDItems.SPEED_FEATHER;
        boolean isSlime = offItem == class_1802.field_8828;
        boolean isIronSword = offItem == class_1802.field_8371;
        if (isDanmakuItem && isSpellCardTemplate) {
            DanmakuProperties component = mainStack.method_58695(RDDataComponents.DANMAKU_PROPERTIES, DanmakuProperties.ofDefault());
            DanmakuProperties properties = offStack.method_58694(RDDataComponents.DANMAKU_PROPERTIES);
            if (properties != null) {
                mainStack.method_57379(RDDataComponents.DANMAKU_PROPERTIES, component.withTemplateId(properties.getTemplateId()));
                return new ItemStackWrapper(mainStack);
            }
        }
        if (isDanmakuItem && isSpeedItem) {
            DanmakuProperties component = mainStack.method_58695(RDDataComponents.DANMAKU_PROPERTIES, DanmakuProperties.ofDefault());
            float speed = component.getSpeed();
            float sum = speed + 0.25f;
            if (sum <= MAX_SPEED) {
                mainStack.method_57379(RDDataComponents.DANMAKU_PROPERTIES, component.withSpeed(sum));
                return new ItemStackWrapper(mainStack);
            }
        }
        if (isDanmakuItem && isSlime) {
            DanmakuProperties component = mainStack.method_58695(RDDataComponents.DANMAKU_PROPERTIES, DanmakuProperties.ofDefault());
            int count = component.getCount();
            int sum = count + 1;
            if (sum < MAX_COUNT) {
                mainStack.method_57379(RDDataComponents.DANMAKU_PROPERTIES, component.withCount(sum));
                return new ItemStackWrapper(mainStack);
            }
        }
        if (isDanmakuItem && isIronSword) {
            DanmakuProperties component = mainStack.method_58695(RDDataComponents.DANMAKU_PROPERTIES, DanmakuProperties.ofDefault());
            float sum = component.getDamage() + 0.25f;
            if (sum < MAX_DAMAGE) {
                mainStack.method_57379(RDDataComponents.DANMAKU_PROPERTIES, component.withDamage(sum));
                return new ItemStackWrapper(mainStack);
            }
        }
        return null;
    }

    @Override
    public Boolean isMatch(ItemStackWrapper input, ItemStackWrapper recipe) {
        return false;
    }

    @Override
    public Codec<StrengthTableRecipe> getCodec() {
        return StrengthTableRecipe.CODEC;
    }

    @Override
    public String getTypeId() {
        return "strength_table";
    }

    @Override
    public class_2960 getId() {
        return ReverieDreams.id(this.getTypeId());
    }
}
